/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.extendeds3;

import com.emc.object.s3.S3Client;
import com.emc.object.s3.S3Config;
import com.emc.object.s3.jersey.S3JerseyClient;
import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.extendeds3.ExtendedS3Storage;
import io.pravega.storage.extendeds3.ExtendedS3StorageConfig;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class ExtendedS3StorageFactory
implements StorageFactory {
    private final ExtendedS3StorageConfig config;
    private final ExecutorService executor;

    public ExtendedS3StorageFactory(ExtendedS3StorageConfig config, ExecutorService executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.config = config;
        this.executor = executor;
    }

    public Storage createStorageAdapter() {
        S3Config s3Config = (S3Config)((S3Config)((S3Config)new S3Config(this.config.getUrl()).withIdentity(this.config.getAccessKey())).withSecretKey(this.config.getSecretKey())).withNamespace(this.config.getNamespace());
        S3JerseyClient client = new S3JerseyClient(s3Config);
        ExtendedS3Storage s = new ExtendedS3Storage((S3Client)client, this.config);
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)s), (Executor)this.executor);
    }
}

