/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.filesystem;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.SegmentHandle;

public class FileSystemSegmentHandle
implements SegmentHandle {
    private final String segmentName;
    private final boolean isReadOnly;

    public FileSystemSegmentHandle(String streamSegmentName, boolean isReadOnly) {
        this.segmentName = (String)Preconditions.checkNotNull((Object)streamSegmentName, (Object)"segmentName");
        this.isReadOnly = isReadOnly;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public static FileSystemSegmentHandle readHandle(String streamSegmentName) {
        return new FileSystemSegmentHandle(streamSegmentName, true);
    }

    public static FileSystemSegmentHandle writeHandle(String streamSegmentName) {
        return new FileSystemSegmentHandle(streamSegmentName, false);
    }
}

