/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.segmentstore.storage.SegmentHandle;
import org.apache.http.annotation.ThreadSafe;

@ThreadSafe
class HDFSSegmentHandle
implements SegmentHandle {
    private final String segmentName;
    private final boolean readOnly;

    private HDFSSegmentHandle(String segmentName, boolean readOnly) {
        this.segmentName = Exceptions.checkNotNullOrEmpty((String)segmentName, (String)"segmentName");
        this.readOnly = readOnly;
    }

    static HDFSSegmentHandle write(String segmentName) {
        return new HDFSSegmentHandle(segmentName, false);
    }

    static HDFSSegmentHandle read(String segmentName) {
        return new HDFSSegmentHandle(segmentName, true);
    }

    public String toString() {
        return String.format("[%s] %s", this.readOnly ? "R" : "RW", this.segmentName);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getSegmentName() {
        return this.segmentName;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

