/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.util.ConfigBuilder;
import io.pravega.common.util.ConfigurationException;
import io.pravega.common.util.Property;
import io.pravega.common.util.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSStorageConfig {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(HDFSStorageConfig.class);
    public static final Property<String> URL = Property.named((String)"hdfsUrl", (Object)"localhost:9000");
    public static final Property<String> ROOT = Property.named((String)"hdfsRoot", (Object)"");
    public static final Property<Integer> REPLICATION = Property.named((String)"replication", (Object)3);
    public static final Property<Integer> BLOCK_SIZE = Property.named((String)"blockSize", (Object)0x100000);
    public static final Property<Boolean> REPLACE_DATANODES_ON_FAILURE = Property.named((String)"replaceDataNodesOnFailure", (Object)true);
    private static final String COMPONENT_CODE = "hdfs";
    private final String hdfsHostURL;
    private final String hdfsRoot;
    private final short replication;
    private final long blockSize;
    private final boolean replaceDataNodesOnFailure;

    private HDFSStorageConfig(TypedProperties properties) throws ConfigurationException {
        this.hdfsHostURL = properties.get(URL);
        this.hdfsRoot = properties.get(ROOT);
        this.replication = (short)properties.getInt(REPLICATION);
        this.blockSize = properties.getInt(BLOCK_SIZE);
        this.replaceDataNodesOnFailure = properties.getBoolean(REPLACE_DATANODES_ON_FAILURE);
    }

    public static ConfigBuilder<HDFSStorageConfig> builder() {
        return new ConfigBuilder(COMPONENT_CODE, HDFSStorageConfig::new);
    }

    @SuppressFBWarnings(justification="generated code")
    public String getHdfsHostURL() {
        return this.hdfsHostURL;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getHdfsRoot() {
        return this.hdfsRoot;
    }

    @SuppressFBWarnings(justification="generated code")
    public short getReplication() {
        return this.replication;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getBlockSize() {
        return this.blockSize;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean isReplaceDataNodesOnFailure() {
        return this.replaceDataNodesOnFailure;
    }
}

