/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.storage.hdfs;

import com.google.common.base.Preconditions;
import io.pravega.segmentstore.storage.AsyncStorageWrapper;
import io.pravega.segmentstore.storage.Storage;
import io.pravega.segmentstore.storage.StorageFactory;
import io.pravega.segmentstore.storage.SyncStorage;
import io.pravega.segmentstore.storage.rolling.RollingStorage;
import io.pravega.storage.hdfs.HDFSStorage;
import io.pravega.storage.hdfs.HDFSStorageConfig;
import java.util.concurrent.Executor;

public class HDFSStorageFactory
implements StorageFactory {
    private final HDFSStorageConfig config;
    private final Executor executor;

    public HDFSStorageFactory(HDFSStorageConfig config, Executor executor) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.config = config;
        this.executor = executor;
    }

    public Storage createStorageAdapter() {
        HDFSStorage s = new HDFSStorage(this.config);
        return new AsyncStorageWrapper((SyncStorage)new RollingStorage((SyncStorage)s), this.executor);
    }
}

