/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import io.pravega.client.ClientConfig;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.tables.KeyValueTable;
import io.pravega.client.tables.KeyValueTableClientConfiguration;
import io.pravega.client.tables.impl.KeyValueTableFactoryImpl;
import lombok.NonNull;

public interface KeyValueTableFactory
extends AutoCloseable {
    public static KeyValueTableFactory withScope(String scope, ClientConfig config) {
        SocketConnectionFactoryImpl connectionFactory = new SocketConnectionFactoryImpl(config);
        ConnectionPoolImpl connectionPool = new ConnectionPoolImpl(config, connectionFactory);
        ControllerImpl controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        return new KeyValueTableFactoryImpl(scope, controller, connectionPool);
    }

    public KeyValueTable forKeyValueTable(@NonNull String var1, @NonNull KeyValueTableClientConfiguration var2);

    @Override
    public void close();
}

