/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInfo;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.StreamCutImpl;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.security.auth.AccessOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCutHelper {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamCutHelper.class);
    private final Controller controller;
    private final SegmentMetadataClientFactory segmentMetadataClientFactory;

    public StreamCutHelper(Controller controller, ConnectionPool connectionPool) {
        this.controller = controller;
        this.segmentMetadataClientFactory = new SegmentMetadataClientFactoryImpl(controller, connectionPool);
    }

    public CompletableFuture<StreamCut> fetchHeadStreamCut(Stream stream) {
        return this.controller.getSegmentsAtTime(new StreamImpl(stream.getScope(), stream.getStreamName()), 0L).thenApply(s -> new StreamCutImpl(stream, (Map<Segment, Long>)s));
    }

    public CompletableFuture<StreamCut> fetchTailStreamCut(Stream stream) {
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(this.controller, stream.getScope(), stream.getStreamName(), AccessOperation.READ);
        return ((CompletableFuture)this.controller.getCurrentSegments(stream.getScope(), stream.getStreamName()).thenCompose(streamsegments -> this.segmentToInfos(streamsegments.getSegments(), tokenProvider))).thenApply(infos -> {
            Map<Segment, Long> pos = infos.stream().collect(Collectors.toMap(SegmentInfo::getSegment, SegmentInfo::getWriteOffset));
            return new StreamCutImpl(stream, pos);
        });
    }

    private CompletableFuture<List<SegmentInfo>> segmentToInfos(Collection<Segment> segments, DelegationTokenProvider tokenProvider) {
        ArrayList<CompletableFuture<SegmentInfo>> results = new ArrayList<CompletableFuture<SegmentInfo>>();
        for (Segment s : segments) {
            SegmentMetadataClient client = this.segmentMetadataClientFactory.createSegmentMetadataClient(s, tokenProvider);
            CompletableFuture<SegmentInfo> info = client.getSegmentInfo();
            results.add(info);
            info.whenComplete((v, e) -> client.close());
        }
        return Futures.allOfWithResults(results);
    }
}

