/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.EndOfSegmentException;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.common.LoggerHelpers;
import io.pravega.shared.protocol.netty.InvalidMessageException;
import io.pravega.shared.protocol.netty.WireCommandType;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventSegmentReaderImpl
implements EventSegmentReader {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventSegmentReaderImpl.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    static final long PARTIAL_DATA_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    @GuardedBy(value="$lock")
    private final ByteBuffer headerReadingBuffer = ByteBuffer.allocate(8);
    private final SegmentInputStream in;

    EventSegmentReaderImpl(SegmentInputStream input) {
        Preconditions.checkNotNull((Object)input);
        this.in = input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOffset(long offset, boolean resendRequest) {
        Object object = this.$lock;
        synchronized (object) {
            this.in.setOffset(offset, resendRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getOffset() {
        Object object = this.$lock;
        synchronized (object) {
            return this.in.getOffset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(long firstByteTimeoutMillis) throws EndOfSegmentException, SegmentTruncatedException {
        Object object = this.$lock;
        synchronized (object) {
            ByteBuffer byteBuffer;
            long originalOffset = this.in.getOffset();
            long traceId = LoggerHelpers.traceEnter((Logger)log, (String)"read", (Object[])new Object[]{this.in.getSegmentId(), originalOffset, firstByteTimeoutMillis});
            boolean success = false;
            boolean timeout = false;
            try {
                ByteBuffer result = this.readEvent(firstByteTimeoutMillis);
                success = true;
                byteBuffer = result;
            }
            catch (TimeoutException e) {
                ByteBuffer byteBuffer2;
                try {
                    timeout = true;
                    log.warn("Timeout observed while trying to read data from Segment store, the read request will be retransmitted");
                    byteBuffer2 = null;
                }
                catch (Throwable throwable) {
                    LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{this.in.getSegmentId(), originalOffset, firstByteTimeoutMillis, success});
                    if (!success) {
                        this.in.setOffset(originalOffset, timeout);
                    }
                    throw throwable;
                }
                LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{this.in.getSegmentId(), originalOffset, firstByteTimeoutMillis, success});
                if (!success) {
                    this.in.setOffset(originalOffset, timeout);
                }
                return byteBuffer2;
            }
            LoggerHelpers.traceLeave((Logger)log, (String)"read", (long)traceId, (Object[])new Object[]{this.in.getSegmentId(), originalOffset, firstByteTimeoutMillis, success});
            if (!success) {
                this.in.setOffset(originalOffset, timeout);
            }
            return byteBuffer;
        }
    }

    private ByteBuffer readEvent(long firstByteTimeoutMillis) throws EndOfSegmentException, SegmentTruncatedException, TimeoutException {
        this.headerReadingBuffer.clear();
        int read = this.in.read(this.headerReadingBuffer, firstByteTimeoutMillis);
        if (read == 0) {
            return null;
        }
        while (this.headerReadingBuffer.hasRemaining()) {
            this.readEventDataFromSegmentInputStream(this.headerReadingBuffer);
        }
        this.headerReadingBuffer.flip();
        int type = this.headerReadingBuffer.getInt();
        int length = this.headerReadingBuffer.getInt();
        if (type != WireCommandType.EVENT.getCode()) {
            throw new InvalidMessageException("Event was of wrong type: " + type);
        }
        if (length < 0 || length > 0xFFFFFF) {
            throw new InvalidMessageException("Event of invalid length: " + length);
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        this.readEventDataFromSegmentInputStream(result);
        while (result.hasRemaining()) {
            this.readEventDataFromSegmentInputStream(result);
        }
        result.flip();
        return result;
    }

    private void readEventDataFromSegmentInputStream(ByteBuffer result) throws EndOfSegmentException, SegmentTruncatedException, TimeoutException {
        if (this.in.read(result, PARTIAL_DATA_TIMEOUT) == 0 && result.limit() != 0) {
            log.warn("Timeout while trying to read Event data from segment {} at offset {}. The buffer capacity is {} bytes and the data read so far is {} bytes", new Object[]{this.in.getSegmentId(), this.in.getOffset(), result.limit(), result.position()});
            throw new TimeoutException("Timeout while trying to read event data");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<?> fillBuffer() {
        Object object = this.$lock;
        synchronized (object) {
            return this.in.fillBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.$lock;
        synchronized (object) {
            this.in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSegmentReady() {
        Object object = this.$lock;
        synchronized (object) {
            int bytesInBuffer = this.in.bytesInBuffer();
            return bytesInBuffer >= 8 || bytesInBuffer < 0;
        }
    }

    @Override
    public Segment getSegmentId() {
        return this.in.getSegmentId();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventSegmentReaderImpl(headerReadingBuffer=" + this.headerReadingBuffer + ", in=" + this.getIn() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    SegmentInputStream getIn() {
        return this.in;
    }
}

