/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.state.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.Revisioned;
import io.pravega.client.state.Update;
import io.pravega.client.state.impl.CorruptedStateException;
import io.pravega.client.state.impl.UpdateOrInit;
import io.pravega.client.stream.Serializer;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import lombok.Generated;

public final class UpdateOrInitSerializer<StateT extends Revisioned, UpdateT extends Update<StateT>, InitT extends InitialUpdate<StateT>>
implements Serializer<UpdateOrInit<StateT>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int INITIALIZATION = 1;
    private static final int UPDATE = 2;
    private final Serializer<UpdateT> updateSerializer;
    private final Serializer<InitT> initSerializer;

    @Override
    public ByteBuffer serialize(UpdateOrInit<StateT> value) {
        if (value.isInit()) {
            ByteBuffer buffer = this.initSerializer.serialize(value.getInit());
            ByteBuffer result = ByteBuffer.allocate(buffer.capacity() + 4);
            result.putInt(1);
            result.put(buffer);
            result.rewind();
            return result;
        }
        ArrayList<ByteBuffer> serializedUpdates = new ArrayList<ByteBuffer>();
        int size = 0;
        for (Update<StateT> u : value.getUpdates()) {
            ByteBuffer serialized = this.updateSerializer.serialize(u);
            size += serialized.remaining();
            serializedUpdates.add(serialized);
        }
        ByteBuffer result = ByteBuffer.allocate(size + 4 + serializedUpdates.size() * 4);
        result.putInt(2);
        for (ByteBuffer update : serializedUpdates) {
            result.putInt(update.remaining());
            result.put(update);
        }
        result.rewind();
        return result;
    }

    @Override
    public UpdateOrInit<StateT> deserialize(ByteBuffer serializedValue) {
        int type = serializedValue.getInt();
        if (type == 1) {
            return new UpdateOrInit((InitialUpdate)this.initSerializer.deserialize(serializedValue));
        }
        if (type == 2) {
            ArrayList<Update> result = new ArrayList<Update>();
            int origionalLimit = serializedValue.limit();
            while (serializedValue.hasRemaining()) {
                int updateLength = serializedValue.getInt();
                int position = serializedValue.position();
                serializedValue.limit(serializedValue.position() + updateLength);
                result.add((Update)this.updateSerializer.deserialize(serializedValue));
                serializedValue.limit(origionalLimit);
                serializedValue.position(position + updateLength);
            }
            return new UpdateOrInit(result);
        }
        throw new CorruptedStateException("Update of unknown type: " + type);
    }

    @ConstructorProperties(value={"updateSerializer", "initSerializer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UpdateOrInitSerializer(Serializer<UpdateT> updateSerializer, Serializer<InitT> initSerializer) {
        this.updateSerializer = updateSerializer;
        this.initSerializer = initSerializer;
    }
}

