/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.segment.impl.SegmentMetadataClient;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.stream.impl.PendingEvent;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import lombok.NonNull;

public class ByteStreamWriterImpl
extends ByteStreamWriter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    @NonNull
    private final SegmentOutputStream out;
    @NonNull
    private final SegmentMetadataClient meta;
    @GuardedBy(value="$lock")
    private CompletableFuture<Void> latestEventFuture;

    @Override
    public void write(int b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(ByteBuffer src) throws IOException {
        this.out.write(PendingEvent.withoutHeader(null, src, this.updateLastEventFuture()));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        ByteBuffer data = ByteBuffer.wrap(b, off, len);
        this.out.write(PendingEvent.withoutHeader(null, data, this.updateLastEventFuture()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    CompletableFuture<Void> updateLastEventFuture() {
        Object object = this.$lock;
        synchronized (object) {
            this.latestEventFuture = new CompletableFuture();
            return this.latestEventFuture;
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.meta.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> flushAsync() {
        Object object = this.$lock;
        synchronized (object) {
            this.out.flushAsync();
            return this.latestEventFuture;
        }
    }

    @Override
    public void closeAndSeal() throws IOException {
        this.out.close();
        Futures.getThrowingException(this.meta.sealSegment());
        this.meta.close();
    }

    @Override
    public long fetchHeadOffset() {
        return (Long)Futures.getThrowingException(this.meta.fetchCurrentSegmentHeadOffset());
    }

    @Override
    public long fetchTailOffset() {
        return (Long)Futures.getThrowingException(this.meta.fetchCurrentSegmentLength());
    }

    @Override
    public void truncateDataBefore(long offset) {
        Futures.getThrowingException(this.meta.truncateSegment(offset));
    }

    @ConstructorProperties(value={"out", "meta"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ByteStreamWriterImpl(@NonNull SegmentOutputStream out, @NonNull SegmentMetadataClient meta) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        if (meta == null) {
            throw new NullPointerException("meta is marked non-null but is null");
        }
        this.out = out;
        this.meta = meta;
    }
}

