/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.control.impl;

import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.control.impl.CancellableRequest;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.TransactionInfo;
import io.pravega.client.stream.impl.StreamSegmentSuccessors;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.client.stream.impl.TxnSegments;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.client.tables.impl.KeyValueTableSegments;
import io.pravega.common.util.AsyncIterator;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.security.auth.AccessOperation;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

public interface Controller
extends AutoCloseable {
    public CompletableFuture<Boolean> checkScopeExists(String var1);

    public AsyncIterator<String> listScopes();

    public CompletableFuture<Boolean> createScope(String var1);

    public AsyncIterator<Stream> listStreams(String var1);

    public AsyncIterator<Stream> listStreamsForTag(String var1, String var2);

    public CompletableFuture<Boolean> deleteScope(String var1);

    public CompletableFuture<Boolean> deleteScopeRecursive(String var1);

    public CompletableFuture<Boolean> createStream(String var1, String var2, StreamConfiguration var3);

    public CompletableFuture<Boolean> checkStreamExists(String var1, String var2);

    public CompletableFuture<StreamConfiguration> getStreamConfiguration(String var1, String var2);

    public CompletableFuture<Boolean> updateStream(String var1, String var2, StreamConfiguration var3);

    public CompletableFuture<ReaderGroupConfig> createReaderGroup(String var1, String var2, ReaderGroupConfig var3);

    public CompletableFuture<Long> updateReaderGroup(String var1, String var2, ReaderGroupConfig var3);

    public CompletableFuture<ReaderGroupConfig> getReaderGroupConfig(String var1, String var2);

    public CompletableFuture<Boolean> deleteReaderGroup(String var1, String var2, UUID var3);

    public CompletableFuture<List<String>> listSubscribers(String var1, String var2);

    public CompletableFuture<Boolean> updateSubscriberStreamCut(String var1, String var2, String var3, UUID var4, long var5, StreamCut var7);

    public CompletableFuture<Boolean> truncateStream(String var1, String var2, StreamCut var3);

    public CompletableFuture<Boolean> sealStream(String var1, String var2);

    public CompletableFuture<Boolean> deleteStream(String var1, String var2);

    public CompletableFuture<Boolean> startScale(Stream var1, List<Long> var2, Map<Double, Double> var3);

    public CancellableRequest<Boolean> scaleStream(Stream var1, List<Long> var2, Map<Double, Double> var3, ScheduledExecutorService var4);

    public CompletableFuture<Boolean> checkScaleStatus(Stream var1, int var2);

    public CompletableFuture<StreamSegments> getCurrentSegments(String var1, String var2);

    public CompletableFuture<StreamSegments> getEpochSegments(String var1, String var2, int var3);

    public CompletableFuture<TxnSegments> createTransaction(Stream var1, long var2);

    public CompletableFuture<Transaction.PingStatus> pingTransaction(Stream var1, UUID var2, long var3);

    public CompletableFuture<Void> commitTransaction(Stream var1, String var2, Long var3, UUID var4);

    public CompletableFuture<Void> abortTransaction(Stream var1, UUID var2);

    public CompletableFuture<Transaction.Status> checkTransactionStatus(Stream var1, UUID var2);

    public CompletableFuture<List<TransactionInfo>> listCompletedTransactions(Stream var1);

    public CompletableFuture<Map<Segment, Long>> getSegmentsAtTime(Stream var1, long var2);

    public CompletableFuture<StreamSegmentsWithPredecessors> getSuccessors(Segment var1);

    public CompletableFuture<StreamSegmentSuccessors> getSuccessors(StreamCut var1);

    public CompletableFuture<StreamSegmentSuccessors> getSegments(StreamCut var1, StreamCut var2);

    public CompletableFuture<Boolean> isSegmentOpen(Segment var1);

    public CompletableFuture<PravegaNodeUri> getEndpointForSegment(String var1);

    public CompletableFuture<Void> noteTimestampFromWriter(String var1, Stream var2, long var3, WriterPosition var5);

    public CompletableFuture<Void> removeWriter(String var1, Stream var2);

    @Override
    public void close();

    public CompletableFuture<String> getOrRefreshDelegationTokenFor(String var1, String var2, AccessOperation var3);

    public CompletableFuture<Boolean> createKeyValueTable(String var1, String var2, KeyValueTableConfiguration var3);

    public AsyncIterator<KeyValueTableInfo> listKeyValueTables(String var1);

    public CompletableFuture<KeyValueTableConfiguration> getKeyValueTableConfiguration(String var1, String var2);

    public CompletableFuture<Boolean> deleteKeyValueTable(String var1, String var2);

    public CompletableFuture<KeyValueTableSegments> getCurrentSegmentsForKeyValueTable(String var1, String var2);
}

