/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ConnectionPool;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.AsyncSegmentInputStream;
import io.pravega.client.segment.impl.AsyncSegmentInputStreamImpl;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.EventSegmentReaderImpl;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentInputStreamImpl;
import io.pravega.common.MathHelpers;
import io.pravega.shared.security.auth.AccessOperation;
import java.beans.ConstructorProperties;
import java.util.concurrent.Semaphore;
import lombok.Generated;

@VisibleForTesting
public class SegmentInputStreamFactoryImpl
implements SegmentInputStreamFactory {
    private final Controller controller;
    private final ConnectionPool cp;

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment) {
        return this.createEventReaderForSegment(segment, 0x100000);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, long startOffset, long endOffset) {
        return this.getEventSegmentReader(segment, null, startOffset, endOffset, 0x100000);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, int bufferSize) {
        return this.getEventSegmentReader(segment, null, 0L, Long.MAX_VALUE, bufferSize);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, int bufferSize, Semaphore hasData, long endOffset) {
        return this.getEventSegmentReader(segment, hasData, 0L, endOffset, bufferSize);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, long startOffset, int bufferSize) {
        return this.getEventSegmentReader(segment, null, startOffset, Long.MAX_VALUE, bufferSize);
    }

    private EventSegmentReader getEventSegmentReader(Segment segment, Semaphore hasData, long startOffset, long endOffset, int bufferSize) {
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(this.controller, segment, AccessOperation.READ);
        tokenProvider.retrieveToken();
        AsyncSegmentInputStreamImpl async = new AsyncSegmentInputStreamImpl(this.controller, this.cp, segment, tokenProvider, hasData);
        async.getConnection();
        bufferSize = MathHelpers.minMax((int)bufferSize, (int)1024, (int)0xA00000);
        return SegmentInputStreamFactoryImpl.getEventSegmentReader(async, startOffset, endOffset, bufferSize);
    }

    @VisibleForTesting
    static EventSegmentReaderImpl getEventSegmentReader(AsyncSegmentInputStream async, long startOffset, long endOffset, int bufferSize) {
        return new EventSegmentReaderImpl(new SegmentInputStreamImpl(async, startOffset, endOffset, bufferSize));
    }

    @VisibleForTesting
    static EventSegmentReaderImpl getEventSegmentReader(AsyncSegmentInputStream async, long startOffset) {
        return new EventSegmentReaderImpl(new SegmentInputStreamImpl(async, startOffset));
    }

    @Override
    public SegmentInputStream createInputStreamForSegment(Segment segment, DelegationTokenProvider tokenProvider) {
        return this.createInputStreamForSegment(segment, tokenProvider, 0L);
    }

    @Override
    public SegmentInputStream createInputStreamForSegment(Segment segment, DelegationTokenProvider tokenProvider, long startOffset) {
        AsyncSegmentInputStreamImpl async = new AsyncSegmentInputStreamImpl(this.controller, this.cp, segment, tokenProvider, null);
        async.getConnection();
        return new SegmentInputStreamImpl(async, startOffset);
    }

    @ConstructorProperties(value={"controller", "cp"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SegmentInputStreamFactoryImpl(Controller controller, ConnectionPool cp) {
        this.controller = controller;
        this.cp = cp;
    }
}

