/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.state;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;

public class SynchronizerConfig
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final SynchronizerConfigSerializer SERIALIZER = new SynchronizerConfigSerializer();
    EventWriterConfig eventWriterConfig;
    int readBufferSize;

    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static SynchronizerConfig fromBytes(ByteBuffer buff) {
        return (SynchronizerConfig)SERIALIZER.deserialize((BufferView)new ByteArraySegment(buff));
    }

    private Object writeReplace() {
        return new SerializedForm(SERIALIZER.serialize(this).getCopy());
    }

    @ConstructorProperties(value={"eventWriterConfig", "readBufferSize"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    SynchronizerConfig(EventWriterConfig eventWriterConfig, int readBufferSize) {
        this.eventWriterConfig = eventWriterConfig;
        this.readBufferSize = readBufferSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SynchronizerConfigBuilder builder() {
        return new SynchronizerConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public EventWriterConfig getEventWriterConfig() {
        return this.eventWriterConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setEventWriterConfig(EventWriterConfig eventWriterConfig) {
        this.eventWriterConfig = eventWriterConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SynchronizerConfig)) {
            return false;
        }
        SynchronizerConfig other = (SynchronizerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventWriterConfig this$eventWriterConfig = this.getEventWriterConfig();
        EventWriterConfig other$eventWriterConfig = other.getEventWriterConfig();
        if (this$eventWriterConfig == null ? other$eventWriterConfig != null : !((Object)this$eventWriterConfig).equals(other$eventWriterConfig)) {
            return false;
        }
        return this.getReadBufferSize() == other.getReadBufferSize();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SynchronizerConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventWriterConfig $eventWriterConfig = this.getEventWriterConfig();
        result = result * 59 + ($eventWriterConfig == null ? 43 : ((Object)$eventWriterConfig).hashCode());
        result = result * 59 + this.getReadBufferSize();
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SynchronizerConfig(eventWriterConfig=" + this.getEventWriterConfig() + ", readBufferSize=" + this.getReadBufferSize() + ")";
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final byte[] value;

        Object readResolve() {
            return SERIALIZER.deserialize((BufferView)new ByteArraySegment(this.value));
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SerializedForm(byte[] value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte[] getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SynchronizerConfig.SerializedForm(value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    static class SynchronizerConfigSerializer
    extends VersionedSerializer.WithBuilder<SynchronizerConfig, SynchronizerConfigBuilder> {
        SynchronizerConfigSerializer() {
        }

        protected SynchronizerConfigBuilder newBuilder() {
            return SynchronizerConfig.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, SynchronizerConfigBuilder builder) throws IOException {
            builder.readBufferSize(revisionDataInput.readInt());
            builder.eventWriterConfig(EventWriterConfig.fromBytes(ByteBuffer.wrap(revisionDataInput.readArray())));
        }

        private void write00(SynchronizerConfig object, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(object.getReadBufferSize());
            ByteBuffer buff = object.eventWriterConfig.toBytes();
            revisionDataOutput.writeArray(object.eventWriterConfig.toBytes().array(), 0, buff.remaining());
        }
    }

    public static class SynchronizerConfigBuilder
    implements ObjectBuilder<SynchronizerConfig> {
        private EventWriterConfig eventWriterConfig = EventWriterConfig.builder().retryAttempts(Integer.MAX_VALUE).enableConnectionPooling(true).build();
        private int readBufferSize = 262144;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SynchronizerConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SynchronizerConfigBuilder eventWriterConfig(EventWriterConfig eventWriterConfig) {
            this.eventWriterConfig = eventWriterConfig;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SynchronizerConfigBuilder readBufferSize(int readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SynchronizerConfig build() {
            return new SynchronizerConfig(this.eventWriterConfig, this.readBufferSize);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SynchronizerConfig.SynchronizerConfigBuilder(eventWriterConfig=" + this.eventWriterConfig + ", readBufferSize=" + this.readBufferSize + ")";
        }
    }
}

