/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import lombok.Generated;

public class EventWriterConfig
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final EventWriterConfigSerializer SERIALIZER = new EventWriterConfigSerializer();
    private final int initialBackoffMillis;
    private final int maxBackoffMillis;
    private final int retryAttempts;
    private final int backoffMultiple;
    private final boolean enableConnectionPooling;
    private final long transactionTimeoutTime;
    private final boolean automaticallyNoteTime;
    private final boolean enableLargeEvents;

    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static EventWriterConfig fromBytes(ByteBuffer buff) {
        return (EventWriterConfig)SERIALIZER.deserialize((BufferView)new ByteArraySegment(buff));
    }

    private Object writeReplace() {
        return new SerializedForm(SERIALIZER.serialize(this).getCopy());
    }

    @ConstructorProperties(value={"initialBackoffMillis", "maxBackoffMillis", "retryAttempts", "backoffMultiple", "enableConnectionPooling", "transactionTimeoutTime", "automaticallyNoteTime", "enableLargeEvents"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    EventWriterConfig(int initialBackoffMillis, int maxBackoffMillis, int retryAttempts, int backoffMultiple, boolean enableConnectionPooling, long transactionTimeoutTime, boolean automaticallyNoteTime, boolean enableLargeEvents) {
        this.initialBackoffMillis = initialBackoffMillis;
        this.maxBackoffMillis = maxBackoffMillis;
        this.retryAttempts = retryAttempts;
        this.backoffMultiple = backoffMultiple;
        this.enableConnectionPooling = enableConnectionPooling;
        this.transactionTimeoutTime = transactionTimeoutTime;
        this.automaticallyNoteTime = automaticallyNoteTime;
        this.enableLargeEvents = enableLargeEvents;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static EventWriterConfigBuilder builder() {
        return new EventWriterConfigBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBackoffMillis() {
        return this.maxBackoffMillis;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getBackoffMultiple() {
        return this.backoffMultiple;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableConnectionPooling() {
        return this.enableConnectionPooling;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getTransactionTimeoutTime() {
        return this.transactionTimeoutTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isAutomaticallyNoteTime() {
        return this.automaticallyNoteTime;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean isEnableLargeEvents() {
        return this.enableLargeEvents;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventWriterConfig)) {
            return false;
        }
        EventWriterConfig other = (EventWriterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitialBackoffMillis() != other.getInitialBackoffMillis()) {
            return false;
        }
        if (this.getMaxBackoffMillis() != other.getMaxBackoffMillis()) {
            return false;
        }
        if (this.getRetryAttempts() != other.getRetryAttempts()) {
            return false;
        }
        if (this.getBackoffMultiple() != other.getBackoffMultiple()) {
            return false;
        }
        if (this.isEnableConnectionPooling() != other.isEnableConnectionPooling()) {
            return false;
        }
        if (this.getTransactionTimeoutTime() != other.getTransactionTimeoutTime()) {
            return false;
        }
        if (this.isAutomaticallyNoteTime() != other.isAutomaticallyNoteTime()) {
            return false;
        }
        return this.isEnableLargeEvents() == other.isEnableLargeEvents();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventWriterConfig;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInitialBackoffMillis();
        result = result * 59 + this.getMaxBackoffMillis();
        result = result * 59 + this.getRetryAttempts();
        result = result * 59 + this.getBackoffMultiple();
        result = result * 59 + (this.isEnableConnectionPooling() ? 79 : 97);
        long $transactionTimeoutTime = this.getTransactionTimeoutTime();
        result = result * 59 + (int)($transactionTimeoutTime >>> 32 ^ $transactionTimeoutTime);
        result = result * 59 + (this.isAutomaticallyNoteTime() ? 79 : 97);
        result = result * 59 + (this.isEnableLargeEvents() ? 79 : 97);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "EventWriterConfig(initialBackoffMillis=" + this.getInitialBackoffMillis() + ", maxBackoffMillis=" + this.getMaxBackoffMillis() + ", retryAttempts=" + this.getRetryAttempts() + ", backoffMultiple=" + this.getBackoffMultiple() + ", enableConnectionPooling=" + this.isEnableConnectionPooling() + ", transactionTimeoutTime=" + this.getTransactionTimeoutTime() + ", automaticallyNoteTime=" + this.isAutomaticallyNoteTime() + ", enableLargeEvents=" + this.isEnableLargeEvents() + ")";
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 2L;
        private final byte[] value;

        Object readResolve() {
            return SERIALIZER.deserialize((BufferView)new ByteArraySegment(this.value));
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SerializedForm(byte[] value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte[] getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EventWriterConfig.SerializedForm(value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    static class EventWriterConfigSerializer
    extends VersionedSerializer.WithBuilder<EventWriterConfig, EventWriterConfigBuilder> {
        EventWriterConfigSerializer() {
        }

        protected EventWriterConfigBuilder newBuilder() {
            return EventWriterConfig.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, EventWriterConfigBuilder builder) throws IOException {
            builder.initialBackoffMillis(revisionDataInput.readInt());
            builder.maxBackoffMillis(revisionDataInput.readInt());
            builder.retryAttempts(revisionDataInput.readInt());
            builder.backoffMultiple(revisionDataInput.readInt());
            builder.enableConnectionPooling(revisionDataInput.readBoolean());
            builder.transactionTimeoutTime(revisionDataInput.readLong());
            builder.automaticallyNoteTime(revisionDataInput.readBoolean());
            builder.enableLargeEvents(revisionDataInput.readBoolean());
        }

        private void write00(EventWriterConfig object, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeInt(object.getInitialBackoffMillis());
            revisionDataOutput.writeInt(object.getMaxBackoffMillis());
            revisionDataOutput.writeInt(object.getRetryAttempts());
            revisionDataOutput.writeInt(object.getBackoffMultiple());
            revisionDataOutput.writeBoolean(object.enableConnectionPooling);
            revisionDataOutput.writeLong(object.getTransactionTimeoutTime());
            revisionDataOutput.writeBoolean(object.automaticallyNoteTime);
            revisionDataOutput.writeBoolean(object.enableLargeEvents);
        }
    }

    public static final class EventWriterConfigBuilder
    implements ObjectBuilder<EventWriterConfig> {
        private static final long MIN_TRANSACTION_TIMEOUT_TIME_MILLIS = 10000L;
        private int initialBackoffMillis = 1;
        private int maxBackoffMillis = 20000;
        private int retryAttempts = 10;
        private int backoffMultiple = 10;
        private long transactionTimeoutTime = 599999L;
        private boolean automaticallyNoteTime = false;
        private boolean enableConnectionPooling = false;
        private boolean enableLargeEvents = false;

        public EventWriterConfig build() {
            Preconditions.checkArgument((this.transactionTimeoutTime >= 10000L ? 1 : 0) != 0, (Object)"Transaction time must be at least 10 seconds.");
            Preconditions.checkArgument((this.initialBackoffMillis >= 0 ? 1 : 0) != 0, (Object)"Backoff times must be positive numbers");
            Preconditions.checkArgument((this.backoffMultiple >= 0 ? 1 : 0) != 0, (Object)"Backoff multiple must be positive numbers");
            Preconditions.checkArgument((this.maxBackoffMillis >= 0 ? 1 : 0) != 0, (Object)"Backoff times must be positive numbers");
            Preconditions.checkArgument((this.retryAttempts >= 0 ? 1 : 0) != 0, (Object)"Retry attempts must be a positive number");
            return new EventWriterConfig(this.initialBackoffMillis, this.maxBackoffMillis, this.retryAttempts, this.backoffMultiple, this.enableConnectionPooling, this.transactionTimeoutTime, this.automaticallyNoteTime, this.enableLargeEvents);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        EventWriterConfigBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder initialBackoffMillis(int initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder maxBackoffMillis(int maxBackoffMillis) {
            this.maxBackoffMillis = maxBackoffMillis;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder retryAttempts(int retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder backoffMultiple(int backoffMultiple) {
            this.backoffMultiple = backoffMultiple;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder enableConnectionPooling(boolean enableConnectionPooling) {
            this.enableConnectionPooling = enableConnectionPooling;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder transactionTimeoutTime(long transactionTimeoutTime) {
            this.transactionTimeoutTime = transactionTimeoutTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder automaticallyNoteTime(boolean automaticallyNoteTime) {
            this.automaticallyNoteTime = automaticallyNoteTime;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public EventWriterConfigBuilder enableLargeEvents(boolean enableLargeEvents) {
            this.enableLargeEvents = enableLargeEvents;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "EventWriterConfig.EventWriterConfigBuilder(initialBackoffMillis=" + this.initialBackoffMillis + ", maxBackoffMillis=" + this.maxBackoffMillis + ", retryAttempts=" + this.retryAttempts + ", backoffMultiple=" + this.backoffMultiple + ", enableConnectionPooling=" + this.enableConnectionPooling + ", transactionTimeoutTime=" + this.transactionTimeoutTime + ", automaticallyNoteTime=" + this.automaticallyNoteTime + ", enableLargeEvents=" + this.enableLargeEvents + ")";
        }
    }
}

