/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.impl.StreamCutInternal;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.ToStringUtils;
import io.pravega.shared.NameUtils;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

public final class StreamCutImpl
extends StreamCutInternal {
    static final StreamCutSerializer SERIALIZER = new StreamCutSerializer();
    private static final int TO_STRING_VERSION = 0;
    private final Stream stream;
    private final Map<Segment, Long> positions;

    public StreamCutImpl(Stream stream, Map<Segment, Long> positions) {
        this.stream = stream;
        this.positions = ImmutableMap.copyOf(positions);
    }

    @Override
    public Map<Segment, Long> getPositions() {
        return Collections.unmodifiableMap(this.positions);
    }

    @Override
    public Stream getStream() {
        return this.stream;
    }

    @Override
    public StreamCutInternal asImpl() {
        return this;
    }

    public String toString() {
        return this.stream.getScopedName() + ":" + ToStringUtils.mapToString(this.positions.entrySet().stream().collect(Collectors.toMap(e -> ((Segment)e.getKey()).getSegmentId(), e -> (Long)e.getValue())));
    }

    @Override
    public String asText() {
        return ToStringUtils.compressToBase64((String)this.getText());
    }

    private String getText() {
        StringBuilder builder = new StringBuilder(Integer.toString(0)).append(":");
        builder.append(this.stream.getScopedName()).append(":");
        ArrayList segmentNumbers = new ArrayList();
        ArrayList epochs = new ArrayList();
        ArrayList offsets = new ArrayList();
        this.positions.forEach((segmentId, offset) -> {
            segmentNumbers.add(NameUtils.getSegmentNumber((long)segmentId.getSegmentId()));
            epochs.add(NameUtils.getEpoch((long)segmentId.getSegmentId()));
            offsets.add(offset);
        });
        builder.append(ToStringUtils.listToString(segmentNumbers)).append(":");
        builder.append(ToStringUtils.listToString(epochs)).append(":");
        builder.append(ToStringUtils.listToString(offsets));
        return builder.toString();
    }

    public static StreamCutInternal from(String base64String) {
        Exceptions.checkNotNullOrEmpty((String)base64String, (String)"base64String");
        String[] split = ToStringUtils.decompressFromBase64((String)base64String).split(":", 5);
        Preconditions.checkArgument((split.length == 5 ? 1 : 0) != 0, (Object)"Invalid string representation of StreamCut");
        Stream stream = Stream.of(split[1]);
        List segmentNumbers = ToStringUtils.stringToList((String)split[2], Integer::valueOf);
        List epochs = ToStringUtils.stringToList((String)split[3], Integer::valueOf);
        List offsets = ToStringUtils.stringToList((String)split[4], Long::valueOf);
        Map<Segment, Long> positions = IntStream.range(0, segmentNumbers.size()).boxed().collect(Collectors.toMap(i -> new Segment(stream.getScope(), stream.getStreamName(), NameUtils.computeSegmentId((int)((Integer)segmentNumbers.get((int)i)), (int)((Integer)epochs.get((int)i)))), offsets::get));
        return new StreamCutImpl(stream, positions);
    }

    @VisibleForTesting
    public boolean validate(Set<String> segmentNames) {
        for (Segment s : this.positions.keySet()) {
            if (segmentNames.contains(s.getScopedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static StreamCutInternal fromBytes(ByteBuffer buff) {
        return (StreamCutInternal)SERIALIZER.deserialize((BufferView)new ByteArraySegment(buff));
    }

    private Object writeReplace() {
        return new SerializedForm(SERIALIZER.serialize(this).getCopy());
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamCutBuilder builder() {
        return new StreamCutBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamCutImpl)) {
            return false;
        }
        StreamCutImpl other = (StreamCutImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Stream this$stream = this.getStream();
        Stream other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        Map<Segment, Long> this$positions = this.getPositions();
        Map<Segment, Long> other$positions = other.getPositions();
        return !(this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamCutImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Stream $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        Map<Segment, Long> $positions = this.getPositions();
        result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
        return result;
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] value;

        Object readResolve() {
            return SERIALIZER.deserialize((BufferView)new ByteArraySegment(this.value));
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SerializedForm(byte[] value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public byte[] getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamCutImpl.SerializedForm(value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    public static class StreamCutSerializer
    extends VersionedSerializer.WithBuilder<StreamCutInternal, StreamCutBuilder> {
        protected StreamCutBuilder newBuilder() {
            return StreamCutImpl.builder();
        }

        protected byte getWriteVersion() {
            return 1;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
            this.version(1).revision(0, this::write10, this::read10);
        }

        private void read00(RevisionDataInput revisionDataInput, StreamCutBuilder builder) throws IOException {
            Stream stream = Stream.of(revisionDataInput.readUTF());
            builder.stream(stream);
            Map map = revisionDataInput.readMap(in -> new Segment(stream.getScope(), stream.getStreamName(), in.readCompactLong()), in -> in.readCompactLong());
            builder.positions(map);
        }

        private void write00(StreamCutInternal cut, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(cut.getStream().getScopedName());
            Map<Segment, Long> map = cut.getPositions();
            revisionDataOutput.writeMap(map, (out, s) -> out.writeCompactLong(s.getSegmentId()), (out, offset) -> out.writeCompactLong(offset.longValue()));
        }

        private void read10(RevisionDataInput revisionDataInput, StreamCutBuilder builder) throws IOException {
            Stream stream = Stream.of(revisionDataInput.readUTF());
            builder.stream(stream);
            Map map = revisionDataInput.readMap(in -> new Segment(stream.getScope(), stream.getStreamName(), in.readCompactLong()), RevisionDataInput::readCompactSignedLong);
            builder.positions(map);
        }

        private void write10(StreamCutInternal cut, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeUTF(cut.getStream().getScopedName());
            Map<Segment, Long> map = cut.getPositions();
            revisionDataOutput.writeMap(map, (out, s) -> out.writeCompactLong(s.getSegmentId()), RevisionDataOutput::writeCompactSignedLong);
        }
    }

    private static class StreamCutBuilder
    implements ObjectBuilder<StreamCutInternal> {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Stream stream;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Map<Segment, Long> positions;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamCutBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutBuilder stream(Stream stream) {
            this.stream = stream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutBuilder positions(Map<Segment, Long> positions) {
            this.positions = positions;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamCutImpl build() {
            return new StreamCutImpl(this.stream, this.positions);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamCutImpl.StreamCutBuilder(stream=" + this.stream + ", positions=" + this.positions + ")";
        }
    }
}

