/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client;

import com.google.common.annotations.Beta;
import io.pravega.client.ClientConfig;
import io.pravega.client.byteStream.ByteStreamReader;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.byteStream.impl.ByteStreamClientImpl;
import io.pravega.client.netty.impl.ConnectionFactoryImpl;
import io.pravega.client.stream.impl.ControllerImpl;
import io.pravega.client.stream.impl.ControllerImplConfig;

@Beta
public interface ByteStreamClientFactory
extends AutoCloseable {
    public static ByteStreamClientFactory withScope(String scope, ClientConfig config) {
        ConnectionFactoryImpl connectionFactory = new ConnectionFactoryImpl(config);
        ControllerImpl controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        return new ByteStreamClientImpl(scope, controller, connectionFactory);
    }

    @Beta
    public ByteStreamReader createByteStreamReader(String var1);

    @Beta
    public ByteStreamWriter createByteStreamWriter(String var1);

    @Override
    public void close();
}

