/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.SynchronizerClientFactory;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.SynchronizerConfig;
import io.pravega.client.state.Update;
import io.pravega.client.stream.InvalidStreamException;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.ControllerImpl;
import io.pravega.client.stream.impl.ControllerImplConfig;
import io.pravega.client.stream.impl.ReaderGroupImpl;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shared.NameUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroupManagerImpl
implements ReaderGroupManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ReaderGroupManagerImpl.class);
    private final String scope;
    private final SynchronizerClientFactory clientFactory;
    private final Controller controller;
    private final ConnectionFactory connectionFactory;

    public ReaderGroupManagerImpl(String scope, ClientConfig config, ConnectionFactory connectionFactory) {
        this.scope = scope;
        this.controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        this.connectionFactory = connectionFactory;
        this.clientFactory = new ClientFactoryImpl(scope, this.controller, connectionFactory);
    }

    public ReaderGroupManagerImpl(String scope, Controller controller, SynchronizerClientFactory clientFactory, ConnectionFactory connectionFactory) {
        this.scope = scope;
        this.clientFactory = clientFactory;
        this.controller = controller;
        this.connectionFactory = connectionFactory;
    }

    private Stream createStreamHelper(String streamName, StreamConfiguration config) {
        Futures.getAndHandleExceptions(this.controller.createStream(this.scope, streamName, StreamConfiguration.builder().scalingPolicy(config.getScalingPolicy()).build()), RuntimeException::new);
        return new StreamImpl(this.scope, streamName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createReaderGroup(String groupName, ReaderGroupConfig config) {
        log.info("Creating reader group: {} for streams: {} with configuration: {}", new Object[]{groupName, Arrays.toString(config.getStartingStreamCuts().keySet().toArray()), config});
        NameUtils.validateReaderGroupName((String)groupName);
        this.createStreamHelper(NameUtils.getStreamForReaderGroup((String)groupName), StreamConfiguration.builder().scalingPolicy(ScalingPolicy.fixed(1)).build());
        StateSynchronizer<ReaderGroupState> synchronizer = this.clientFactory.createStateSynchronizer(NameUtils.getStreamForReaderGroup((String)groupName), new ReaderGroupStateUpdatesSerializer(), new ReaderGroupStateInitSerializer(), SynchronizerConfig.builder().build());
        try {
            Map<SegmentWithRange, Long> segments = ReaderGroupImpl.getSegmentsForStreams(this.controller, config);
            synchronizer.initialize(new ReaderGroupState.ReaderGroupStateInit(config, segments, ReaderGroupImpl.getEndSegmentsForStreams(config)));
        }
        finally {
            if (Collections.singletonList(synchronizer).get(0) != null) {
                synchronizer.close();
            }
        }
    }

    @Override
    public void deleteReaderGroup(String groupName) {
        Futures.getAndHandleExceptions((Future)((Object)((CompletableFuture)this.controller.sealStream(this.scope, NameUtils.getStreamForReaderGroup((String)groupName)).thenCompose(b -> this.controller.deleteStream(this.scope, NameUtils.getStreamForReaderGroup((String)groupName)))).exceptionally(e -> {
            if (e instanceof InvalidStreamException) {
                return null;
            }
            log.warn("Failed to delete stream", e);
            throw Exceptions.sneakyThrow((Throwable)e);
        })), RuntimeException::new);
    }

    @Override
    public ReaderGroup getReaderGroup(String groupName) {
        SynchronizerConfig synchronizerConfig = SynchronizerConfig.builder().build();
        return new ReaderGroupImpl(this.scope, groupName, synchronizerConfig, new ReaderGroupStateInitSerializer(), new ReaderGroupStateUpdatesSerializer(), this.clientFactory, this.controller, this.connectionFactory);
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @VisibleForTesting
    public static class ReaderGroupStateUpdatesSerializer
    implements Serializer<Update<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupUpdateSerializer serializer = new ReaderGroupState.ReaderGroupUpdateSerializer();

        @Override
        public ByteBuffer serialize(Update<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public Update<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (Update)this.serializer.deserialize((ArrayView)new ByteArraySegment(serializedValue));
        }
    }

    @VisibleForTesting
    public static class ReaderGroupStateInitSerializer
    implements Serializer<InitialUpdate<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupInitSerializer serializer = new ReaderGroupState.ReaderGroupInitSerializer();

        @Override
        public ByteBuffer serialize(InitialUpdate<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public InitialUpdate<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (InitialUpdate)this.serializer.deserialize((ArrayView)new ByteArraySegment(serializedValue));
        }
    }
}

