/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.StreamInfo;
import io.pravega.client.admin.StreamManager;
import io.pravega.client.admin.impl.StreamCutHelper;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.netty.impl.ConnectionFactoryImpl;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.ControllerImpl;
import io.pravega.client.stream.impl.ControllerImplConfig;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BlockingAsyncIterator;
import io.pravega.shared.NameUtils;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamManagerImpl
implements StreamManager {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamManagerImpl.class);
    private final Controller controller;
    private final ConnectionFactory connectionFactory;
    private final ScheduledExecutorService executor;
    private final StreamCutHelper streamCutHelper;

    public StreamManagerImpl(ClientConfig clientConfig) {
        this.executor = ExecutorServiceHelpers.newScheduledThreadPool((int)1, (String)"StreamManager-Controller");
        this.controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(clientConfig).build(), this.executor);
        this.connectionFactory = new ConnectionFactoryImpl(clientConfig);
        this.streamCutHelper = new StreamCutHelper(this.controller, this.connectionFactory);
    }

    @VisibleForTesting
    public StreamManagerImpl(Controller controller, ConnectionFactory connectionFactory) {
        this.executor = null;
        this.controller = controller;
        this.connectionFactory = connectionFactory;
        this.streamCutHelper = new StreamCutHelper(controller, connectionFactory);
    }

    @Override
    public boolean createStream(String scopeName, String streamName, StreamConfiguration config) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Creating scope/stream: {}/{} with configuration: {}", new Object[]{scopeName, streamName, config});
        return (Boolean)Futures.getThrowingException(this.controller.createStream(scopeName, streamName, StreamConfiguration.builder().scalingPolicy(config.getScalingPolicy()).retentionPolicy(config.getRetentionPolicy()).build()));
    }

    @Override
    public boolean updateStream(String scopeName, String streamName, StreamConfiguration config) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Updating scope/stream: {}/{} with configuration: {}", new Object[]{scopeName, streamName, config});
        return (Boolean)Futures.getThrowingException(this.controller.updateStream(scopeName, streamName, StreamConfiguration.builder().scalingPolicy(config.getScalingPolicy()).retentionPolicy(config.getRetentionPolicy()).build()));
    }

    @Override
    public boolean truncateStream(String scopeName, String streamName, StreamCut streamCut) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        Preconditions.checkNotNull((Object)streamCut);
        log.info("Truncating scope/stream: {}/{} with stream cut: {}", new Object[]{scopeName, streamName, streamCut});
        return (Boolean)Futures.getThrowingException(this.controller.truncateStream(scopeName, streamName, streamCut));
    }

    @Override
    public boolean sealStream(String scopeName, String streamName) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Sealing scope/stream: {}/{}", (Object)scopeName, (Object)streamName);
        return (Boolean)Futures.getThrowingException(this.controller.sealStream(scopeName, streamName));
    }

    @Override
    public boolean deleteStream(String scopeName, String streamName) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Deleting scope/stream: {}/{}", (Object)scopeName, (Object)streamName);
        return (Boolean)Futures.getThrowingException(this.controller.deleteStream(scopeName, streamName));
    }

    @Override
    public boolean createScope(String scopeName) {
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Creating scope: {}", (Object)scopeName);
        return (Boolean)Futures.getThrowingException(this.controller.createScope(scopeName));
    }

    @Override
    public Iterator<Stream> listStreams(String scopeName) {
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Listing streams in scope: {}", (Object)scopeName);
        AsyncIterator<Stream> asyncIterator = this.controller.listStreams(scopeName);
        return new BlockingAsyncIterator(asyncIterator);
    }

    @Override
    public boolean deleteScope(String scopeName) {
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Deleting scope: {}", (Object)scopeName);
        return (Boolean)Futures.getThrowingException(this.controller.deleteScope(scopeName));
    }

    @Override
    public StreamInfo getStreamInfo(String scopeName, String streamName) {
        NameUtils.validateUserStreamName((String)streamName);
        NameUtils.validateUserScopeName((String)scopeName);
        log.info("Fetching StreamInfo for scope/stream: {}/{}", (Object)scopeName, (Object)streamName);
        return (StreamInfo)Futures.getThrowingException(this.getStreamInfo(Stream.of(scopeName, streamName)));
    }

    public CompletableFuture<StreamInfo> getStreamInfo(Stream stream) {
        CompletableFuture<StreamCut> currentTailStreamCut = this.streamCutHelper.fetchTailStreamCut(stream);
        CompletableFuture<StreamCut> currentHeadStreamCut = this.streamCutHelper.fetchHeadStreamCut(stream);
        return currentTailStreamCut.thenCombine(currentHeadStreamCut, (tailSC, headSC) -> new StreamInfo(stream.getScope(), stream.getStreamName(), (StreamCut)tailSC, (StreamCut)headSC));
    }

    @Override
    public void close() {
        if (this.controller != null) {
            this.controller.close();
        }
        if (this.executor != null) {
            ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.executor});
        }
        if (this.connectionFactory != null) {
            this.connectionFactory.close();
        }
    }
}

