/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.batch.SegmentIterator;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentTruncatedException;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.TruncatedDataException;
import java.util.NoSuchElementException;

@Beta
public class SegmentIteratorImpl<T>
implements SegmentIterator<T> {
    private final Segment segment;
    private final Serializer<T> deserializer;
    private final long startingOffset;
    private final long endingOffset;
    private final EventSegmentReader input;

    public SegmentIteratorImpl(SegmentInputStreamFactory factory, Segment segment, Serializer<T> deserializer, long startingOffset, long endingOffset) {
        this.segment = segment;
        this.deserializer = deserializer;
        this.startingOffset = startingOffset;
        this.endingOffset = endingOffset;
        this.input = factory.createEventReaderForSegment(segment);
        this.input.setOffset(startingOffset);
    }

    @Override
    public boolean hasNext() {
        return this.input.getOffset() < this.endingOffset;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return this.deserializer.deserialize(this.input.read());
        }
        catch (NoSuchSegmentException | SegmentTruncatedException e) {
            throw new TruncatedDataException("Segment " + this.segment + " has been truncated.");
        }
    }

    @Override
    public long getOffset() {
        return this.input.getOffset();
    }

    @Override
    public void close() {
        this.input.close();
    }

    @SuppressFBWarnings(justification="generated code")
    public long getStartingOffset() {
        return this.startingOffset;
    }
}

