/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ByteStreamClientFactory;
import io.pravega.client.byteStream.ByteStreamClient;
import io.pravega.client.byteStream.ByteStreamReader;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.byteStream.impl.BufferedByteStreamWriterImpl;
import io.pravega.client.byteStream.impl.ByteStreamReaderImpl;
import io.pravega.client.byteStream.impl.ByteStreamWriterImpl;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentInputStreamFactoryImpl;
import io.pravega.client.segment.impl.SegmentMetadataClientFactory;
import io.pravega.client.segment.impl.SegmentMetadataClientFactoryImpl;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.segment.impl.SegmentOutputStreamFactoryImpl;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class ByteStreamClientImpl
implements ByteStreamClientFactory,
ByteStreamClient {
    @NonNull
    private final String scope;
    @NonNull
    private final Controller controller;
    @NonNull
    private final ConnectionFactory connectionFactory;
    @NonNull
    private final SegmentInputStreamFactory inputStreamFactory;
    @NonNull
    private final SegmentOutputStreamFactory outputStreamFactory;
    @NonNull
    private final SegmentMetadataClientFactory metaStreamFactory;

    public ByteStreamClientImpl(String scope, Controller controller, ConnectionFactory connectionFactory) {
        this.scope = (String)Preconditions.checkNotNull((Object)scope);
        this.controller = (Controller)Preconditions.checkNotNull((Object)controller);
        this.connectionFactory = (ConnectionFactory)Preconditions.checkNotNull((Object)connectionFactory);
        this.inputStreamFactory = new SegmentInputStreamFactoryImpl(controller, connectionFactory);
        this.outputStreamFactory = new SegmentOutputStreamFactoryImpl(controller, connectionFactory);
        this.metaStreamFactory = new SegmentMetadataClientFactoryImpl(controller, connectionFactory);
    }

    @Override
    public ByteStreamReader createByteStreamReader(String streamName) {
        return this.createByteStreamReaders(new Segment(this.scope, streamName, 0L));
    }

    private ByteStreamReader createByteStreamReaders(Segment segment) {
        String delegationToken = (String)Futures.getAndHandleExceptions(this.controller.getOrRefreshDelegationTokenFor(segment.getScope(), segment.getStream().getStreamName()), RuntimeException::new);
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(delegationToken, this.controller, segment);
        return new ByteStreamReaderImpl(this.inputStreamFactory.createInputStreamForSegment(segment, tokenProvider), this.metaStreamFactory.createSegmentMetadataClient(segment, tokenProvider));
    }

    @Override
    public ByteStreamWriter createByteStreamWriter(String streamName) {
        StreamSegments segments = (StreamSegments)Futures.getThrowingException(this.controller.getCurrentSegments(this.scope, streamName));
        Preconditions.checkArgument((segments.getSegments().size() == 1 ? 1 : 0) != 0, (Object)"Stream is configured with more than one segment");
        Segment segment = segments.getSegments().iterator().next();
        EventWriterConfig config = EventWriterConfig.builder().build();
        String delegationToken = segments.getDelegationToken();
        DelegationTokenProvider tokenProvider = DelegationTokenProviderFactory.create(delegationToken, this.controller, segment);
        return new BufferedByteStreamWriterImpl(new ByteStreamWriterImpl(this.outputStreamFactory.createOutputStreamForSegment(segment, config, tokenProvider), this.metaStreamFactory.createSegmentMetadataClient(segment, tokenProvider)));
    }

    @Override
    public void close() {
        this.controller.close();
        this.connectionFactory.close();
    }

    @ConstructorProperties(value={"scope", "controller", "connectionFactory", "inputStreamFactory", "outputStreamFactory", "metaStreamFactory"})
    @SuppressFBWarnings(justification="generated code")
    public ByteStreamClientImpl(@NonNull String scope, @NonNull Controller controller, @NonNull ConnectionFactory connectionFactory, @NonNull SegmentInputStreamFactory inputStreamFactory, @NonNull SegmentOutputStreamFactory outputStreamFactory, @NonNull SegmentMetadataClientFactory metaStreamFactory) {
        if (scope == null) {
            throw new NullPointerException("scope is marked @NonNull but is null");
        }
        if (controller == null) {
            throw new NullPointerException("controller is marked @NonNull but is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is marked @NonNull but is null");
        }
        if (inputStreamFactory == null) {
            throw new NullPointerException("inputStreamFactory is marked @NonNull but is null");
        }
        if (outputStreamFactory == null) {
            throw new NullPointerException("outputStreamFactory is marked @NonNull but is null");
        }
        if (metaStreamFactory == null) {
            throw new NullPointerException("metaStreamFactory is marked @NonNull but is null");
        }
        this.scope = scope;
        this.controller = controller;
        this.connectionFactory = connectionFactory;
        this.inputStreamFactory = inputStreamFactory;
        this.outputStreamFactory = outputStreamFactory;
        this.metaStreamFactory = metaStreamFactory;
    }
}

