/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import io.pravega.common.ExponentialMovingAverage;
import io.pravega.common.MathHelpers;
import io.pravega.shared.protocol.netty.AppendBatchSizeTracker;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

class AppendBatchSizeTrackerImpl
implements AppendBatchSizeTracker {
    private static final int MAX_BATCH_TIME_MILLIS = 100;
    private static final int MAX_BATCH_SIZE = 0x3FFFFF;
    private final Supplier<Long> clock;
    private final AtomicLong lastAppendNumber;
    private final AtomicLong lastAppendTime;
    private final AtomicLong lastAckNumber;
    private final ExponentialMovingAverage eventSize = new ExponentialMovingAverage(1024.0, 0.1, true);
    private final ExponentialMovingAverage millisBetweenAppends = new ExponentialMovingAverage(10.0, 0.1, false);
    private final ExponentialMovingAverage appendsOutstanding = new ExponentialMovingAverage(2.0, 0.05, false);

    AppendBatchSizeTrackerImpl() {
        this.clock = System::currentTimeMillis;
        this.lastAppendTime = new AtomicLong(this.clock.get());
        this.lastAckNumber = new AtomicLong(0L);
        this.lastAppendNumber = new AtomicLong(0L);
    }

    public void recordAppend(long eventNumber, int size) {
        long now = Math.max(this.lastAppendTime.get(), this.clock.get());
        long last = this.lastAppendTime.getAndSet(now);
        this.lastAppendNumber.set(eventNumber);
        this.millisBetweenAppends.addNewSample((double)(now - last));
        this.appendsOutstanding.addNewSample((double)(eventNumber - this.lastAckNumber.get()));
        this.eventSize.addNewSample((double)size);
    }

    public long recordAck(long eventNumber) {
        this.lastAckNumber.getAndSet(eventNumber);
        long outstandingAppendCount = this.lastAppendNumber.get() - eventNumber;
        this.appendsOutstanding.addNewSample((double)outstandingAppendCount);
        return outstandingAppendCount;
    }

    public int getAppendBlockSize() {
        long numInflight = this.lastAppendNumber.get() - this.lastAckNumber.get();
        if (numInflight <= 1L) {
            return 0;
        }
        double appendsInMaxBatch = Math.max(1.0, 100.0 / this.millisBetweenAppends.getCurrentValue());
        double targetAppendsOutstanding = MathHelpers.minMax((double)(this.appendsOutstanding.getCurrentValue() * 0.5), (double)1.0, (double)appendsInMaxBatch);
        return (int)MathHelpers.minMax((long)((long)(targetAppendsOutstanding * this.eventSize.getCurrentValue())), (long)0L, (long)0x3FFFFFL);
    }

    public int getBatchTimeout() {
        return 100;
    }
}

