/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import io.pravega.client.netty.impl.ClientConnection;
import io.pravega.client.netty.impl.FlowHandler;
import io.pravega.common.Timer;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.metrics.ClientMetricKeys;
import io.pravega.shared.protocol.netty.Append;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.segment.StreamSegmentNameUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionImpl
implements ClientConnection {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ClientConnectionImpl.class);
    private final String connectionName;
    private final int flowId;
    @VisibleForTesting
    private final FlowHandler nettyHandler;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ClientConnectionImpl(String connectionName, int flowId, FlowHandler nettyHandler) {
        this.connectionName = connectionName;
        this.flowId = flowId;
        this.nettyHandler = nettyHandler;
    }

    @Override
    public void send(WireCommand cmd) throws ConnectionFailedException {
        this.checkClientConnectionClosed();
        this.nettyHandler.setRecentMessage();
        Futures.getAndHandleExceptions((java.util.concurrent.Future)this.nettyHandler.getChannel().writeAndFlush((Object)cmd), ConnectionFailedException::new);
    }

    @Override
    public void send(Append append) throws ConnectionFailedException {
        Timer timer = new Timer();
        this.checkClientConnectionClosed();
        this.nettyHandler.setRecentMessage();
        Futures.getAndHandleExceptions((java.util.concurrent.Future)this.nettyHandler.getChannel().writeAndFlush((Object)append), ConnectionFailedException::new);
        this.nettyHandler.getMetricNotifier().updateSuccessMetric(ClientMetricKeys.CLIENT_APPEND_LATENCY, StreamSegmentNameUtils.segmentTags((String)append.getSegment(), (String)append.getWriterId().toString()), timer.getElapsedMillis());
    }

    @Override
    public void sendAsync(WireCommand cmd, ClientConnection.CompletedCallback callback) {
        Channel channel = null;
        try {
            this.checkClientConnectionClosed();
            this.nettyHandler.setRecentMessage();
            channel = this.nettyHandler.getChannel();
            log.debug("Write and flush message {} on channel {}", (Object)cmd, (Object)channel);
            channel.writeAndFlush((Object)cmd).addListener(f -> {
                if (f.isSuccess()) {
                    callback.complete(null);
                } else {
                    callback.complete(new ConnectionFailedException(f.cause()));
                }
            });
        }
        catch (ConnectionFailedException cfe) {
            log.debug("ConnectionFailedException observed when attempting to write WireCommand {} ", (Object)cmd);
            callback.complete(cfe);
        }
        catch (Exception e) {
            log.warn("Exception while attempting to write WireCommand {} on netty channel {}", (Object)cmd, channel);
            callback.complete(new ConnectionFailedException((Throwable)e));
        }
    }

    @Override
    public void sendAsync(List<Append> appends, ClientConnection.CompletedCallback callback) {
        Channel ch;
        try {
            this.checkClientConnectionClosed();
            this.nettyHandler.setRecentMessage();
            ch = this.nettyHandler.getChannel();
        }
        catch (ConnectionFailedException e) {
            callback.complete(new ConnectionFailedException("Connection to " + this.connectionName + " is not established."));
            return;
        }
        PromiseCombiner combiner = new PromiseCombiner();
        for (Append append : appends) {
            combiner.add((Future)ch.write((Object)append));
        }
        ch.flush();
        ChannelPromise promise = ch.newPromise();
        promise.addListener(future -> {
            Throwable cause = future.cause();
            callback.complete(cause == null ? null : new ConnectionFailedException(cause));
        });
        combiner.finish((Promise)promise);
    }

    @Override
    public void close() {
        if (!this.closed.getAndSet(true)) {
            this.nettyHandler.closeFlow(this);
        }
    }

    private void checkClientConnectionClosed() throws ConnectionFailedException {
        if (this.closed.get()) {
            log.error("ClientConnection to {} with flow id {} is already closed", (Object)this.connectionName, (Object)this.flowId);
            throw new ConnectionFailedException("Client connection already closed for flow " + this.flowId);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    public String getConnectionName() {
        return this.connectionName;
    }

    @SuppressFBWarnings(justification="generated code")
    public int getFlowId() {
        return this.flowId;
    }

    @SuppressFBWarnings(justification="generated code")
    public FlowHandler getNettyHandler() {
        return this.nettyHandler;
    }
}

