/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.netty.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.auth.AuthenticationException;
import io.pravega.client.netty.impl.ClientConnection;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.netty.impl.Flow;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.impl.ConnectionClosedException;
import io.pravega.client.stream.impl.Controller;
import io.pravega.common.concurrent.Futures;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.FailingReplyProcessor;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.ReplyProcessor;
import io.pravega.shared.protocol.netty.Request;
import io.pravega.shared.protocol.netty.WireCommand;
import io.pravega.shared.protocol.netty.WireCommands;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawClient
implements AutoCloseable {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(RawClient.class);
    private final CompletableFuture<ClientConnection> connection;
    private final Segment segmentId;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<Long, CompletableFuture<Reply>> requests = new HashMap<Long, CompletableFuture<Reply>>();
    private final ResponseProcessor responseProcessor = new ResponseProcessor();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Flow flow = Flow.create();

    public RawClient(PravegaNodeUri uri, ConnectionFactory connectionFactory) {
        this.segmentId = null;
        this.connection = connectionFactory.establishConnection(this.flow, uri, (ReplyProcessor)this.responseProcessor);
        Futures.exceptionListener(this.connection, e -> this.closeConnection((Throwable)e));
    }

    public RawClient(Controller controller, ConnectionFactory connectionFactory, Segment segmentId) {
        this.segmentId = segmentId;
        this.connection = controller.getEndpointForSegment(segmentId.getScopedName()).thenCompose(uri -> connectionFactory.establishConnection(this.flow, (PravegaNodeUri)uri, (ReplyProcessor)this.responseProcessor));
        Futures.exceptionListener(this.connection, e -> this.closeConnection((Throwable)e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reply(Reply reply) {
        CompletableFuture<Reply> future;
        Object object = this.lock;
        synchronized (object) {
            future = this.requests.remove(reply.getRequestId());
        }
        if (future != null) {
            future.complete(reply);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(Throwable exceptionToInflightRequests) {
        ArrayList<CompletableFuture<Reply>> requestsToFail;
        if (this.closed.get() || exceptionToInflightRequests instanceof ConnectionClosedException) {
            log.debug("Closing connection with exception", exceptionToInflightRequests);
        } else {
            log.warn("Closing connection with exception", exceptionToInflightRequests);
        }
        if (this.closed.compareAndSet(false, true)) {
            this.connection.thenAccept(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    log.warn("Exception tearing down connection: ", (Throwable)e);
                }
            });
        }
        Iterator iterator = this.lock;
        synchronized (iterator) {
            requestsToFail = new ArrayList<CompletableFuture<Reply>>(this.requests.values());
            this.requests.clear();
        }
        for (CompletableFuture completableFuture : requestsToFail) {
            completableFuture.completeExceptionally(exceptionToInflightRequests);
        }
    }

    public <T extends Request & WireCommand> CompletableFuture<Reply> sendRequest(long requestId, T request) {
        return this.connection.thenCompose(c -> {
            log.debug("Sending request: {}", (Object)request);
            CompletableFuture reply = new CompletableFuture();
            Object object = this.lock;
            synchronized (object) {
                this.requests.put(requestId, reply);
            }
            c.sendAsync(request, cfe -> {
                if (cfe != null) {
                    Object object = this.lock;
                    synchronized (object) {
                        this.requests.remove(requestId);
                    }
                    reply.completeExceptionally((Throwable)cfe);
                    this.closeConnection((Throwable)cfe);
                }
            });
            return reply;
        });
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        this.closeConnection(new ConnectionClosedException());
    }

    @SuppressFBWarnings(justification="generated code")
    public Flow getFlow() {
        return this.flow;
    }

    private final class ResponseProcessor
    extends FailingReplyProcessor {
        private ResponseProcessor() {
        }

        public void process(Reply reply) {
            if (reply instanceof WireCommands.Hello) {
                WireCommands.Hello hello = (WireCommands.Hello)reply;
                log.info("Received hello: {}", (Object)hello);
                if (hello.getLowVersion() > 9 || hello.getHighVersion() < 5) {
                    RawClient.this.closeConnection(new IllegalStateException("Incompatible wire protocol versions " + hello));
                }
            } else if (reply instanceof WireCommands.WrongHost) {
                RawClient.this.closeConnection((Throwable)new ConnectionFailedException(reply.toString()));
            } else {
                log.debug("Received reply {}", (Object)reply);
                RawClient.this.reply(reply);
            }
        }

        public void connectionDropped() {
            RawClient.this.closeConnection((Throwable)new ConnectionFailedException());
        }

        public void processingFailure(Exception error) {
            log.warn("Processing failure: ", (Throwable)error);
            RawClient.this.closeConnection(error);
        }

        public void authTokenCheckFailed(WireCommands.AuthTokenCheckFailed authTokenCheckFailed) {
            log.warn("Auth token failure: {}", (Object)authTokenCheckFailed);
            RawClient.this.closeConnection((Throwable)new AuthenticationException(authTokenCheckFailed.toString()));
        }
    }
}

