/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.ConditionalOutputStream;
import io.pravega.client.segment.impl.ConditionalOutputStreamFactory;
import io.pravega.client.segment.impl.ConditionalOutputStreamImpl;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.impl.Controller;
import io.pravega.common.util.Retry;
import java.beans.ConstructorProperties;
import java.util.UUID;

public class ConditionalOutputStreamFactoryImpl
implements ConditionalOutputStreamFactory {
    private final Controller controller;
    private final ConnectionFactory cf;

    @Override
    public ConditionalOutputStream createConditionalOutputStream(Segment segment, DelegationTokenProvider tokenProvider, EventWriterConfig config) {
        return new ConditionalOutputStreamImpl(UUID.randomUUID(), segment, this.controller, this.cf, tokenProvider, this.getRetryFromConfig(config));
    }

    private Retry.RetryWithBackoff getRetryFromConfig(EventWriterConfig config) {
        return Retry.withExpBackoff((long)config.getInitalBackoffMillis(), (int)config.getBackoffMultiple(), (int)config.getRetryAttempts(), (long)config.getMaxBackoffMillis());
    }

    @ConstructorProperties(value={"controller", "cf"})
    @SuppressFBWarnings(justification="generated code")
    public ConditionalOutputStreamFactoryImpl(Controller controller, ConnectionFactory cf) {
        this.controller = controller;
        this.cf = cf;
    }
}

