/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.netty.impl.RawClient;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.segment.impl.ConditionalOutputStream;
import io.pravega.client.segment.impl.NoSuchSegmentException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.impl.Controller;
import io.pravega.common.Exceptions;
import io.pravega.common.util.Retry;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.Reply;
import io.pravega.shared.protocol.netty.WireCommands;
import java.beans.ConstructorProperties;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConditionalOutputStreamImpl
implements ConditionalOutputStream {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ConditionalOutputStreamImpl.class);
    private final UUID writerId;
    private final Segment segmentId;
    private final Controller controller;
    private final ConnectionFactory connectionFactory;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private RawClient client = null;
    private final DelegationTokenProvider tokenProvider;
    private final Supplier<Long> requestIdGenerator = new AtomicLong()::incrementAndGet;
    private final Retry.RetryWithBackoff retrySchedule;

    @Override
    public String getScopedSegmentName() {
        return this.segmentId.getScopedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(ByteBuffer data, long expectedOffset) throws SegmentSealedException {
        Object object = this.lock;
        synchronized (object) {
            long appendSequence = this.requestIdGenerator.get();
            return (Boolean)this.retrySchedule.retryingOn(ConnectionFailedException.class).throwingOn(SegmentSealedException.class).run(() -> {
                CompletableFuture<Reply> reply;
                long requestId;
                if (this.client == null || this.client.isClosed()) {
                    this.client = new RawClient(this.controller, this.connectionFactory, this.segmentId);
                    requestId = this.client.getFlow().getNextSequenceNumber();
                    log.debug("Setting up append on segment: {}", (Object)this.segmentId);
                    WireCommands.SetupAppend setup = new WireCommands.SetupAppend(requestId, this.writerId, this.segmentId.getScopedName(), this.tokenProvider.retrieveToken());
                    reply = this.client.sendRequest(requestId, setup);
                    WireCommands.AppendSetup appendSetup = this.transformAppendSetup(reply.join());
                    if (appendSetup.getLastEventNumber() >= appendSequence) {
                        return true;
                    }
                }
                requestId = this.client.getFlow().getNextSequenceNumber();
                WireCommands.ConditionalAppend request = new WireCommands.ConditionalAppend(this.writerId, appendSequence, expectedOffset, new WireCommands.Event(Unpooled.wrappedBuffer((ByteBuffer)data)), requestId);
                reply = this.client.sendRequest(requestId, request);
                return this.transformDataAppended(reply.join());
            });
        }
    }

    @Override
    public void close() {
        log.info("Closing segment metadata connection for {}", (Object)this.segmentId);
        if (this.closed.compareAndSet(false, true)) {
            this.closeConnection("Closed call");
        }
    }

    private WireCommands.AppendSetup transformAppendSetup(Reply reply) {
        if (reply instanceof WireCommands.AppendSetup) {
            return (WireCommands.AppendSetup)reply;
        }
        throw this.handelUnexpectedReply(reply);
    }

    private boolean transformDataAppended(Reply reply) {
        if (reply instanceof WireCommands.DataAppended) {
            return true;
        }
        if (reply instanceof WireCommands.ConditionalCheckFailed) {
            return false;
        }
        throw this.handelUnexpectedReply(reply);
    }

    private RuntimeException handelUnexpectedReply(Reply reply) {
        this.closeConnection(reply.toString());
        if (reply instanceof WireCommands.NoSuchSegment) {
            throw new NoSuchSegmentException(reply.toString());
        }
        if (reply instanceof WireCommands.SegmentIsSealed) {
            throw Exceptions.sneakyThrow((Throwable)new SegmentSealedException(reply.toString()));
        }
        if (reply instanceof WireCommands.WrongHost) {
            throw Exceptions.sneakyThrow((Throwable)new ConnectionFailedException(reply.toString()));
        }
        throw Exceptions.sneakyThrow((Throwable)new ConnectionFailedException("Unexpected reply of " + reply + " when expecting an AppendSetup"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection(String message) {
        RawClient c;
        if (this.closed.get()) {
            log.debug("Closing connection as a result of receiving: {} for segment: {}", (Object)message, (Object)this.segmentId);
        } else {
            log.warn("Closing connection as a result of receiving: {} for segment: {}", (Object)message, (Object)this.segmentId);
        }
        Object object = this.lock;
        synchronized (object) {
            c = this.client;
            this.client = null;
        }
        if (c != null) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warn("Exception tearing down connection: ", (Throwable)e);
            }
        }
    }

    @ConstructorProperties(value={"writerId", "segmentId", "controller", "connectionFactory", "tokenProvider", "retrySchedule"})
    @SuppressFBWarnings(justification="generated code")
    public ConditionalOutputStreamImpl(UUID writerId, Segment segmentId, Controller controller, ConnectionFactory connectionFactory, DelegationTokenProvider tokenProvider, Retry.RetryWithBackoff retrySchedule) {
        this.writerId = writerId;
        this.segmentId = segmentId;
        this.controller = controller;
        this.connectionFactory = connectionFactory;
        this.tokenProvider = tokenProvider;
        this.retrySchedule = retrySchedule;
    }
}

