/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.segment.impl;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.netty.impl.ConnectionFactory;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.AsyncSegmentInputStream;
import io.pravega.client.segment.impl.AsyncSegmentInputStreamImpl;
import io.pravega.client.segment.impl.EventSegmentReader;
import io.pravega.client.segment.impl.EventSegmentReaderImpl;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentInputStream;
import io.pravega.client.segment.impl.SegmentInputStreamFactory;
import io.pravega.client.segment.impl.SegmentInputStreamImpl;
import io.pravega.client.stream.impl.Controller;
import io.pravega.common.MathHelpers;
import io.pravega.common.concurrent.Futures;
import java.beans.ConstructorProperties;

@VisibleForTesting
public class SegmentInputStreamFactoryImpl
implements SegmentInputStreamFactory {
    private final Controller controller;
    private final ConnectionFactory cf;

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment) {
        return this.createEventReaderForSegment(segment, 0x100000);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, long endOffset) {
        return this.getEventSegmentReader(segment, endOffset, 0x100000);
    }

    @Override
    public EventSegmentReader createEventReaderForSegment(Segment segment, int bufferSize) {
        return this.getEventSegmentReader(segment, Long.MAX_VALUE, bufferSize);
    }

    private EventSegmentReader getEventSegmentReader(Segment segment, long endOffset, int bufferSize) {
        String delegationToken = (String)Futures.getAndHandleExceptions(this.controller.getOrRefreshDelegationTokenFor(segment.getScope(), segment.getStream().getStreamName()), RuntimeException::new);
        AsyncSegmentInputStreamImpl async = new AsyncSegmentInputStreamImpl(this.controller, this.cf, segment, DelegationTokenProviderFactory.create(delegationToken, this.controller, segment));
        async.getConnection();
        bufferSize = MathHelpers.minMax((int)bufferSize, (int)1024, (int)0xA00000);
        return SegmentInputStreamFactoryImpl.getEventSegmentReader(async, 0L, endOffset, bufferSize);
    }

    @VisibleForTesting
    static EventSegmentReaderImpl getEventSegmentReader(AsyncSegmentInputStream async, long startOffset, long endOffset, int bufferSize) {
        return new EventSegmentReaderImpl(new SegmentInputStreamImpl(async, startOffset, endOffset, bufferSize));
    }

    @VisibleForTesting
    static EventSegmentReaderImpl getEventSegmentReader(AsyncSegmentInputStream async, long startOffset) {
        return new EventSegmentReaderImpl(new SegmentInputStreamImpl(async, startOffset));
    }

    @Override
    public SegmentInputStream createInputStreamForSegment(Segment segment, DelegationTokenProvider tokenProvider) {
        AsyncSegmentInputStreamImpl async = new AsyncSegmentInputStreamImpl(this.controller, this.cf, segment, tokenProvider);
        async.getConnection();
        return new SegmentInputStreamImpl(async, 0L);
    }

    @ConstructorProperties(value={"controller", "cf"})
    @SuppressFBWarnings(justification="generated code")
    public SegmentInputStreamFactoryImpl(Controller controller, ConnectionFactory cf) {
        this.controller = controller;
        this.cf = cf;
    }
}

