/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.state.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.state.Revision;
import java.beans.ConstructorProperties;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;

public class RevisionImpl
implements Revision,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Segment segment;
    private final long offsetInSegment;
    private final int eventAtOffset;

    @Override
    public int compareTo(Revision o) {
        Preconditions.checkArgument((boolean)this.segment.equals(o.asImpl().getSegment()));
        int result = Long.compare(this.offsetInSegment, o.asImpl().offsetInSegment);
        return result != 0 ? result : Integer.compare(this.eventAtOffset, o.asImpl().eventAtOffset);
    }

    @Override
    public RevisionImpl asImpl() {
        return this;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.segment.getScopedName());
        sb.append(":");
        sb.append(this.offsetInSegment);
        sb.append(":");
        sb.append(this.eventAtOffset);
        return sb.toString();
    }

    public static Revision fromString(String scopedName) {
        String[] tokens = scopedName.split(":");
        if (tokens.length == 3) {
            return new RevisionImpl(Segment.fromScopedName(tokens[0]), Long.parseLong(tokens[1]), Integer.parseInt(tokens[2]));
        }
        throw new SerializationException("Not a valid segment name: " + scopedName);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.toString());
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevisionImpl)) {
            return false;
        }
        RevisionImpl other = (RevisionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$segment = this.getSegment();
        Segment other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment)) {
            return false;
        }
        if (this.getOffsetInSegment() != other.getOffsetInSegment()) {
            return false;
        }
        return this.getEventAtOffset() == other.getEventAtOffset();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof RevisionImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        long $offsetInSegment = this.getOffsetInSegment();
        result = result * 59 + (int)($offsetInSegment >>> 32 ^ $offsetInSegment);
        result = result * 59 + this.getEventAtOffset();
        return result;
    }

    @ConstructorProperties(value={"segment", "offsetInSegment", "eventAtOffset"})
    @SuppressFBWarnings(justification="generated code")
    RevisionImpl(Segment segment, long offsetInSegment, int eventAtOffset) {
        this.segment = segment;
        this.offsetInSegment = offsetInSegment;
        this.eventAtOffset = eventAtOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    Segment getSegment() {
        return this.segment;
    }

    @SuppressFBWarnings(justification="generated code")
    long getOffsetInSegment() {
        return this.offsetInSegment;
    }

    @SuppressFBWarnings(justification="generated code")
    int getEventAtOffset() {
        return this.eventAtOffset;
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;

        Object readResolve() throws ObjectStreamException {
            return Revision.fromString(this.value);
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        public SerializedForm(String value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "RevisionImpl.SerializedForm(value=" + this.getValue() + ")";
        }
    }
}

