/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.UUID;

public class Sequence
implements Comparable<Sequence>,
Serializable {
    public static final Sequence MAX_VALUE = new Sequence(Long.MAX_VALUE, Long.MAX_VALUE);
    public static final Sequence MIN_VALUE = new Sequence(Long.MIN_VALUE, Long.MIN_VALUE);
    private static final long serialVersionUID = 1L;
    private final long highOrder;
    private final long lowOrder;

    @Override
    public int compareTo(Sequence o) {
        int result = Long.compare(this.highOrder, o.highOrder);
        if (result == 0) {
            return Long.compare(this.lowOrder, o.lowOrder);
        }
        return result;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(new UUID(this.highOrder, this.lowOrder));
    }

    @ConstructorProperties(value={"highOrder", "lowOrder"})
    @SuppressFBWarnings(justification="generated code")
    private Sequence(long highOrder, long lowOrder) {
        this.highOrder = highOrder;
        this.lowOrder = lowOrder;
    }

    @SuppressFBWarnings(justification="generated code")
    public static Sequence create(long highOrder, long lowOrder) {
        return new Sequence(highOrder, lowOrder);
    }

    @SuppressFBWarnings(justification="generated code")
    public long getHighOrder() {
        return this.highOrder;
    }

    @SuppressFBWarnings(justification="generated code")
    public long getLowOrder() {
        return this.lowOrder;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence other = (Sequence)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getHighOrder() != other.getHighOrder()) {
            return false;
        }
        return this.getLowOrder() == other.getLowOrder();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof Sequence;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $highOrder = this.getHighOrder();
        result = result * 59 + (int)($highOrder >>> 32 ^ $highOrder);
        long $lowOrder = this.getLowOrder();
        result = result * 59 + (int)($lowOrder >>> 32 ^ $lowOrder);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "Sequence(highOrder=" + this.getHighOrder() + ", lowOrder=" + this.getLowOrder() + ")";
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID value;

        Object readResolve() throws ObjectStreamException {
            return new Sequence(this.value.getMostSignificantBits(), this.value.getLeastSignificantBits());
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        public SerializedForm(UUID value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        public UUID getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$value = this.getValue();
            UUID other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "Sequence.SerializedForm(value=" + this.getValue() + ")";
        }
    }
}

