/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.security.auth.DelegationTokenProvider;
import io.pravega.client.security.auth.DelegationTokenProviderFactory;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.segment.impl.SegmentOutputStream;
import io.pravega.client.segment.impl.SegmentOutputStreamFactory;
import io.pravega.client.segment.impl.SegmentSealedException;
import io.pravega.client.stream.EventStreamWriter;
import io.pravega.client.stream.EventWriterConfig;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.TransactionalEventStreamWriter;
import io.pravega.client.stream.TxnFailedException;
import io.pravega.client.stream.impl.Controller;
import io.pravega.client.stream.impl.PendingEvent;
import io.pravega.client.stream.impl.Pinger;
import io.pravega.client.stream.impl.SegmentSelector;
import io.pravega.client.stream.impl.SegmentTransaction;
import io.pravega.client.stream.impl.SegmentTransactionImpl;
import io.pravega.client.stream.impl.StreamSegments;
import io.pravega.client.stream.impl.TxnSegments;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ByteBufferUtils;
import io.pravega.common.util.Retry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStreamWriterImpl<Type>
implements EventStreamWriter<Type>,
TransactionalEventStreamWriter<Type> {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(EventStreamWriterImpl.class);
    private final Object writeFlushLock = new Object();
    private final Object writeSealLock = new Object();
    private final Stream stream;
    private final String writerId;
    private final Serializer<Type> serializer;
    private final SegmentOutputStreamFactory outputStreamFactory;
    private final Controller controller;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final EventWriterConfig config;
    private final SegmentSelector selector;
    private final Consumer<Segment> segmentSealedCallBack;
    private final ConcurrentLinkedQueue<Segment> sealedSegmentQueue = new ConcurrentLinkedQueue();
    private final ExecutorService retransmitPool;
    private final Pinger pinger;
    private final DelegationTokenProvider tokenProvider;

    EventStreamWriterImpl(Stream stream, String writerId, Controller controller, SegmentOutputStreamFactory outputStreamFactory, Serializer<Type> serializer, EventWriterConfig config, ExecutorService retransmitPool, ScheduledExecutorService internalExecutor) {
        this.writerId = writerId;
        this.stream = (Stream)Preconditions.checkNotNull((Object)stream);
        this.controller = (Controller)Preconditions.checkNotNull((Object)controller);
        this.segmentSealedCallBack = this::handleLogSealed;
        this.outputStreamFactory = (SegmentOutputStreamFactory)Preconditions.checkNotNull((Object)outputStreamFactory);
        this.tokenProvider = DelegationTokenProviderFactory.create(this.controller, this.stream.getScope(), this.stream.getStreamName());
        this.selector = new SegmentSelector(stream, controller, outputStreamFactory, config, this.tokenProvider);
        this.serializer = (Serializer)Preconditions.checkNotNull(serializer);
        this.config = config;
        this.retransmitPool = (ExecutorService)Preconditions.checkNotNull((Object)retransmitPool);
        this.pinger = new Pinger(config, stream, controller, internalExecutor);
        List<PendingEvent> failedEvents = this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack);
        assert (failedEvents.isEmpty()) : "There should not be any events to have failed";
        if (config.isAutomaticallyNoteTime()) {
            internalExecutor.scheduleWithFixedDelay(() -> this.noteTimeInternal(System.currentTimeMillis()), 5L, 5L, TimeUnit.SECONDS);
        }
    }

    @Override
    public CompletableFuture<Void> writeEvent(Type event) {
        return this.writeEventInternal(null, event);
    }

    @Override
    public CompletableFuture<Void> writeEvent(String routingKey, Type event) {
        Preconditions.checkNotNull((Object)routingKey);
        return this.writeEventInternal(routingKey, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Void> writeEventInternal(String routingKey, Type event) {
        Preconditions.checkNotNull(event);
        Exceptions.checkNotClosed((boolean)this.closed.get(), (Object)this);
        ByteBuffer data = this.serializer.serialize(event);
        CompletableFuture<Void> ackFuture = new CompletableFuture<Void>();
        Object object = this.writeFlushLock;
        synchronized (object) {
            Object object2 = this.writeSealLock;
            synchronized (object2) {
                SegmentOutputStream segmentWriter = this.selector.getSegmentOutputStreamForKey(routingKey);
                while (segmentWriter == null) {
                    log.info("Don't have a writer for segment: {}", (Object)this.selector.getSegmentForEvent(routingKey));
                    this.handleMissingLog();
                    segmentWriter = this.selector.getSegmentOutputStreamForKey(routingKey);
                }
                segmentWriter.write(PendingEvent.withHeader(routingKey, data, ackFuture));
            }
        }
        return ackFuture;
    }

    @GuardedBy(value="writeSealLock")
    private void handleMissingLog() {
        List<PendingEvent> toResend = this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack);
        this.resend(toResend);
    }

    private void handleLogSealed(Segment segment) {
        this.sealedSegmentQueue.add(segment);
        this.retransmitPool.execute(() -> Retry.indefinitelyWithExpBackoff((long)this.config.getInitalBackoffMillis(), (int)this.config.getBackoffMultiple(), (long)this.config.getMaxBackoffMillis(), t -> log.error("Encountered exception when handling a sealed segment: ", t)).run(() -> {
            Object object = this.writeSealLock;
            synchronized (object) {
                Segment toSeal = this.sealedSegmentQueue.poll();
                log.info("Sealing segment {} ", (Object)toSeal);
                while (toSeal != null) {
                    this.resend(this.selector.refreshSegmentEventWritersUponSealed(toSeal, this.segmentSealedCallBack));
                    this.selector.removeSegmentWriter(toSeal);
                    for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                        try {
                            writer.write(PendingEvent.withoutHeader(null, ByteBufferUtils.EMPTY, null));
                            writer.flush();
                        }
                        catch (SegmentSealedException e) {
                            log.info("Flush on segment {} failed due to {}, it will be retried.", (Object)writer.getSegmentName(), (Object)e.getMessage());
                        }
                    }
                    toSeal = this.sealedSegmentQueue.poll();
                    log.info("Sealing another segment {} ", (Object)toSeal);
                }
            }
            return null;
        }));
    }

    @GuardedBy(value="writeSealLock")
    private void resend(List<PendingEvent> toResend) {
        while (!toResend.isEmpty()) {
            ArrayList<PendingEvent> unsent = new ArrayList<PendingEvent>();
            boolean sendFailed = false;
            log.info("Resending {} events", (Object)toResend.size());
            for (PendingEvent event : toResend) {
                if (sendFailed) {
                    unsent.add(event);
                    continue;
                }
                SegmentOutputStream segmentWriter = this.selector.getSegmentOutputStreamForKey(event.getRoutingKey());
                if (segmentWriter == null) {
                    log.info("No writer for segment during resend.");
                    unsent.addAll(this.selector.refreshSegmentEventWriters(this.segmentSealedCallBack));
                    sendFailed = true;
                    continue;
                }
                segmentWriter.write(event);
            }
            toResend = unsent;
        }
    }

    @Override
    @Deprecated
    public Transaction<Type> beginTxn() {
        TxnSegments txnSegments = (TxnSegments)Futures.getAndHandleExceptions(this.controller.createTransaction(this.stream, this.config.getTransactionTimeoutTime()), RuntimeException::new);
        UUID txnId = txnSegments.getTxnId();
        HashMap transactions = new HashMap();
        this.tokenProvider.populateToken(txnSegments.getStreamSegments().getDelegationToken());
        for (Segment s : txnSegments.getStreamSegments().getSegments()) {
            SegmentOutputStream out = this.outputStreamFactory.createOutputStreamForTransaction(s, txnId, this.config, this.tokenProvider);
            SegmentTransactionImpl<Type> impl = new SegmentTransactionImpl<Type>(txnId, out, this.serializer);
            transactions.put(s, impl);
        }
        this.pinger.startPing(txnId);
        return new TransactionImpl(this.writerId, txnId, transactions, txnSegments.getStreamSegments(), this.controller, this.stream, this.pinger);
    }

    @Override
    @Deprecated
    public Transaction<Type> getTxn(UUID txId) {
        StreamSegments segments = (StreamSegments)Futures.getAndHandleExceptions(this.controller.getCurrentSegments(this.stream.getScope(), this.stream.getStreamName()), RuntimeException::new);
        Transaction.Status status = (Transaction.Status)((Object)Futures.getAndHandleExceptions(this.controller.checkTransactionStatus(this.stream, txId), RuntimeException::new));
        if (status != Transaction.Status.OPEN) {
            return new TransactionImpl(this.writerId, txId, this.controller, this.stream);
        }
        HashMap transactions = new HashMap();
        this.tokenProvider.populateToken(segments.getDelegationToken());
        for (Segment s : segments.getSegments()) {
            SegmentOutputStream out = this.outputStreamFactory.createOutputStreamForTransaction(s, txId, this.config, this.tokenProvider);
            SegmentTransactionImpl<Type> impl = new SegmentTransactionImpl<Type>(txId, out, this.serializer);
            transactions.put(s, impl);
        }
        return new TransactionImpl(this.writerId, txId, transactions, segments, this.controller, this.stream, this.pinger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Preconditions.checkState((!this.closed.get() ? 1 : 0) != 0);
        Object object = this.writeFlushLock;
        synchronized (object) {
            boolean success = false;
            block5: while (!success) {
                success = true;
                for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                    try {
                        writer.flush();
                    }
                    catch (SegmentSealedException e) {
                        success = false;
                        log.warn("Flush on segment {} failed due to {}, it will be retried.", (Object)writer.getSegmentName(), (Object)e.getMessage());
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.pinger.close();
        Object object = this.writeFlushLock;
        synchronized (object) {
            boolean success = false;
            while (!success) {
                success = true;
                for (SegmentOutputStream writer : this.selector.getWriters().values()) {
                    try {
                        writer.close();
                    }
                    catch (SegmentSealedException e) {
                        success = false;
                        log.warn("Close failed due to {}, it will be retried.", (Object)e.getMessage());
                    }
                }
            }
        }
        ExecutorServiceHelpers.shutdown((ExecutorService[])new ExecutorService[]{this.retransmitPool});
    }

    @Override
    public EventWriterConfig getConfig() {
        return this.config;
    }

    @Override
    public void noteTime(long timestamp) {
        Preconditions.checkState((!this.config.isAutomaticallyNoteTime() ? 1 : 0) != 0, (Object)"To note time, automatic noting of time should be disabled.");
        this.noteTimeInternal(timestamp);
    }

    private void noteTimeInternal(long timestamp) {
        Map<Segment, Long> offsets = this.selector.getWriters().entrySet().stream().collect(Collectors.toMap(e -> (Segment)e.getKey(), e -> ((SegmentOutputStream)e.getValue()).getLastObservedWriteOffset()));
        WriterPosition position = new WriterPosition(offsets);
        this.controller.noteTimestampFromWriter(this.writerId, this.stream, timestamp, position);
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "EventStreamWriterImpl(stream=" + this.stream + ", closed=" + this.closed + ")";
    }

    private static class TransactionImpl<Type>
    implements Transaction<Type> {
        private final String writerId;
        private final Map<Segment, SegmentTransaction<Type>> inner;
        private final UUID txId;
        private final AtomicBoolean closed = new AtomicBoolean(false);
        private final Controller controller;
        private final Stream stream;
        private final Pinger pinger;
        private StreamSegments segments;

        TransactionImpl(String writerId, UUID txId, Map<Segment, SegmentTransaction<Type>> transactions, StreamSegments segments, Controller controller, Stream stream, Pinger pinger) {
            this.writerId = writerId;
            this.txId = txId;
            this.inner = transactions;
            this.segments = segments;
            this.controller = controller;
            this.stream = stream;
            this.pinger = pinger;
        }

        TransactionImpl(String writerId, UUID txId, Controller controller, Stream stream) {
            this.writerId = writerId;
            this.txId = txId;
            this.inner = null;
            this.segments = null;
            this.controller = controller;
            this.stream = stream;
            this.pinger = null;
            this.closed.set(true);
        }

        @Override
        public void writeEvent(Type event) throws TxnFailedException {
            this.writeEvent(this.txId.toString(), event);
        }

        @Override
        public void writeEvent(String routingKey, Type event) throws TxnFailedException {
            Preconditions.checkNotNull(event);
            this.throwIfClosed();
            Segment s = this.segments.getSegmentForKey(routingKey);
            SegmentTransaction<Type> transaction = this.inner.get(s);
            transaction.writeEvent(event);
        }

        @Override
        public void commit() throws TxnFailedException {
            this.throwIfClosed();
            for (SegmentTransaction<Type> tx : this.inner.values()) {
                tx.close();
            }
            Futures.getAndHandleExceptions(this.controller.commitTransaction(this.stream, this.writerId, null, this.txId), TxnFailedException::new);
            this.pinger.stopPing(this.txId);
            this.closed.set(true);
        }

        @Override
        public void commit(long timestamp) throws TxnFailedException {
            this.throwIfClosed();
            for (SegmentTransaction<Type> tx : this.inner.values()) {
                tx.close();
            }
            Futures.getAndHandleExceptions(this.controller.commitTransaction(this.stream, this.writerId, timestamp, this.txId), TxnFailedException::new);
            this.pinger.stopPing(this.txId);
            this.closed.set(true);
        }

        @Override
        public void abort() {
            if (!this.closed.get()) {
                for (SegmentTransaction<Type> tx : this.inner.values()) {
                    try {
                        tx.close();
                    }
                    catch (TxnFailedException e) {
                        log.debug("Got exception while writing to transaction on abort: {}", (Object)e.getMessage());
                    }
                }
                this.pinger.stopPing(this.txId);
                Futures.getAndHandleExceptions(this.controller.abortTransaction(this.stream, this.txId), RuntimeException::new);
                this.closed.set(true);
            }
        }

        @Override
        public Transaction.Status checkStatus() {
            return (Transaction.Status)((Object)Futures.getAndHandleExceptions(this.controller.checkTransactionStatus(this.stream, this.txId), RuntimeException::new));
        }

        @Override
        public void flush() throws TxnFailedException {
            this.throwIfClosed();
            for (SegmentTransaction<Type> tx : this.inner.values()) {
                tx.flush();
            }
        }

        @Override
        public UUID getTxnId() {
            return this.txId;
        }

        private void throwIfClosed() throws TxnFailedException {
            if (this.closed.get()) {
                throw new TxnFailedException();
            }
        }
    }
}

