/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.Position;
import io.pravega.client.stream.impl.PositionInternal;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.common.util.ToStringUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PositionImpl
extends PositionInternal {
    private static final PositionSerializer SERIALIZER = new PositionSerializer();
    private final Map<Segment, Long> ownedSegments;
    private final Map<Segment, SegmentWithRange.Range> segmentRanges;

    public PositionImpl(Map<SegmentWithRange, Long> segments) {
        this.ownedSegments = new HashMap<Segment, Long>(segments.size());
        this.segmentRanges = new HashMap<Segment, SegmentWithRange.Range>(segments.size());
        for (Map.Entry<SegmentWithRange, Long> entry : segments.entrySet()) {
            SegmentWithRange s = entry.getKey();
            this.ownedSegments.put(s.getSegment(), entry.getValue());
            this.segmentRanges.put(s.getSegment(), s.getRange());
        }
    }

    private PositionImpl(Map<Segment, Long> ownedSegments, Map<Segment, SegmentWithRange.Range> segmentRanges) {
        this.ownedSegments = ownedSegments;
        this.segmentRanges = segmentRanges == null ? Collections.emptyMap() : segmentRanges;
    }

    @Override
    public Set<Segment> getOwnedSegments() {
        return Collections.unmodifiableSet(this.ownedSegments.keySet());
    }

    @Override
    public Map<Segment, Long> getOwnedSegmentsWithOffsets() {
        return Collections.unmodifiableMap(this.ownedSegments);
    }

    @Override
    Map<SegmentWithRange, Long> getOwnedSegmentRangesWithOffsets() {
        HashMap<SegmentWithRange, Long> result = new HashMap<SegmentWithRange, Long>();
        for (Map.Entry<Segment, Long> entry : this.ownedSegments.entrySet()) {
            result.put(new SegmentWithRange(entry.getKey(), this.segmentRanges.get(entry.getKey())), entry.getValue());
        }
        return result;
    }

    @Override
    public Set<Segment> getCompletedSegments() {
        return this.ownedSegments.entrySet().stream().filter(x -> (Long)x.getValue() < 0L).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public Long getOffsetForOwnedSegment(Segment segmentId) {
        return this.ownedSegments.get(segmentId);
    }

    @Override
    public PositionImpl asImpl() {
        return this;
    }

    public String toString() {
        return ToStringUtils.mapToString(this.ownedSegments);
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static Position fromBytes(ByteBuffer buff) {
        return (Position)SERIALIZER.deserialize((ArrayView)new ByteArraySegment(buff));
    }

    @SuppressFBWarnings(justification="generated code")
    public static PositionBuilder builder() {
        return new PositionBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PositionImpl)) {
            return false;
        }
        PositionImpl other = (PositionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<Segment> this$ownedSegments = this.getOwnedSegments();
        Set<Segment> other$ownedSegments = other.getOwnedSegments();
        if (this$ownedSegments == null ? other$ownedSegments != null : !((Object)this$ownedSegments).equals(other$ownedSegments)) {
            return false;
        }
        Map<Segment, SegmentWithRange.Range> this$segmentRanges = this.segmentRanges;
        Map<Segment, SegmentWithRange.Range> other$segmentRanges = other.segmentRanges;
        return !(this$segmentRanges == null ? other$segmentRanges != null : !((Object)this$segmentRanges).equals(other$segmentRanges));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof PositionImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<Segment> $ownedSegments = this.getOwnedSegments();
        result = result * 59 + ($ownedSegments == null ? 43 : ((Object)$ownedSegments).hashCode());
        Map<Segment, SegmentWithRange.Range> $segmentRanges = this.segmentRanges;
        result = result * 59 + ($segmentRanges == null ? 43 : ((Object)$segmentRanges).hashCode());
        return result;
    }

    private static class PositionSerializer
    extends VersionedSerializer.WithBuilder<PositionImpl, PositionBuilder> {
        private PositionSerializer() {
        }

        protected PositionBuilder newBuilder() {
            return PositionImpl.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
        }

        private void read00(RevisionDataInput revisionDataInput, PositionBuilder builder) throws IOException {
            Map map = revisionDataInput.readMap(in -> Segment.fromScopedName(in.readUTF()), RevisionDataInput::readCompactLong);
            builder.ownedSegments(map);
        }

        private void write00(PositionImpl position, RevisionDataOutput revisionDataOutput) throws IOException {
            Map<Segment, Long> map = position.getOwnedSegmentsWithOffsets();
            revisionDataOutput.writeMap(map, (out, s) -> out.writeUTF(s.getScopedName()), (out, offset) -> out.writeCompactLong(offset.longValue()));
        }

        private void read01(RevisionDataInput revisionDataInput, PositionBuilder builder) throws IOException {
            Map map = revisionDataInput.readMap(in -> Segment.fromScopedName(in.readUTF()), PositionSerializer::readRange);
            builder.segmentRanges(map);
        }

        private void write01(PositionImpl position, RevisionDataOutput revisionDataOutput) throws IOException {
            Map map = position.segmentRanges;
            revisionDataOutput.writeMap(map, (out, s) -> out.writeUTF(s.getScopedName()), PositionSerializer::writeRange);
        }

        private static void writeRange(RevisionDataOutput out, SegmentWithRange.Range range) throws IOException {
            double high;
            double low;
            if (range == null) {
                low = -1.0;
                high = -1.0;
            } else {
                low = range.getLow();
                high = range.getHigh();
            }
            out.writeDouble(low);
            out.writeDouble(high);
        }

        private static SegmentWithRange.Range readRange(RevisionDataInput in) throws IOException {
            double low = in.readDouble();
            double high = in.readDouble();
            return low < 0.0 || high < 0.0 ? null : new SegmentWithRange.Range(low, high);
        }
    }

    private static class PositionBuilder
    implements ObjectBuilder<PositionImpl> {
        @SuppressFBWarnings(justification="generated code")
        private Map<Segment, Long> ownedSegments;
        @SuppressFBWarnings(justification="generated code")
        private Map<Segment, SegmentWithRange.Range> segmentRanges;

        @SuppressFBWarnings(justification="generated code")
        PositionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public PositionBuilder ownedSegments(Map<Segment, Long> ownedSegments) {
            this.ownedSegments = ownedSegments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public PositionBuilder segmentRanges(Map<Segment, SegmentWithRange.Range> segmentRanges) {
            this.segmentRanges = segmentRanges;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public PositionImpl build() {
            return new PositionImpl(this.ownedSegments, this.segmentRanges);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "PositionImpl.PositionBuilder(ownedSegments=" + this.ownedSegments + ", segmentRanges=" + this.segmentRanges + ")";
        }
    }
}

