/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.Revision;
import io.pravega.client.state.Revisioned;
import io.pravega.client.state.Update;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.impl.CheckpointState;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamCutImpl;
import io.pravega.common.Exceptions;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroupState
implements Revisioned {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(ReaderGroupState.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    private static final long ASSUMED_LAG_MILLIS = 30000L;
    private final String scopedSynchronizerStream;
    private final ReaderGroupConfig config;
    @GuardedBy(value="$lock")
    private Revision revision;
    @GuardedBy(value="$lock")
    @VisibleForTesting
    private final CheckpointState checkpointState;
    @GuardedBy(value="$lock")
    private final Map<String, Long> distanceToTail;
    @GuardedBy(value="$lock")
    private final Map<SegmentWithRange, Set<Long>> futureSegments;
    @GuardedBy(value="$lock")
    private final Map<String, Map<SegmentWithRange, Long>> assignedSegments;
    @GuardedBy(value="$lock")
    private final Map<SegmentWithRange, Long> unassignedSegments;
    @GuardedBy(value="$lock")
    private final Map<SegmentWithRange, Long> lastReadPosition;
    private final Map<Segment, Long> endSegments;

    ReaderGroupState(String scopedSynchronizerStream, Revision revision, ReaderGroupConfig config, Map<SegmentWithRange, Long> segmentsToOffsets, Map<Segment, Long> endSegments) {
        Exceptions.checkNotNullOrEmpty((String)scopedSynchronizerStream, (String)"scopedSynchronizerStream");
        Preconditions.checkNotNull((Object)revision);
        Preconditions.checkNotNull((Object)config);
        Exceptions.checkNotNullOrEmpty(segmentsToOffsets.entrySet(), (String)"segmentsToOffsets");
        this.scopedSynchronizerStream = scopedSynchronizerStream;
        this.config = config;
        this.revision = revision;
        this.checkpointState = new CheckpointState();
        this.distanceToTail = new HashMap<String, Long>();
        this.futureSegments = new HashMap<SegmentWithRange, Set<Long>>();
        this.assignedSegments = new HashMap<String, Map<SegmentWithRange, Long>>();
        this.unassignedSegments = new LinkedHashMap<SegmentWithRange, Long>(segmentsToOffsets);
        this.lastReadPosition = new HashMap<SegmentWithRange, Long>(segmentsToOffsets);
        this.endSegments = ImmutableMap.copyOf(endSegments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Double> getRelativeSizes() {
        Object object = this.$lock;
        synchronized (object) {
            long maxDistance = Long.MIN_VALUE;
            HashMap<String, Double> result = new HashMap<String, Double>();
            for (Map.Entry<String, Long> entry : this.distanceToTail.entrySet()) {
                Map<SegmentWithRange, Long> segments = this.assignedSegments.get(entry.getKey());
                if (segments == null || segments.isEmpty()) continue;
                maxDistance = Math.max(Math.max(30000L, entry.getValue()), maxDistance);
            }
            for (Map.Entry<String, Object> entry : this.assignedSegments.entrySet()) {
                if (((Map)entry.getValue()).isEmpty()) {
                    result.put(entry.getKey(), 0.0);
                    continue;
                }
                Long distance = Math.max(30000L, this.distanceToTail.get(entry.getKey()));
                result.put(entry.getKey(), (double)((long)((Map)entry.getValue()).size() * distance) / (double)maxDistance);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfReaders() {
        Object object = this.$lock;
        synchronized (object) {
            return this.assignedSegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getOnlineReaders() {
        Object object = this.$lock;
        synchronized (object) {
            return new HashSet<String>(this.assignedSegments.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRanking(String reader) {
        Object object = this.$lock;
        synchronized (object) {
            List sorted = this.getRelativeSizes().entrySet().stream().sorted((o1, o2) -> Double.compare((Double)o2.getValue(), (Double)o1.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            return sorted.indexOf(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Revision getRevision() {
        Object object = this.$lock;
        synchronized (object) {
            return this.revision;
        }
    }

    @Override
    public String getScopedStreamName() {
        return this.scopedSynchronizerStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Segment> getSegments(String reader) {
        Object object = this.$lock;
        synchronized (object) {
            Map<SegmentWithRange, Long> segments = this.assignedSegments.get(reader);
            if (segments == null) {
                return null;
            }
            return segments.keySet().stream().map(s -> s.getSegment()).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Map<SegmentWithRange, Long> getAssignedSegments(String reader) {
        Object object = this.$lock;
        synchronized (object) {
            return this.assignedSegments.get(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Stream, Map<SegmentWithRange, Long>> getPositions() {
        Object object = this.$lock;
        synchronized (object) {
            HashMap<Stream, Map<SegmentWithRange, Long>> result = new HashMap<Stream, Map<SegmentWithRange, Long>>();
            for (Map.Entry<SegmentWithRange, Long> entry : this.unassignedSegments.entrySet()) {
                result.computeIfAbsent(entry.getKey().getSegment().getStream(), s -> new HashMap()).put(entry.getKey(), entry.getValue());
            }
            for (Map map : this.assignedSegments.values()) {
                for (Map.Entry entry : map.entrySet()) {
                    result.computeIfAbsent(((SegmentWithRange)entry.getKey()).getSegment().getStream(), s -> new HashMap()).put(entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SegmentWithRange, Long> getLastReadPositions(Stream stream) {
        Object object = this.$lock;
        synchronized (object) {
            HashMap<SegmentWithRange, Long> result = new HashMap<SegmentWithRange, Long>();
            for (Map.Entry<SegmentWithRange, Long> entry : this.lastReadPosition.entrySet()) {
                Segment segment = entry.getKey().getSegment();
                if (!segment.getScope().equals(stream.getScope()) || !segment.getStreamName().equals(stream.getStreamName())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfUnassignedSegments() {
        Object object = this.$lock;
        synchronized (object) {
            return this.unassignedSegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<SegmentWithRange, Long> getUnassignedSegments() {
        Object object = this.$lock;
        synchronized (object) {
            return new HashMap<SegmentWithRange, Long>(this.unassignedSegments);
        }
    }

    Map<Segment, Long> getEndSegments() {
        return this.endSegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReaderOnline(String reader) {
        Object object = this.$lock;
        synchronized (object) {
            return this.assignedSegments.get(reader) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfSegments() {
        Object object = this.$lock;
        synchronized (object) {
            return this.assignedSegments.values().stream().mapToInt(Map::size).sum() + this.unassignedSegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getStreamNames() {
        Object object = this.$lock;
        synchronized (object) {
            HashSet<String> result = new HashSet<String>();
            for (Map<SegmentWithRange, Long> segments : this.assignedSegments.values()) {
                for (SegmentWithRange segment : segments.keySet()) {
                    result.add(segment.getSegment().getScopedStreamName());
                }
            }
            for (SegmentWithRange segment : this.unassignedSegments.keySet()) {
                result.add(segment.getSegment().getScopedStreamName());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getCheckpointForReader(String readerName) {
        Object object = this.$lock;
        synchronized (object) {
            return this.checkpointState.getCheckpointForReader(readerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckpointComplete(String checkpointId) {
        Object object = this.$lock;
        synchronized (object) {
            return this.checkpointState.isCheckpointComplete(checkpointId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Segment, Long> getPositionsForCompletedCheckpoint(String checkpointId) {
        Object object = this.$lock;
        synchronized (object) {
            return this.checkpointState.getPositionsForCompletedCheckpoint(checkpointId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Map<Stream, StreamCut>> getStreamCutsForCompletedCheckpoint(String checkpointId) {
        Object object = this.$lock;
        synchronized (object) {
            Optional<Map<Segment, Long>> positionMap = Optional.ofNullable(this.checkpointState.getPositionsForCompletedCheckpoint(checkpointId));
            return positionMap.map(map -> map.entrySet().stream().collect(Collectors.groupingBy(o -> ((Segment)o.getKey()).getStream(), Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue), x -> new StreamCutImpl(((Segment)x.keySet().stream().findAny().get()).getStream(), (Map<Segment, Long>)x)))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<Map<Stream, Map<Segment, Long>>> getPositionsForLastCompletedCheckpoint() {
        Object object = this.$lock;
        synchronized (object) {
            Optional<Map<Segment, Long>> positions = this.checkpointState.getPositionsForLatestCompletedCheckpoint();
            if (positions.isPresent()) {
                HashMap<Stream, Map> result = new HashMap<Stream, Map>();
                for (Map.Entry<Segment, Long> entry : positions.get().entrySet()) {
                    result.computeIfAbsent(entry.getKey().getStream(), s -> new HashMap()).put(entry.getKey(), entry.getValue());
                }
                return Optional.of(result);
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasOngoingCheckpoint() {
        Object object = this.$lock;
        synchronized (object) {
            return this.checkpointState.hasOngoingCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEndOfData() {
        Object object = this.$lock;
        synchronized (object) {
            return this.futureSegments.isEmpty() && this.unassignedSegments.isEmpty() && this.assignedSegments.values().stream().allMatch(Map::isEmpty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.$lock;
        synchronized (object) {
            StringBuffer sb = new StringBuffer("ReaderGroupState{ ");
            sb.append(this.checkpointState.toString());
            sb.append(" futureSegments: ");
            sb.append(this.futureSegments);
            sb.append(" assignedSegments: ");
            sb.append(this.assignedSegments);
            sb.append(" unassignedSegments: ");
            sb.append(this.unassignedSegments);
            sb.append(" }");
            return sb.toString();
        }
    }

    private static void writeRange(RevisionDataOutput out, SegmentWithRange.Range range) throws IOException {
        double high;
        double low;
        if (range == null) {
            low = -1.0;
            high = -1.0;
        } else {
            low = range.getLow();
            high = range.getHigh();
        }
        out.writeDouble(low);
        out.writeDouble(high);
    }

    private static SegmentWithRange.Range readRange(RevisionDataInput in) throws IOException {
        double low = in.readDouble();
        double high = in.readDouble();
        return low < 0.0 || high < 0.0 ? null : new SegmentWithRange.Range(low, high);
    }

    @ConstructorProperties(value={"scopedSynchronizerStream", "config", "revision", "checkpointState", "distanceToTail", "futureSegments", "assignedSegments", "unassignedSegments", "lastReadPosition", "endSegments"})
    @SuppressFBWarnings(justification="generated code")
    private ReaderGroupState(String scopedSynchronizerStream, ReaderGroupConfig config, Revision revision, CheckpointState checkpointState, Map<String, Long> distanceToTail, Map<SegmentWithRange, Set<Long>> futureSegments, Map<String, Map<SegmentWithRange, Long>> assignedSegments, Map<SegmentWithRange, Long> unassignedSegments, Map<SegmentWithRange, Long> lastReadPosition, Map<Segment, Long> endSegments) {
        this.scopedSynchronizerStream = scopedSynchronizerStream;
        this.config = config;
        this.revision = revision;
        this.checkpointState = checkpointState;
        this.distanceToTail = distanceToTail;
        this.futureSegments = futureSegments;
        this.assignedSegments = assignedSegments;
        this.unassignedSegments = unassignedSegments;
        this.lastReadPosition = lastReadPosition;
        this.endSegments = endSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    public ReaderGroupConfig getConfig() {
        return this.config;
    }

    @SuppressFBWarnings(justification="generated code")
    CheckpointState getCheckpointState() {
        return this.checkpointState;
    }

    public static class ReaderGroupUpdateSerializer
    extends VersionedSerializer.MultiType<Update<ReaderGroupState>> {
        protected void declareSerializers(VersionedSerializer.MultiType.Builder b) {
            b.serializer(ReaderGroupStateInit.class, 0, (VersionedSerializer.WithBuilder)new ReaderGroupStateInit.ReaderGroupStateInitSerializer()).serializer(CompactReaderGroupState.class, 1, (VersionedSerializer.WithBuilder)new CompactReaderGroupState.CompactReaderGroupStateSerializer()).serializer(AddReader.class, 2, (VersionedSerializer.WithBuilder)new AddReader.AddReaderSerializer()).serializer(RemoveReader.class, 3, (VersionedSerializer.WithBuilder)new RemoveReader.RemoveReaderSerializer()).serializer(ReleaseSegment.class, 4, (VersionedSerializer.WithBuilder)new ReleaseSegment.ReleaseSegmentSerializer()).serializer(AcquireSegment.class, 5, (VersionedSerializer.WithBuilder)new AcquireSegment.AcquireSegmentSerializer()).serializer(UpdateDistanceToTail.class, 6, (VersionedSerializer.WithBuilder)new UpdateDistanceToTail.UpdateDistanceToTailSerializer()).serializer(SegmentCompleted.class, 7, (VersionedSerializer.WithBuilder)new SegmentCompleted.SegmentCompletedSerializer()).serializer(CheckpointReader.class, 8, (VersionedSerializer.WithBuilder)new CheckpointReader.CheckpointReaderSerializer()).serializer(CreateCheckpoint.class, 9, (VersionedSerializer.WithBuilder)new CreateCheckpoint.CreateCheckpointSerializer()).serializer(ClearCheckpointsBefore.class, 10, (VersionedSerializer.WithBuilder)new ClearCheckpointsBefore.ClearCheckpointsBeforeSerializer());
        }
    }

    public static class ReaderGroupInitSerializer
    extends VersionedSerializer.MultiType<InitialUpdate<ReaderGroupState>> {
        protected void declareSerializers(VersionedSerializer.MultiType.Builder b) {
            b.serializer(ReaderGroupStateInit.class, 0, (VersionedSerializer.WithBuilder)new ReaderGroupStateInit.ReaderGroupStateInitSerializer()).serializer(CompactReaderGroupState.class, 1, (VersionedSerializer.WithBuilder)new CompactReaderGroupState.CompactReaderGroupStateSerializer());
        }
    }

    static class ClearCheckpointsBefore
    extends ReaderGroupStateUpdate {
        private final String clearUpToCheckpoint;

        @Override
        void update(ReaderGroupState state) {
            state.checkpointState.clearCheckpointsBefore(this.clearUpToCheckpoint);
        }

        @ConstructorProperties(value={"clearUpToCheckpoint"})
        @SuppressFBWarnings(justification="generated code")
        ClearCheckpointsBefore(String clearUpToCheckpoint) {
            this.clearUpToCheckpoint = clearUpToCheckpoint;
        }

        @SuppressFBWarnings(justification="generated code")
        public static ClearCheckpointsBeforeBuilder builder() {
            return new ClearCheckpointsBeforeBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getClearUpToCheckpoint() {
            return this.clearUpToCheckpoint;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.ClearCheckpointsBefore(clearUpToCheckpoint=" + this.getClearUpToCheckpoint() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClearCheckpointsBefore)) {
                return false;
            }
            ClearCheckpointsBefore other = (ClearCheckpointsBefore)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$clearUpToCheckpoint = this.getClearUpToCheckpoint();
            String other$clearUpToCheckpoint = other.getClearUpToCheckpoint();
            return !(this$clearUpToCheckpoint == null ? other$clearUpToCheckpoint != null : !this$clearUpToCheckpoint.equals(other$clearUpToCheckpoint));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ClearCheckpointsBefore;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $clearUpToCheckpoint = this.getClearUpToCheckpoint();
            result = result * 59 + ($clearUpToCheckpoint == null ? 43 : $clearUpToCheckpoint.hashCode());
            return result;
        }

        private static class ClearCheckpointsBeforeSerializer
        extends VersionedSerializer.WithBuilder<ClearCheckpointsBefore, ClearCheckpointsBeforeBuilder> {
            private ClearCheckpointsBeforeSerializer() {
            }

            protected ClearCheckpointsBeforeBuilder newBuilder() {
                return ClearCheckpointsBefore.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, ClearCheckpointsBeforeBuilder builder) throws IOException {
                builder.clearUpToCheckpoint(in.readUTF());
            }

            private void write00(ClearCheckpointsBefore object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.clearUpToCheckpoint);
            }
        }

        private static class ClearCheckpointsBeforeBuilder
        implements ObjectBuilder<ClearCheckpointsBefore> {
            @SuppressFBWarnings(justification="generated code")
            private String clearUpToCheckpoint;

            @SuppressFBWarnings(justification="generated code")
            ClearCheckpointsBeforeBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public ClearCheckpointsBeforeBuilder clearUpToCheckpoint(String clearUpToCheckpoint) {
                this.clearUpToCheckpoint = clearUpToCheckpoint;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ClearCheckpointsBefore build() {
                return new ClearCheckpointsBefore(this.clearUpToCheckpoint);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.ClearCheckpointsBefore.ClearCheckpointsBeforeBuilder(clearUpToCheckpoint=" + this.clearUpToCheckpoint + ")";
            }
        }
    }

    static class CreateCheckpoint
    extends ReaderGroupStateUpdate {
        private final String checkpointId;

        CreateCheckpoint() {
            this(UUID.randomUUID().toString());
        }

        @Override
        void update(ReaderGroupState state) {
            Map<Segment, Long> unassignedSegments = state.getUnassignedSegments().entrySet().stream().collect(Collectors.toMap(e -> ((SegmentWithRange)e.getKey()).getSegment(), e -> (Long)e.getValue()));
            state.checkpointState.beginNewCheckpoint(this.checkpointId, state.getOnlineReaders(), unassignedSegments);
        }

        @SuppressFBWarnings(justification="generated code")
        public static CreateCheckpointBuilder builder() {
            return new CreateCheckpointBuilder();
        }

        @ConstructorProperties(value={"checkpointId"})
        @SuppressFBWarnings(justification="generated code")
        public CreateCheckpoint(String checkpointId) {
            this.checkpointId = checkpointId;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateCheckpoint)) {
                return false;
            }
            CreateCheckpoint other = (CreateCheckpoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$checkpointId = this.getCheckpointId();
            String other$checkpointId = other.getCheckpointId();
            return !(this$checkpointId == null ? other$checkpointId != null : !this$checkpointId.equals(other$checkpointId));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof CreateCheckpoint;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $checkpointId = this.getCheckpointId();
            result = result * 59 + ($checkpointId == null ? 43 : $checkpointId.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getCheckpointId() {
            return this.checkpointId;
        }

        private static class CreateCheckpointSerializer
        extends VersionedSerializer.WithBuilder<CreateCheckpoint, CreateCheckpointBuilder> {
            private CreateCheckpointSerializer() {
            }

            protected CreateCheckpointBuilder newBuilder() {
                return CreateCheckpoint.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, CreateCheckpointBuilder builder) throws IOException {
                builder.checkpointId(in.readUTF());
            }

            private void write00(CreateCheckpoint object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.checkpointId);
            }
        }

        private static class CreateCheckpointBuilder
        implements ObjectBuilder<CreateCheckpoint> {
            @SuppressFBWarnings(justification="generated code")
            private String checkpointId;

            @SuppressFBWarnings(justification="generated code")
            CreateCheckpointBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public CreateCheckpointBuilder checkpointId(String checkpointId) {
                this.checkpointId = checkpointId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CreateCheckpoint build() {
                return new CreateCheckpoint(this.checkpointId);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.CreateCheckpoint.CreateCheckpointBuilder(checkpointId=" + this.checkpointId + ")";
            }
        }
    }

    static class CheckpointReader
    extends ReaderGroupStateUpdate {
        private final String checkpointId;
        private final String readerId;
        private final Map<Segment, Long> positions;

        @Override
        void update(ReaderGroupState state) {
            state.checkpointState.readerCheckpointed(this.checkpointId, this.readerId, this.positions);
            if (!state.checkpointState.isCheckpointSilent(this.checkpointId)) {
                Map readerPositions = (Map)state.assignedSegments.get(this.readerId);
                for (Map.Entry entry : readerPositions.entrySet()) {
                    Long offset = this.positions.get(((SegmentWithRange)entry.getKey()).getSegment());
                    if (offset == null) continue;
                    entry.setValue(offset);
                }
            }
        }

        @ConstructorProperties(value={"checkpointId", "readerId", "positions"})
        @SuppressFBWarnings(justification="generated code")
        CheckpointReader(String checkpointId, String readerId, Map<Segment, Long> positions) {
            this.checkpointId = checkpointId;
            this.readerId = readerId;
            this.positions = positions;
        }

        @SuppressFBWarnings(justification="generated code")
        public static CheckpointReaderBuilder builder() {
            return new CheckpointReaderBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getCheckpointId() {
            return this.checkpointId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<Segment, Long> getPositions() {
            return this.positions;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.CheckpointReader(checkpointId=" + this.getCheckpointId() + ", readerId=" + this.getReaderId() + ", positions=" + this.getPositions() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CheckpointReader)) {
                return false;
            }
            CheckpointReader other = (CheckpointReader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$checkpointId = this.getCheckpointId();
            String other$checkpointId = other.getCheckpointId();
            if (this$checkpointId == null ? other$checkpointId != null : !this$checkpointId.equals(other$checkpointId)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            Map<Segment, Long> this$positions = this.getPositions();
            Map<Segment, Long> other$positions = other.getPositions();
            return !(this$positions == null ? other$positions != null : !((Object)this$positions).equals(other$positions));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof CheckpointReader;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $checkpointId = this.getCheckpointId();
            result = result * 59 + ($checkpointId == null ? 43 : $checkpointId.hashCode());
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            Map<Segment, Long> $positions = this.getPositions();
            result = result * 59 + ($positions == null ? 43 : ((Object)$positions).hashCode());
            return result;
        }

        private static class CheckpointReaderSerializer
        extends VersionedSerializer.WithBuilder<CheckpointReader, CheckpointReaderBuilder> {
            private CheckpointReaderSerializer() {
            }

            protected CheckpointReaderBuilder newBuilder() {
                return CheckpointReader.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, CheckpointReaderBuilder builder) throws IOException {
                builder.checkpointId(in.readUTF());
                builder.readerId(in.readUTF());
                builder.positions(in.readMap(i -> Segment.fromScopedName(i.readUTF()), DataInput::readLong));
            }

            private void write00(CheckpointReader object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.checkpointId);
                out.writeUTF(object.readerId);
                out.writeMap(object.positions, (o, segment) -> o.writeUTF(segment.getScopedName()), DataOutput::writeLong);
            }
        }

        private static class CheckpointReaderBuilder
        implements ObjectBuilder<CheckpointReader> {
            @SuppressFBWarnings(justification="generated code")
            private String checkpointId;
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private Map<Segment, Long> positions;

            @SuppressFBWarnings(justification="generated code")
            CheckpointReaderBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public CheckpointReaderBuilder checkpointId(String checkpointId) {
                this.checkpointId = checkpointId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CheckpointReaderBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CheckpointReaderBuilder positions(Map<Segment, Long> positions) {
                this.positions = positions;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CheckpointReader build() {
                return new CheckpointReader(this.checkpointId, this.readerId, this.positions);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.CheckpointReader.CheckpointReaderBuilder(checkpointId=" + this.checkpointId + ", readerId=" + this.readerId + ", positions=" + this.positions + ")";
            }
        }
    }

    static class SegmentCompleted
    extends ReaderGroupStateUpdate {
        private final String readerId;
        private final SegmentWithRange segmentCompleted;
        private final Map<SegmentWithRange, List<Long>> successorsMappedToTheirPredecessors;

        @Override
        void update(ReaderGroupState state) {
            Map assigned = (Map)state.assignedSegments.get(this.readerId);
            Preconditions.checkState((assigned != null ? 1 : 0) != 0, (String)"%s is not part of the readerGroup", (Object)this.readerId);
            if (assigned.remove(this.segmentCompleted) == null) {
                throw new IllegalStateException(this.readerId + " asked to complete a segment that was not assigned to it " + this.segmentCompleted);
            }
            state.lastReadPosition.remove(this.segmentCompleted);
            for (Map.Entry<SegmentWithRange, List<Long>> entry : this.successorsMappedToTheirPredecessors.entrySet()) {
                if (state.futureSegments.containsKey(entry.getKey())) continue;
                HashSet requiredToComplete = new HashSet(entry.getValue());
                state.futureSegments.put(entry.getKey(), requiredToComplete);
            }
            for (Set requiredToComplete : state.futureSegments.values()) {
                requiredToComplete.remove(this.segmentCompleted.getSegment().getSegmentId());
            }
            Iterator iter = state.futureSegments.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<SegmentWithRange, List<Long>> entry;
                entry = iter.next();
                if (!((Set)((Object)entry.getValue())).isEmpty()) continue;
                state.unassignedSegments.put(entry.getKey(), 0L);
                state.lastReadPosition.putIfAbsent(entry.getKey(), 0L);
                iter.remove();
            }
        }

        @ConstructorProperties(value={"readerId", "segmentCompleted", "successorsMappedToTheirPredecessors"})
        @SuppressFBWarnings(justification="generated code")
        SegmentCompleted(String readerId, SegmentWithRange segmentCompleted, Map<SegmentWithRange, List<Long>> successorsMappedToTheirPredecessors) {
            this.readerId = readerId;
            this.segmentCompleted = segmentCompleted;
            this.successorsMappedToTheirPredecessors = successorsMappedToTheirPredecessors;
        }

        @SuppressFBWarnings(justification="generated code")
        public static SegmentCompletedBuilder builder() {
            return new SegmentCompletedBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public SegmentWithRange getSegmentCompleted() {
            return this.segmentCompleted;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, List<Long>> getSuccessorsMappedToTheirPredecessors() {
            return this.successorsMappedToTheirPredecessors;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.SegmentCompleted(readerId=" + this.getReaderId() + ", segmentCompleted=" + this.getSegmentCompleted() + ", successorsMappedToTheirPredecessors=" + this.getSuccessorsMappedToTheirPredecessors() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SegmentCompleted)) {
                return false;
            }
            SegmentCompleted other = (SegmentCompleted)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            SegmentWithRange this$segmentCompleted = this.getSegmentCompleted();
            SegmentWithRange other$segmentCompleted = other.getSegmentCompleted();
            if (this$segmentCompleted == null ? other$segmentCompleted != null : !((Object)this$segmentCompleted).equals(other$segmentCompleted)) {
                return false;
            }
            Map<SegmentWithRange, List<Long>> this$successorsMappedToTheirPredecessors = this.getSuccessorsMappedToTheirPredecessors();
            Map<SegmentWithRange, List<Long>> other$successorsMappedToTheirPredecessors = other.getSuccessorsMappedToTheirPredecessors();
            return !(this$successorsMappedToTheirPredecessors == null ? other$successorsMappedToTheirPredecessors != null : !((Object)this$successorsMappedToTheirPredecessors).equals(other$successorsMappedToTheirPredecessors));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof SegmentCompleted;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            SegmentWithRange $segmentCompleted = this.getSegmentCompleted();
            result = result * 59 + ($segmentCompleted == null ? 43 : ((Object)$segmentCompleted).hashCode());
            Map<SegmentWithRange, List<Long>> $successorsMappedToTheirPredecessors = this.getSuccessorsMappedToTheirPredecessors();
            result = result * 59 + ($successorsMappedToTheirPredecessors == null ? 43 : ((Object)$successorsMappedToTheirPredecessors).hashCode());
            return result;
        }

        private static class SegmentCompletedSerializer
        extends VersionedSerializer.WithBuilder<SegmentCompleted, SegmentCompletedBuilder> {
            private SegmentCompletedSerializer() {
            }

            protected SegmentCompletedBuilder newBuilder() {
                return SegmentCompleted.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
            }

            private void read00(RevisionDataInput in, SegmentCompletedBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
                builder.segmentCompleted(new SegmentWithRange(Segment.fromScopedName(in.readUTF()), null));
                builder.successorsMappedToTheirPredecessors(in.readMap(i -> new SegmentWithRange(Segment.fromScopedName(i.readUTF()), null), i -> (ArrayList)i.readCollection(DataInput::readLong, ArrayList::new)));
            }

            private void read01(RevisionDataInput revisionDataInput, SegmentCompletedBuilder builder) throws IOException {
                RevisionDataInput.ElementDeserializer segmentDeserializer = in -> Segment.fromScopedName(in.readUTF());
                Map ranges = revisionDataInput.readMap(segmentDeserializer, x$0 -> ReaderGroupState.readRange(x$0));
                builder.segmentCompleted(new SegmentWithRange(builder.segmentCompleted.getSegment(), (SegmentWithRange.Range)ranges.get(builder.segmentCompleted.getSegment())));
                HashMap<SegmentWithRange, List<Long>> successorsMappedToTheirPredecessors = new HashMap<SegmentWithRange, List<Long>>();
                for (Map.Entry entry : builder.successorsMappedToTheirPredecessors.entrySet()) {
                    Segment segment = ((SegmentWithRange)entry.getKey()).getSegment();
                    successorsMappedToTheirPredecessors.put(new SegmentWithRange(segment, (SegmentWithRange.Range)ranges.get(segment)), (List<Long>)entry.getValue());
                }
                builder.successorsMappedToTheirPredecessors(successorsMappedToTheirPredecessors);
            }

            private void write00(SegmentCompleted object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
                out.writeUTF(object.segmentCompleted.getSegment().getScopedName());
                out.writeMap(object.successorsMappedToTheirPredecessors, (o, segment) -> o.writeUTF(segment.getSegment().getScopedName()), (o, predecessors) -> o.writeCollection((Collection)predecessors, DataOutput::writeLong));
            }

            private void write01(SegmentCompleted object, RevisionDataOutput out) throws IOException {
                HashMap<Segment, SegmentWithRange.Range> rangeMap = new HashMap<Segment, SegmentWithRange.Range>();
                rangeMap.put(object.segmentCompleted.getSegment(), object.segmentCompleted.getRange());
                for (SegmentWithRange segment2 : object.successorsMappedToTheirPredecessors.keySet()) {
                    rangeMap.put(segment2.getSegment(), segment2.getRange());
                }
                out.writeMap(rangeMap, (o, segment) -> o.writeUTF(segment.getScopedName()), (x$0, x$1) -> ReaderGroupState.writeRange(x$0, x$1));
            }
        }

        private static class SegmentCompletedBuilder
        implements ObjectBuilder<SegmentCompleted> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private SegmentWithRange segmentCompleted;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, List<Long>> successorsMappedToTheirPredecessors;

            @SuppressFBWarnings(justification="generated code")
            SegmentCompletedBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentCompletedBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentCompletedBuilder segmentCompleted(SegmentWithRange segmentCompleted) {
                this.segmentCompleted = segmentCompleted;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentCompletedBuilder successorsMappedToTheirPredecessors(Map<SegmentWithRange, List<Long>> successorsMappedToTheirPredecessors) {
                this.successorsMappedToTheirPredecessors = successorsMappedToTheirPredecessors;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public SegmentCompleted build() {
                return new SegmentCompleted(this.readerId, this.segmentCompleted, this.successorsMappedToTheirPredecessors);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.SegmentCompleted.SegmentCompletedBuilder(readerId=" + this.readerId + ", segmentCompleted=" + this.segmentCompleted + ", successorsMappedToTheirPredecessors=" + this.successorsMappedToTheirPredecessors + ")";
            }
        }
    }

    static class UpdateDistanceToTail
    extends ReaderGroupStateUpdate {
        private final String readerId;
        private final long distanceToTail;
        private final Map<SegmentWithRange, Long> lastReadPositions;

        @Override
        void update(ReaderGroupState state) {
            state.distanceToTail.put(this.readerId, Math.max(30000L, this.distanceToTail));
            if (this.lastReadPositions != null) {
                for (Map.Entry<SegmentWithRange, Long> entry : this.lastReadPositions.entrySet()) {
                    state.lastReadPosition.replace(entry.getKey(), entry.getValue());
                }
            }
        }

        @ConstructorProperties(value={"readerId", "distanceToTail", "lastReadPositions"})
        @SuppressFBWarnings(justification="generated code")
        UpdateDistanceToTail(String readerId, long distanceToTail, Map<SegmentWithRange, Long> lastReadPositions) {
            this.readerId = readerId;
            this.distanceToTail = distanceToTail;
            this.lastReadPositions = lastReadPositions;
        }

        @SuppressFBWarnings(justification="generated code")
        public static UpdateDistanceToTailBuilder builder() {
            return new UpdateDistanceToTailBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getDistanceToTail() {
            return this.distanceToTail;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, Long> getLastReadPositions() {
            return this.lastReadPositions;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.UpdateDistanceToTail(readerId=" + this.getReaderId() + ", distanceToTail=" + this.getDistanceToTail() + ", lastReadPositions=" + this.getLastReadPositions() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateDistanceToTail)) {
                return false;
            }
            UpdateDistanceToTail other = (UpdateDistanceToTail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            if (this.getDistanceToTail() != other.getDistanceToTail()) {
                return false;
            }
            Map<SegmentWithRange, Long> this$lastReadPositions = this.getLastReadPositions();
            Map<SegmentWithRange, Long> other$lastReadPositions = other.getLastReadPositions();
            return !(this$lastReadPositions == null ? other$lastReadPositions != null : !((Object)this$lastReadPositions).equals(other$lastReadPositions));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof UpdateDistanceToTail;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            long $distanceToTail = this.getDistanceToTail();
            result = result * 59 + (int)($distanceToTail >>> 32 ^ $distanceToTail);
            Map<SegmentWithRange, Long> $lastReadPositions = this.getLastReadPositions();
            result = result * 59 + ($lastReadPositions == null ? 43 : ((Object)$lastReadPositions).hashCode());
            return result;
        }

        @VisibleForTesting
        static class UpdateDistanceToTailSerializer
        extends VersionedSerializer.WithBuilder<UpdateDistanceToTail, UpdateDistanceToTailBuilder> {
            UpdateDistanceToTailSerializer() {
            }

            protected UpdateDistanceToTailBuilder newBuilder() {
                return UpdateDistanceToTail.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
            }

            @VisibleForTesting
            void read00(RevisionDataInput in, UpdateDistanceToTailBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
                builder.distanceToTail(in.readLong());
            }

            private void read01(RevisionDataInput revisionDataInput, UpdateDistanceToTailBuilder builder) throws IOException {
                Map positions = revisionDataInput.readMap(in -> new SegmentWithRange(Segment.fromScopedName(in.readUTF()), ReaderGroupState.readRange(in)), DataInput::readLong);
                builder.lastReadPositions(positions);
            }

            @VisibleForTesting
            void write00(UpdateDistanceToTail object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
                out.writeLong(object.distanceToTail);
            }

            private void write01(UpdateDistanceToTail object, RevisionDataOutput revisionDataOutput) throws IOException {
                RevisionDataOutput.ElementSerializer segmentWithRangeSerializer = (out, s) -> {
                    out.writeUTF(s.getSegment().getScopedName());
                    ReaderGroupState.writeRange(out, s.getRange());
                };
                revisionDataOutput.writeMap(object.lastReadPositions, segmentWithRangeSerializer, DataOutput::writeLong);
            }
        }

        @VisibleForTesting
        static class UpdateDistanceToTailBuilder
        implements ObjectBuilder<UpdateDistanceToTail> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private long distanceToTail;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, Long> lastReadPositions;

            @SuppressFBWarnings(justification="generated code")
            UpdateDistanceToTailBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public UpdateDistanceToTailBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public UpdateDistanceToTailBuilder distanceToTail(long distanceToTail) {
                this.distanceToTail = distanceToTail;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public UpdateDistanceToTailBuilder lastReadPositions(Map<SegmentWithRange, Long> lastReadPositions) {
                this.lastReadPositions = lastReadPositions;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public UpdateDistanceToTail build() {
                return new UpdateDistanceToTail(this.readerId, this.distanceToTail, this.lastReadPositions);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.UpdateDistanceToTail.UpdateDistanceToTailBuilder(readerId=" + this.readerId + ", distanceToTail=" + this.distanceToTail + ", lastReadPositions=" + this.lastReadPositions + ")";
            }
        }
    }

    static class AcquireSegment
    extends ReaderGroupStateUpdate {
        private final String readerId;
        private final Segment segment;

        @Override
        void update(ReaderGroupState state) {
            Map assigned = (Map)state.assignedSegments.get(this.readerId);
            Preconditions.checkState((assigned != null ? 1 : 0) != 0, (String)"%s is not part of the readerGroup", (Object)this.readerId);
            SegmentWithRange aquired = null;
            for (SegmentWithRange segmentWithRange : state.unassignedSegments.keySet()) {
                if (!segmentWithRange.getSegment().equals(this.segment)) continue;
                aquired = segmentWithRange;
            }
            if (aquired == null) {
                throw new IllegalStateException("Segment: " + this.segment + " is not unassigned. " + state);
            }
            Long offset = (Long)state.unassignedSegments.remove(aquired);
            assigned.put(aquired, offset);
        }

        @ConstructorProperties(value={"readerId", "segment"})
        @SuppressFBWarnings(justification="generated code")
        AcquireSegment(String readerId, Segment segment) {
            this.readerId = readerId;
            this.segment = segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public static AcquireSegmentBuilder builder() {
            return new AcquireSegmentBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public Segment getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.AcquireSegment(readerId=" + this.getReaderId() + ", segment=" + this.getSegment() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcquireSegment)) {
                return false;
            }
            AcquireSegment other = (AcquireSegment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            Segment this$segment = this.getSegment();
            Segment other$segment = other.getSegment();
            return !(this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof AcquireSegment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            Segment $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
            return result;
        }

        private static class AcquireSegmentSerializer
        extends VersionedSerializer.WithBuilder<AcquireSegment, AcquireSegmentBuilder> {
            private AcquireSegmentSerializer() {
            }

            protected AcquireSegmentBuilder newBuilder() {
                return AcquireSegment.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, AcquireSegmentBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
                builder.segment(Segment.fromScopedName(in.readUTF()));
            }

            private void write00(AcquireSegment object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
                out.writeUTF(object.segment.getScopedName());
            }
        }

        private static class AcquireSegmentBuilder
        implements ObjectBuilder<AcquireSegment> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private Segment segment;

            @SuppressFBWarnings(justification="generated code")
            AcquireSegmentBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public AcquireSegmentBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public AcquireSegmentBuilder segment(Segment segment) {
                this.segment = segment;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public AcquireSegment build() {
                return new AcquireSegment(this.readerId, this.segment);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.AcquireSegment.AcquireSegmentBuilder(readerId=" + this.readerId + ", segment=" + this.segment + ")";
            }
        }
    }

    static class ReleaseSegment
    extends ReaderGroupStateUpdate {
        private final String readerId;
        private final Segment segment;
        private final long offset;

        @Override
        void update(ReaderGroupState state) {
            Map assigned = (Map)state.assignedSegments.get(this.readerId);
            Preconditions.checkState((assigned != null ? 1 : 0) != 0, (String)"%s is not part of the readerGroup", (Object)this.readerId);
            SegmentWithRange segmentWithRange = this.removeSegmentFromAssigned(assigned);
            state.unassignedSegments.put(segmentWithRange, this.offset);
            state.lastReadPosition.replace(segmentWithRange, this.offset);
        }

        private SegmentWithRange removeSegmentFromAssigned(Map<SegmentWithRange, Long> assigned) {
            SegmentWithRange result = null;
            Iterator<SegmentWithRange> iterator = assigned.keySet().iterator();
            while (iterator.hasNext()) {
                SegmentWithRange key = iterator.next();
                if (!key.getSegment().equals(this.segment)) continue;
                iterator.remove();
                result = key;
            }
            if (result == null) {
                throw new IllegalStateException(this.readerId + " asked to release a segment that was not assigned to it " + this.segment);
            }
            return result;
        }

        @ConstructorProperties(value={"readerId", "segment", "offset"})
        @SuppressFBWarnings(justification="generated code")
        ReleaseSegment(String readerId, Segment segment, long offset) {
            this.readerId = readerId;
            this.segment = segment;
            this.offset = offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public static ReleaseSegmentBuilder builder() {
            return new ReleaseSegmentBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public Segment getSegment() {
            return this.segment;
        }

        @SuppressFBWarnings(justification="generated code")
        public long getOffset() {
            return this.offset;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.ReleaseSegment(readerId=" + this.getReaderId() + ", segment=" + this.getSegment() + ", offset=" + this.getOffset() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReleaseSegment)) {
                return false;
            }
            ReleaseSegment other = (ReleaseSegment)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            Segment this$segment = this.getSegment();
            Segment other$segment = other.getSegment();
            if (this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment)) {
                return false;
            }
            return this.getOffset() == other.getOffset();
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ReleaseSegment;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            Segment $segment = this.getSegment();
            result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
            long $offset = this.getOffset();
            result = result * 59 + (int)($offset >>> 32 ^ $offset);
            return result;
        }

        private static class ReleaseSegmentSerializer
        extends VersionedSerializer.WithBuilder<ReleaseSegment, ReleaseSegmentBuilder> {
            private ReleaseSegmentSerializer() {
            }

            protected ReleaseSegmentBuilder newBuilder() {
                return ReleaseSegment.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, ReleaseSegmentBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
                builder.segment(Segment.fromScopedName(in.readUTF()));
                builder.offset(in.readLong());
            }

            private void write00(ReleaseSegment object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
                out.writeUTF(object.segment.getScopedName());
                out.writeLong(object.offset);
            }
        }

        private static class ReleaseSegmentBuilder
        implements ObjectBuilder<ReleaseSegment> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private Segment segment;
            @SuppressFBWarnings(justification="generated code")
            private long offset;

            @SuppressFBWarnings(justification="generated code")
            ReleaseSegmentBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public ReleaseSegmentBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReleaseSegmentBuilder segment(Segment segment) {
                this.segment = segment;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReleaseSegmentBuilder offset(long offset) {
                this.offset = offset;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReleaseSegment build() {
                return new ReleaseSegment(this.readerId, this.segment, this.offset);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.ReleaseSegment.ReleaseSegmentBuilder(readerId=" + this.readerId + ", segment=" + this.segment + ", offset=" + this.offset + ")";
            }
        }
    }

    static class RemoveReader
    extends ReaderGroupStateUpdate {
        private final String readerId;
        private final Map<Segment, Long> ownedSegments;

        @Override
        void update(ReaderGroupState state) {
            Map assignedSegments = (Map)state.assignedSegments.remove(this.readerId);
            HashMap<Segment, Long> finalPositions = new HashMap<Segment, Long>();
            if (assignedSegments != null) {
                Iterator iter = assignedSegments.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    SegmentWithRange segment = (SegmentWithRange)entry.getKey();
                    Long offset = this.ownedSegments.get(segment.getSegment());
                    if (offset == null) {
                        offset = (Long)entry.getValue();
                    }
                    finalPositions.put(segment.getSegment(), offset);
                    state.unassignedSegments.put(segment, offset);
                    iter.remove();
                }
            }
            state.distanceToTail.remove(this.readerId);
            state.checkpointState.removeReader(this.readerId, finalPositions);
        }

        @ConstructorProperties(value={"readerId", "ownedSegments"})
        @SuppressFBWarnings(justification="generated code")
        RemoveReader(String readerId, Map<Segment, Long> ownedSegments) {
            this.readerId = readerId;
            this.ownedSegments = ownedSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public static RemoveReaderBuilder builder() {
            return new RemoveReaderBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<Segment, Long> getOwnedSegments() {
            return this.ownedSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.RemoveReader(readerId=" + this.getReaderId() + ", ownedSegments=" + this.getOwnedSegments() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RemoveReader)) {
                return false;
            }
            RemoveReader other = (RemoveReader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            if (this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId)) {
                return false;
            }
            Map<Segment, Long> this$ownedSegments = this.getOwnedSegments();
            Map<Segment, Long> other$ownedSegments = other.getOwnedSegments();
            return !(this$ownedSegments == null ? other$ownedSegments != null : !((Object)this$ownedSegments).equals(other$ownedSegments));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof RemoveReader;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            Map<Segment, Long> $ownedSegments = this.getOwnedSegments();
            result = result * 59 + ($ownedSegments == null ? 43 : ((Object)$ownedSegments).hashCode());
            return result;
        }

        private static class RemoveReaderSerializer
        extends VersionedSerializer.WithBuilder<RemoveReader, RemoveReaderBuilder> {
            private RemoveReaderSerializer() {
            }

            protected RemoveReaderBuilder newBuilder() {
                return RemoveReader.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, RemoveReaderBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
                builder.ownedSegments(in.readMap(i -> Segment.fromScopedName(i.readUTF()), DataInput::readLong));
            }

            private void write00(RemoveReader object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
                out.writeMap(object.ownedSegments, (o, segment) -> o.writeUTF(segment.getScopedName()), DataOutput::writeLong);
            }
        }

        private static class RemoveReaderBuilder
        implements ObjectBuilder<RemoveReader> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;
            @SuppressFBWarnings(justification="generated code")
            private Map<Segment, Long> ownedSegments;

            @SuppressFBWarnings(justification="generated code")
            RemoveReaderBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public RemoveReaderBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public RemoveReaderBuilder ownedSegments(Map<Segment, Long> ownedSegments) {
                this.ownedSegments = ownedSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public RemoveReader build() {
                return new RemoveReader(this.readerId, this.ownedSegments);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.RemoveReader.RemoveReaderBuilder(readerId=" + this.readerId + ", ownedSegments=" + this.ownedSegments + ")";
            }
        }
    }

    static class AddReader
    extends ReaderGroupStateUpdate {
        private final String readerId;

        @Override
        void update(ReaderGroupState state) {
            Map oldPos = state.assignedSegments.putIfAbsent(this.readerId, new HashMap());
            if (oldPos != null) {
                throw new IllegalStateException("Attempted to add a reader that is already online: " + this.readerId);
            }
            state.distanceToTail.putIfAbsent(this.readerId, Long.MAX_VALUE);
        }

        @ConstructorProperties(value={"readerId"})
        @SuppressFBWarnings(justification="generated code")
        AddReader(String readerId) {
            this.readerId = readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public static AddReaderBuilder builder() {
            return new AddReaderBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public String getReaderId() {
            return this.readerId;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.AddReader(readerId=" + this.getReaderId() + ")";
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddReader)) {
                return false;
            }
            AddReader other = (AddReader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$readerId = this.getReaderId();
            String other$readerId = other.getReaderId();
            return !(this$readerId == null ? other$readerId != null : !this$readerId.equals(other$readerId));
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof AddReader;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $readerId = this.getReaderId();
            result = result * 59 + ($readerId == null ? 43 : $readerId.hashCode());
            return result;
        }

        private static class AddReaderSerializer
        extends VersionedSerializer.WithBuilder<AddReader, AddReaderBuilder> {
            private AddReaderSerializer() {
            }

            protected AddReaderBuilder newBuilder() {
                return AddReader.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00);
            }

            private void read00(RevisionDataInput in, AddReaderBuilder builder) throws IOException {
                builder.readerId(in.readUTF());
            }

            private void write00(AddReader object, RevisionDataOutput out) throws IOException {
                out.writeUTF(object.readerId);
            }
        }

        private static class AddReaderBuilder
        implements ObjectBuilder<AddReader> {
            @SuppressFBWarnings(justification="generated code")
            private String readerId;

            @SuppressFBWarnings(justification="generated code")
            AddReaderBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public AddReaderBuilder readerId(String readerId) {
                this.readerId = readerId;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public AddReader build() {
                return new AddReader(this.readerId);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.AddReader.AddReaderBuilder(readerId=" + this.readerId + ")";
            }
        }
    }

    static abstract class ReaderGroupStateUpdate
    implements Update<ReaderGroupState> {
        ReaderGroupStateUpdate() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ReaderGroupState applyTo(ReaderGroupState oldState, Revision newRevision) {
            Object object = oldState.$lock;
            synchronized (object) {
                this.update(oldState);
                oldState.revision = newRevision;
            }
            return oldState;
        }

        abstract void update(ReaderGroupState var1);

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReaderGroupStateUpdate)) {
                return false;
            }
            ReaderGroupStateUpdate other = (ReaderGroupStateUpdate)o;
            return other.canEqual(this);
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ReaderGroupStateUpdate;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int result = 1;
            return result;
        }
    }

    static class CompactReaderGroupState
    implements InitialUpdate<ReaderGroupState> {
        @NonNull
        private final ReaderGroupConfig config;
        @NonNull
        private final CheckpointState checkpointState;
        @NonNull
        private final Map<String, Long> distanceToTail;
        @NonNull
        private final Map<SegmentWithRange, Set<Long>> futureSegments;
        @NonNull
        private final Map<String, Map<SegmentWithRange, Long>> assignedSegments;
        private final Map<SegmentWithRange, Long> unassignedSegments;
        @NonNull
        private final Map<SegmentWithRange, Long> lastReadPosition;
        @NonNull
        private final Map<Segment, Long> endSegments;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CompactReaderGroupState(ReaderGroupState state) {
            Object object = state.$lock;
            synchronized (object) {
                this.config = state.config;
                this.checkpointState = state.checkpointState.copy();
                this.distanceToTail = new HashMap<String, Long>(state.distanceToTail);
                this.futureSegments = new HashMap<SegmentWithRange, Set<Long>>();
                for (Map.Entry entry : state.futureSegments.entrySet()) {
                    this.futureSegments.put((SegmentWithRange)entry.getKey(), new HashSet((Collection)entry.getValue()));
                }
                this.assignedSegments = new HashMap<String, Map<SegmentWithRange, Long>>();
                for (Map.Entry entry : state.assignedSegments.entrySet()) {
                    this.assignedSegments.put((String)entry.getKey(), new HashMap((Map)entry.getValue()));
                }
                this.unassignedSegments = new LinkedHashMap<SegmentWithRange, Long>(state.unassignedSegments);
                this.lastReadPosition = new HashMap<SegmentWithRange, Long>(state.lastReadPosition);
                this.endSegments = state.endSegments;
            }
        }

        @Override
        public ReaderGroupState create(String scopedStreamName, Revision revision) {
            return new ReaderGroupState(scopedStreamName, this.config, revision, this.checkpointState, this.distanceToTail, this.futureSegments, this.assignedSegments, this.unassignedSegments, this.lastReadPosition, this.endSegments);
        }

        @SuppressFBWarnings(justification="generated code")
        public static CompactReaderGroupStateBuilder builder() {
            return new CompactReaderGroupStateBuilder();
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public ReaderGroupConfig getConfig() {
            return this.config;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public CheckpointState getCheckpointState() {
            return this.checkpointState;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Map<String, Long> getDistanceToTail() {
            return this.distanceToTail;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, Set<Long>> getFutureSegments() {
            return this.futureSegments;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Map<String, Map<SegmentWithRange, Long>> getAssignedSegments() {
            return this.assignedSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, Long> getUnassignedSegments() {
            return this.unassignedSegments;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, Long> getLastReadPosition() {
            return this.lastReadPosition;
        }

        @NonNull
        @SuppressFBWarnings(justification="generated code")
        public Map<Segment, Long> getEndSegments() {
            return this.endSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CompactReaderGroupState)) {
                return false;
            }
            CompactReaderGroupState other = (CompactReaderGroupState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ReaderGroupConfig this$config = this.getConfig();
            ReaderGroupConfig other$config = other.getConfig();
            if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
                return false;
            }
            CheckpointState this$checkpointState = this.getCheckpointState();
            CheckpointState other$checkpointState = other.getCheckpointState();
            if (this$checkpointState == null ? other$checkpointState != null : !((Object)this$checkpointState).equals(other$checkpointState)) {
                return false;
            }
            Map<String, Long> this$distanceToTail = this.getDistanceToTail();
            Map<String, Long> other$distanceToTail = other.getDistanceToTail();
            if (this$distanceToTail == null ? other$distanceToTail != null : !((Object)this$distanceToTail).equals(other$distanceToTail)) {
                return false;
            }
            Map<SegmentWithRange, Set<Long>> this$futureSegments = this.getFutureSegments();
            Map<SegmentWithRange, Set<Long>> other$futureSegments = other.getFutureSegments();
            if (this$futureSegments == null ? other$futureSegments != null : !((Object)this$futureSegments).equals(other$futureSegments)) {
                return false;
            }
            Map<String, Map<SegmentWithRange, Long>> this$assignedSegments = this.getAssignedSegments();
            Map<String, Map<SegmentWithRange, Long>> other$assignedSegments = other.getAssignedSegments();
            if (this$assignedSegments == null ? other$assignedSegments != null : !((Object)this$assignedSegments).equals(other$assignedSegments)) {
                return false;
            }
            Map<SegmentWithRange, Long> this$unassignedSegments = this.getUnassignedSegments();
            Map<SegmentWithRange, Long> other$unassignedSegments = other.getUnassignedSegments();
            if (this$unassignedSegments == null ? other$unassignedSegments != null : !((Object)this$unassignedSegments).equals(other$unassignedSegments)) {
                return false;
            }
            Map<SegmentWithRange, Long> this$lastReadPosition = this.getLastReadPosition();
            Map<SegmentWithRange, Long> other$lastReadPosition = other.getLastReadPosition();
            if (this$lastReadPosition == null ? other$lastReadPosition != null : !((Object)this$lastReadPosition).equals(other$lastReadPosition)) {
                return false;
            }
            Map<Segment, Long> this$endSegments = this.getEndSegments();
            Map<Segment, Long> other$endSegments = other.getEndSegments();
            return !(this$endSegments == null ? other$endSegments != null : !((Object)this$endSegments).equals(other$endSegments));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof CompactReaderGroupState;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ReaderGroupConfig $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            CheckpointState $checkpointState = this.getCheckpointState();
            result = result * 59 + ($checkpointState == null ? 43 : ((Object)$checkpointState).hashCode());
            Map<String, Long> $distanceToTail = this.getDistanceToTail();
            result = result * 59 + ($distanceToTail == null ? 43 : ((Object)$distanceToTail).hashCode());
            Map<SegmentWithRange, Set<Long>> $futureSegments = this.getFutureSegments();
            result = result * 59 + ($futureSegments == null ? 43 : ((Object)$futureSegments).hashCode());
            Map<String, Map<SegmentWithRange, Long>> $assignedSegments = this.getAssignedSegments();
            result = result * 59 + ($assignedSegments == null ? 43 : ((Object)$assignedSegments).hashCode());
            Map<SegmentWithRange, Long> $unassignedSegments = this.getUnassignedSegments();
            result = result * 59 + ($unassignedSegments == null ? 43 : ((Object)$unassignedSegments).hashCode());
            Map<SegmentWithRange, Long> $lastReadPosition = this.getLastReadPosition();
            result = result * 59 + ($lastReadPosition == null ? 43 : ((Object)$lastReadPosition).hashCode());
            Map<Segment, Long> $endSegments = this.getEndSegments();
            result = result * 59 + ($endSegments == null ? 43 : ((Object)$endSegments).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.CompactReaderGroupState(config=" + this.getConfig() + ", checkpointState=" + this.getCheckpointState() + ", distanceToTail=" + this.getDistanceToTail() + ", futureSegments=" + this.getFutureSegments() + ", assignedSegments=" + this.getAssignedSegments() + ", unassignedSegments=" + this.getUnassignedSegments() + ", lastReadPosition=" + this.getLastReadPosition() + ", endSegments=" + this.getEndSegments() + ")";
        }

        @ConstructorProperties(value={"config", "checkpointState", "distanceToTail", "futureSegments", "assignedSegments", "unassignedSegments", "lastReadPosition", "endSegments"})
        @SuppressFBWarnings(justification="generated code")
        private CompactReaderGroupState(@NonNull ReaderGroupConfig config, @NonNull CheckpointState checkpointState, @NonNull Map<String, Long> distanceToTail, @NonNull Map<SegmentWithRange, Set<Long>> futureSegments, @NonNull Map<String, Map<SegmentWithRange, Long>> assignedSegments, Map<SegmentWithRange, Long> unassignedSegments, @NonNull Map<SegmentWithRange, Long> lastReadPosition, @NonNull Map<Segment, Long> endSegments) {
            if (config == null) {
                throw new NullPointerException("config is marked @NonNull but is null");
            }
            if (checkpointState == null) {
                throw new NullPointerException("checkpointState is marked @NonNull but is null");
            }
            if (distanceToTail == null) {
                throw new NullPointerException("distanceToTail is marked @NonNull but is null");
            }
            if (futureSegments == null) {
                throw new NullPointerException("futureSegments is marked @NonNull but is null");
            }
            if (assignedSegments == null) {
                throw new NullPointerException("assignedSegments is marked @NonNull but is null");
            }
            if (lastReadPosition == null) {
                throw new NullPointerException("lastReadPosition is marked @NonNull but is null");
            }
            if (endSegments == null) {
                throw new NullPointerException("endSegments is marked @NonNull but is null");
            }
            this.config = config;
            this.checkpointState = checkpointState;
            this.distanceToTail = distanceToTail;
            this.futureSegments = futureSegments;
            this.assignedSegments = assignedSegments;
            this.unassignedSegments = unassignedSegments;
            this.lastReadPosition = lastReadPosition;
            this.endSegments = endSegments;
        }

        static class CompactReaderGroupStateSerializer
        extends VersionedSerializer.WithBuilder<CompactReaderGroupState, CompactReaderGroupStateBuilder> {
            CompactReaderGroupStateSerializer() {
            }

            protected CompactReaderGroupStateBuilder newBuilder() {
                return CompactReaderGroupState.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
            }

            private void read00(RevisionDataInput revisionDataInput, CompactReaderGroupStateBuilder builder) throws IOException {
                RevisionDataInput.ElementDeserializer stringDeserializer = DataInput::readUTF;
                RevisionDataInput.ElementDeserializer longDeserializer = DataInput::readLong;
                RevisionDataInput.ElementDeserializer segmentDeserializer = in -> Segment.fromScopedName(in.readUTF());
                RevisionDataInput.ElementDeserializer segmentWithRangeDeserializer = in -> new SegmentWithRange(Segment.fromScopedName(in.readUTF()), null);
                builder.config(ReaderGroupConfig.fromBytes(ByteBuffer.wrap(revisionDataInput.readArray())));
                builder.checkpointState(CheckpointState.fromBytes(ByteBuffer.wrap(revisionDataInput.readArray())));
                builder.distanceToTail(revisionDataInput.readMap(stringDeserializer, longDeserializer));
                builder.futureSegments(revisionDataInput.readMap(segmentWithRangeDeserializer, in -> (HashSet)in.readCollection(DataInput::readLong, HashSet::new)));
                builder.assignedSegments(revisionDataInput.readMap(stringDeserializer, in -> in.readMap(segmentWithRangeDeserializer, longDeserializer)));
                builder.unassignedSegments(revisionDataInput.readMap(segmentWithRangeDeserializer, longDeserializer));
                builder.endSegments(revisionDataInput.readMap(segmentDeserializer, longDeserializer));
            }

            private void read01(RevisionDataInput revisionDataInput, CompactReaderGroupStateBuilder builder) throws IOException {
                RevisionDataInput.ElementDeserializer segmentDeserializer = in -> Segment.fromScopedName(in.readUTF());
                Map lastReadPos = revisionDataInput.readMap(segmentDeserializer, DataInput::readLong);
                Map ranges = revisionDataInput.readMap(segmentDeserializer, x$0 -> ReaderGroupState.readRange(x$0));
                Function<Map.Entry, SegmentWithRange> keyMapper = e -> new SegmentWithRange(((SegmentWithRange)e.getKey()).getSegment(), (SegmentWithRange.Range)ranges.get(((SegmentWithRange)e.getKey()).getSegment()));
                Map<SegmentWithRange, Set<Long>> fs = builder.futureSegments.entrySet().stream().collect(Collectors.toMap(keyMapper, e -> (Set)e.getValue()));
                builder.futureSegments(fs);
                HashMap<String, Map<SegmentWithRange, Long>> as = new HashMap<String, Map<SegmentWithRange, Long>>();
                for (Map.Entry entry : builder.assignedSegments.entrySet()) {
                    as.put((String)entry.getKey(), ((Map)entry.getValue()).entrySet().stream().collect(Collectors.toMap(keyMapper, e -> (Long)e.getValue())));
                }
                builder.assignedSegments(as);
                LinkedHashMap<SegmentWithRange, Long> us = new LinkedHashMap<SegmentWithRange, Long>();
                for (Map.Entry e2 : builder.unassignedSegments.entrySet()) {
                    us.put(new SegmentWithRange(((SegmentWithRange)e2.getKey()).getSegment(), (SegmentWithRange.Range)ranges.get(((SegmentWithRange)e2.getKey()).getSegment())), (Long)e2.getValue());
                }
                builder.unassignedSegments(us);
                builder.lastReadPosition(lastReadPos.entrySet().stream().collect(Collectors.toMap(e -> new SegmentWithRange((Segment)e.getKey(), (SegmentWithRange.Range)ranges.get(e.getKey())), e -> (Long)e.getValue())));
            }

            private void write00(CompactReaderGroupState object, RevisionDataOutput revisionDataOutput) throws IOException {
                RevisionDataOutput.ElementSerializer stringSerializer = DataOutput::writeUTF;
                RevisionDataOutput.ElementSerializer longSerializer = DataOutput::writeLong;
                RevisionDataOutput.ElementSerializer segmentSerializer = (out, segment) -> out.writeUTF(segment.getScopedName());
                RevisionDataOutput.ElementSerializer segmentWithRangeSerializer = (out, segment) -> out.writeUTF(segment.getSegment().getScopedName());
                revisionDataOutput.writeBuffer((BufferView)new ByteArraySegment(object.config.toBytes()));
                revisionDataOutput.writeBuffer((BufferView)new ByteArraySegment(object.checkpointState.toBytes()));
                revisionDataOutput.writeMap(object.distanceToTail, stringSerializer, longSerializer);
                revisionDataOutput.writeMap(object.futureSegments, segmentWithRangeSerializer, (out, obj) -> out.writeCollection((Collection)obj, DataOutput::writeLong));
                revisionDataOutput.writeMap(object.assignedSegments, stringSerializer, (out, obj) -> out.writeMap(obj, segmentWithRangeSerializer, longSerializer));
                revisionDataOutput.writeMap(object.unassignedSegments, segmentWithRangeSerializer, longSerializer);
                revisionDataOutput.writeMap(object.endSegments, segmentSerializer, longSerializer);
            }

            private void write01(CompactReaderGroupState object, RevisionDataOutput revisionDataOutput) throws IOException {
                HashMap<Segment, SegmentWithRange.Range> ranges = new HashMap<Segment, SegmentWithRange.Range>();
                for (Map.Entry entry : object.futureSegments.entrySet()) {
                    ranges.put(((SegmentWithRange)entry.getKey()).getSegment(), ((SegmentWithRange)entry.getKey()).getRange());
                }
                for (Map.Entry entry : object.assignedSegments.entrySet()) {
                    Set entrySet = ((Map)entry.getValue()).entrySet();
                    for (Map.Entry e : entrySet) {
                        ranges.put(((SegmentWithRange)e.getKey()).getSegment(), ((SegmentWithRange)e.getKey()).getRange());
                    }
                }
                for (Map.Entry e : object.unassignedSegments.entrySet()) {
                    ranges.put(((SegmentWithRange)e.getKey()).getSegment(), ((SegmentWithRange)e.getKey()).getRange());
                }
                for (Map.Entry e : object.lastReadPosition.entrySet()) {
                    ranges.put(((SegmentWithRange)e.getKey()).getSegment(), ((SegmentWithRange)e.getKey()).getRange());
                }
                revisionDataOutput.writeMap(object.lastReadPosition, (out, segment) -> out.writeUTF(segment.getSegment().getScopedName()), DataOutput::writeLong);
                RevisionDataOutput.ElementSerializer segmentSerializer = (out, segment) -> out.writeUTF(segment.getScopedName());
                revisionDataOutput.writeMap(ranges, segmentSerializer, (x$0, x$1) -> ReaderGroupState.writeRange(x$0, x$1));
            }
        }

        @VisibleForTesting
        static class CompactReaderGroupStateBuilder
        implements ObjectBuilder<CompactReaderGroupState> {
            @SuppressFBWarnings(justification="generated code")
            private ReaderGroupConfig config;
            @SuppressFBWarnings(justification="generated code")
            private CheckpointState checkpointState;
            @SuppressFBWarnings(justification="generated code")
            private Map<String, Long> distanceToTail;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, Set<Long>> futureSegments;
            @SuppressFBWarnings(justification="generated code")
            private Map<String, Map<SegmentWithRange, Long>> assignedSegments;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, Long> unassignedSegments;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, Long> lastReadPosition;
            @SuppressFBWarnings(justification="generated code")
            private Map<Segment, Long> endSegments;

            @SuppressFBWarnings(justification="generated code")
            CompactReaderGroupStateBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder config(@NonNull ReaderGroupConfig config) {
                if (config == null) {
                    throw new NullPointerException("config is marked @NonNull but is null");
                }
                this.config = config;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder checkpointState(@NonNull CheckpointState checkpointState) {
                if (checkpointState == null) {
                    throw new NullPointerException("checkpointState is marked @NonNull but is null");
                }
                this.checkpointState = checkpointState;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder distanceToTail(@NonNull Map<String, Long> distanceToTail) {
                if (distanceToTail == null) {
                    throw new NullPointerException("distanceToTail is marked @NonNull but is null");
                }
                this.distanceToTail = distanceToTail;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder futureSegments(@NonNull Map<SegmentWithRange, Set<Long>> futureSegments) {
                if (futureSegments == null) {
                    throw new NullPointerException("futureSegments is marked @NonNull but is null");
                }
                this.futureSegments = futureSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder assignedSegments(@NonNull Map<String, Map<SegmentWithRange, Long>> assignedSegments) {
                if (assignedSegments == null) {
                    throw new NullPointerException("assignedSegments is marked @NonNull but is null");
                }
                this.assignedSegments = assignedSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder unassignedSegments(Map<SegmentWithRange, Long> unassignedSegments) {
                this.unassignedSegments = unassignedSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder lastReadPosition(@NonNull Map<SegmentWithRange, Long> lastReadPosition) {
                if (lastReadPosition == null) {
                    throw new NullPointerException("lastReadPosition is marked @NonNull but is null");
                }
                this.lastReadPosition = lastReadPosition;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupStateBuilder endSegments(@NonNull Map<Segment, Long> endSegments) {
                if (endSegments == null) {
                    throw new NullPointerException("endSegments is marked @NonNull but is null");
                }
                this.endSegments = endSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public CompactReaderGroupState build() {
                return new CompactReaderGroupState(this.config, this.checkpointState, this.distanceToTail, this.futureSegments, this.assignedSegments, this.unassignedSegments, this.lastReadPosition, this.endSegments);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.CompactReaderGroupState.CompactReaderGroupStateBuilder(config=" + this.config + ", checkpointState=" + this.checkpointState + ", distanceToTail=" + this.distanceToTail + ", futureSegments=" + this.futureSegments + ", assignedSegments=" + this.assignedSegments + ", unassignedSegments=" + this.unassignedSegments + ", lastReadPosition=" + this.lastReadPosition + ", endSegments=" + this.endSegments + ")";
            }
        }
    }

    public static class ReaderGroupStateInit
    implements InitialUpdate<ReaderGroupState> {
        private final ReaderGroupConfig config;
        private final Map<SegmentWithRange, Long> startingSegments;
        private final Map<Segment, Long> endSegments;

        @Override
        public ReaderGroupState create(String scopedStreamName, Revision revision) {
            return new ReaderGroupState(scopedStreamName, revision, this.config, this.startingSegments, this.endSegments);
        }

        @SuppressFBWarnings(justification="generated code")
        public static ReaderGroupStateInitBuilder builder() {
            return new ReaderGroupStateInitBuilder();
        }

        @SuppressFBWarnings(justification="generated code")
        public ReaderGroupConfig getConfig() {
            return this.config;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<SegmentWithRange, Long> getStartingSegments() {
            return this.startingSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public Map<Segment, Long> getEndSegments() {
            return this.endSegments;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReaderGroupStateInit)) {
                return false;
            }
            ReaderGroupStateInit other = (ReaderGroupStateInit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ReaderGroupConfig this$config = this.getConfig();
            ReaderGroupConfig other$config = other.getConfig();
            if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
                return false;
            }
            Map<SegmentWithRange, Long> this$startingSegments = this.getStartingSegments();
            Map<SegmentWithRange, Long> other$startingSegments = other.getStartingSegments();
            if (this$startingSegments == null ? other$startingSegments != null : !((Object)this$startingSegments).equals(other$startingSegments)) {
                return false;
            }
            Map<Segment, Long> this$endSegments = this.getEndSegments();
            Map<Segment, Long> other$endSegments = other.getEndSegments();
            return !(this$endSegments == null ? other$endSegments != null : !((Object)this$endSegments).equals(other$endSegments));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ReaderGroupStateInit;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ReaderGroupConfig $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            Map<SegmentWithRange, Long> $startingSegments = this.getStartingSegments();
            result = result * 59 + ($startingSegments == null ? 43 : ((Object)$startingSegments).hashCode());
            Map<Segment, Long> $endSegments = this.getEndSegments();
            result = result * 59 + ($endSegments == null ? 43 : ((Object)$endSegments).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "ReaderGroupState.ReaderGroupStateInit(config=" + this.getConfig() + ", startingSegments=" + this.getStartingSegments() + ", endSegments=" + this.getEndSegments() + ")";
        }

        @ConstructorProperties(value={"config", "startingSegments", "endSegments"})
        @SuppressFBWarnings(justification="generated code")
        public ReaderGroupStateInit(ReaderGroupConfig config, Map<SegmentWithRange, Long> startingSegments, Map<Segment, Long> endSegments) {
            this.config = config;
            this.startingSegments = startingSegments;
            this.endSegments = endSegments;
        }

        static class ReaderGroupStateInitSerializer
        extends VersionedSerializer.WithBuilder<ReaderGroupStateInit, ReaderGroupStateInitBuilder> {
            ReaderGroupStateInitSerializer() {
            }

            protected ReaderGroupStateInitBuilder newBuilder() {
                return ReaderGroupStateInit.builder();
            }

            protected byte getWriteVersion() {
                return 0;
            }

            protected void declareVersions() {
                this.version(0).revision(0, this::write00, this::read00).revision(1, this::write01, this::read01);
            }

            @VisibleForTesting
            void read00(RevisionDataInput revisionDataInput, ReaderGroupStateInitBuilder builder) throws IOException {
                builder.config(ReaderGroupConfig.fromBytes(ByteBuffer.wrap(revisionDataInput.readArray())));
                RevisionDataInput.ElementDeserializer segmentDeserializer = in -> Segment.fromScopedName(in.readUTF());
                RevisionDataInput.ElementDeserializer segmentWithRangeDeserializer = in -> new SegmentWithRange(Segment.fromScopedName(in.readUTF()), null);
                builder.startingSegments(revisionDataInput.readMap(segmentWithRangeDeserializer, DataInput::readLong));
                builder.endSegments(revisionDataInput.readMap(segmentDeserializer, DataInput::readLong));
            }

            private void read01(RevisionDataInput revisionDataInput, ReaderGroupStateInitBuilder builder) throws IOException {
                RevisionDataInput.ElementDeserializer segmentWithRangeDeserializer = in -> {
                    Segment segment = Segment.fromScopedName(in.readUTF());
                    SegmentWithRange.Range range = ReaderGroupState.readRange(in);
                    return new SegmentWithRange(segment, range);
                };
                builder.startingSegments(revisionDataInput.readMap(segmentWithRangeDeserializer, DataInput::readLong));
            }

            @VisibleForTesting
            void write00(ReaderGroupStateInit state, RevisionDataOutput revisionDataOutput) throws IOException {
                revisionDataOutput.writeBuffer((BufferView)new ByteArraySegment(state.config.toBytes()));
                RevisionDataOutput.ElementSerializer segmentWithRangeSerializer = (out, s) -> out.writeUTF(s.getSegment().getScopedName());
                RevisionDataOutput.ElementSerializer segmentSerializer = (out, s) -> out.writeUTF(s.getScopedName());
                revisionDataOutput.writeMap(state.startingSegments, segmentWithRangeSerializer, DataOutput::writeLong);
                revisionDataOutput.writeMap(state.endSegments, segmentSerializer, DataOutput::writeLong);
            }

            private void write01(ReaderGroupStateInit state, RevisionDataOutput revisionDataOutput) throws IOException {
                RevisionDataOutput.ElementSerializer segmentWithRangeSerializer = (out, s) -> {
                    out.writeUTF(s.getSegment().getScopedName());
                    ReaderGroupState.writeRange(out, s.getRange());
                };
                revisionDataOutput.writeMap(state.startingSegments, segmentWithRangeSerializer, DataOutput::writeLong);
            }
        }

        @VisibleForTesting
        static class ReaderGroupStateInitBuilder
        implements ObjectBuilder<ReaderGroupStateInit> {
            @SuppressFBWarnings(justification="generated code")
            private ReaderGroupConfig config;
            @SuppressFBWarnings(justification="generated code")
            private Map<SegmentWithRange, Long> startingSegments;
            @SuppressFBWarnings(justification="generated code")
            private Map<Segment, Long> endSegments;

            @SuppressFBWarnings(justification="generated code")
            ReaderGroupStateInitBuilder() {
            }

            @SuppressFBWarnings(justification="generated code")
            public ReaderGroupStateInitBuilder config(ReaderGroupConfig config) {
                this.config = config;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReaderGroupStateInitBuilder startingSegments(Map<SegmentWithRange, Long> startingSegments) {
                this.startingSegments = startingSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReaderGroupStateInitBuilder endSegments(Map<Segment, Long> endSegments) {
                this.endSegments = endSegments;
                return this;
            }

            @SuppressFBWarnings(justification="generated code")
            public ReaderGroupStateInit build() {
                return new ReaderGroupStateInit(this.config, this.startingSegments, this.endSegments);
            }

            @SuppressFBWarnings(justification="generated code")
            public String toString() {
                return "ReaderGroupState.ReaderGroupStateInit.ReaderGroupStateInitBuilder(config=" + this.config + ", startingSegments=" + this.startingSegments + ", endSegments=" + this.endSegments + ")";
            }
        }
    }
}

