/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamSegmentsWithPredecessors;
import io.pravega.common.hash.HashHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamSegments {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(StreamSegments.class);
    private static final HashHelper HASHER = HashHelper.seededWith((String)"EventRouter");
    private final NavigableMap<Double, SegmentWithRange> segments;
    private final String delegationToken;

    public StreamSegments(NavigableMap<Double, SegmentWithRange> segments, String delegationToken) {
        this.segments = Collections.unmodifiableNavigableMap(segments);
        this.delegationToken = delegationToken;
        this.verifySegments();
    }

    private void verifySegments() {
        if (!this.segments.isEmpty()) {
            Preconditions.checkArgument(((Double)this.segments.firstKey() > 0.0 ? 1 : 0) != 0, (Object)"Nonsense value for segment.");
            Preconditions.checkArgument(((Double)this.segments.lastKey() >= 1.0 ? 1 : 0) != 0, (Object)"Last segment missing.");
            Preconditions.checkArgument(((Double)this.segments.lastKey() < 1.00001 ? 1 : 0) != 0, (Object)"Segments should only go up to 1.0");
        }
    }

    public Segment getSegmentForKey(String key) {
        return this.getSegmentForKey(HASHER.hashToRange(key));
    }

    public Segment getSegmentForKey(double key) {
        Preconditions.checkArgument((key >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((key <= 1.0 ? 1 : 0) != 0);
        return this.segments.ceilingEntry(key).getValue().getSegment();
    }

    public Collection<Segment> getSegments() {
        ArrayList<Segment> result = new ArrayList<Segment>(this.segments.size());
        for (SegmentWithRange seg : this.segments.values()) {
            result.add(seg.getSegment());
        }
        return result;
    }

    public StreamSegments withReplacementRange(Segment segment, StreamSegmentsWithPredecessors replacementRanges) {
        SegmentWithRange replacedSegment = this.findReplacedSegment(segment);
        this.verifyReplacementRange(replacedSegment, replacementRanges);
        TreeMap<Double, SegmentWithRange> result = new TreeMap<Double, SegmentWithRange>();
        Map<Long, List<SegmentWithRange>> replacedRanges = replacementRanges.getReplacementRanges();
        List<SegmentWithRange> replacements = replacedRanges.get(segment.getSegmentId());
        Preconditions.checkNotNull(replacements, (String)"Empty set of replacements for: {}", (long)segment.getSegmentId());
        replacements.sort(Comparator.comparingDouble(s -> s.getRange().getHigh()).reversed());
        this.verifyContinuous(replacements);
        for (Map.Entry existingEntry : this.segments.descendingMap().entrySet()) {
            SegmentWithRange existingSegment = (SegmentWithRange)existingEntry.getValue();
            if (existingSegment.equals(replacedSegment)) {
                for (SegmentWithRange segmentWithRange : replacements) {
                    Double lowerBound = this.segments.lowerKey((Double)existingEntry.getKey());
                    if (lowerBound != null && !(segmentWithRange.getRange().getHigh() >= lowerBound)) continue;
                    result.put(Math.min(segmentWithRange.getRange().getHigh(), (Double)existingEntry.getKey()), segmentWithRange);
                }
                continue;
            }
            result.put((Double)existingEntry.getKey(), (SegmentWithRange)existingEntry.getValue());
        }
        this.removeDuplicates(result);
        return new StreamSegments(result, this.delegationToken);
    }

    private void removeDuplicates(NavigableMap<Double, SegmentWithRange> result) {
        Segment last = null;
        Iterator iterator = result.descendingMap().values().iterator();
        while (iterator.hasNext()) {
            SegmentWithRange current = (SegmentWithRange)iterator.next();
            if (current.getSegment().equals(last)) {
                iterator.remove();
            }
            last = current.getSegment();
        }
    }

    private SegmentWithRange findReplacedSegment(Segment segment) {
        return this.segments.values().stream().filter(withRange -> withRange.getSegment().equals(segment)).findFirst().orElseThrow(() -> new IllegalArgumentException("Segment to be replaced should be present in the segment list"));
    }

    private void verifyReplacementRange(SegmentWithRange replacedSegment, StreamSegmentsWithPredecessors replacementSegments) {
        log.debug("Verification of replacement segments {} with the current segments {}", (Object)replacementSegments, this.segments);
        Map<Long, List<SegmentWithRange>> replacementRanges = replacementSegments.getReplacementRanges();
        List<SegmentWithRange> replacements = replacementRanges.get(replacedSegment.getSegment().getSegmentId());
        Preconditions.checkArgument((replacements != null ? 1 : 0) != 0, (Object)"Replacement segments did not contain replacements for segment being replaced");
        if (replacementRanges.size() == 1) {
            Preconditions.checkArgument((replacedSegment.getRange().getHigh() == this.getUpperBound(replacements) ? 1 : 0) != 0);
            Preconditions.checkArgument((replacedSegment.getRange().getLow() == this.getLowerBound(replacements) ? 1 : 0) != 0);
        } else {
            Preconditions.checkArgument((replacedSegment.getRange().getHigh() <= this.getUpperBound(replacements) ? 1 : 0) != 0);
            Preconditions.checkArgument((replacedSegment.getRange().getLow() >= this.getLowerBound(replacements) ? 1 : 0) != 0);
        }
        for (Map.Entry<Long, List<SegmentWithRange>> ranges : replacementRanges.entrySet()) {
            Map.Entry<Double, SegmentWithRange> upperReplacedSegment = this.segments.floorEntry(this.getUpperBound(ranges.getValue()));
            Map.Entry<Double, SegmentWithRange> lowerReplacedSegment = this.segments.higherEntry(this.getLowerBound(ranges.getValue()));
            Preconditions.checkArgument((upperReplacedSegment != null ? 1 : 0) != 0, (String)"Missing replaced replacement segments %s", (Object)replacementSegments);
            Preconditions.checkArgument((lowerReplacedSegment != null ? 1 : 0) != 0, (String)"Missing replaced replacement segments %s", (Object)replacementSegments);
        }
    }

    private void verifyContinuous(List<SegmentWithRange> newSegments) {
        double previous = newSegments.get(0).getRange().getHigh();
        for (SegmentWithRange s : newSegments) {
            Preconditions.checkArgument((previous == s.getRange().getHigh() ? 1 : 0) != 0, (String)"Replacement segments were not continious: {}", newSegments);
            previous = s.getRange().getLow();
        }
    }

    private double getLowerBound(List<SegmentWithRange> values) {
        double lowerReplacementRange = 1.0;
        for (SegmentWithRange range : values) {
            lowerReplacementRange = Math.min(lowerReplacementRange, range.getRange().getLow());
        }
        return lowerReplacementRange;
    }

    private double getUpperBound(List<SegmentWithRange> value) {
        double upperReplacementRange = 0.0;
        for (SegmentWithRange range : value) {
            upperReplacementRange = Math.max(upperReplacementRange, range.getRange().getHigh());
        }
        return upperReplacementRange;
    }

    public String toString() {
        return "StreamSegments:" + this.segments.toString();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSegments)) {
            return false;
        }
        StreamSegments other = (StreamSegments)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<Segment> this$segments = this.getSegments();
        Collection<Segment> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        String this$delegationToken = this.getDelegationToken();
        String other$delegationToken = other.getDelegationToken();
        return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof StreamSegments;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Segment> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        String $delegationToken = this.getDelegationToken();
        result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String getDelegationToken() {
        return this.delegationToken;
    }
}

