/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.notifications;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.notifications.Listener;
import io.pravega.client.stream.notifications.Notification;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import java.beans.ConstructorProperties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSystem {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(NotificationSystem.class);
    @SuppressFBWarnings(justification="generated code")
    private final Object $lock = new Object[0];
    @GuardedBy(value="$lock")
    private final Multimap<String, ListenerWithExecutor<Notification>> map = ArrayListMultimap.create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Notification> void addListeners(String type, Listener<T> listener, ScheduledExecutorService executor) {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.isListenerPresent(listener)) {
                this.map.put((Object)type, new ListenerWithExecutor<T>(listener, executor));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Notification> void notify(T notification) {
        Object object = this.$lock;
        synchronized (object) {
            String type = notification.getClass().getSimpleName();
            this.map.get((Object)type).forEach(l -> {
                log.info("Executing listener of type: {} for notification: {}", (Object)type, (Object)notification);
                ExecutorServiceHelpers.execute(() -> l.getListener().onNotification(notification), throwable -> log.error("Exception while executing listener for notification: {}", (Object)notification), () -> log.info("Completed execution of notify for notification :{}", (Object)notification), (Executor)l.getExecutor());
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Notification> void removeListener(String type, Listener<T> listener) {
        Object object = this.$lock;
        synchronized (object) {
            this.map.get((Object)type).removeIf(e -> e.getListener().equals(listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(String type) {
        Object object = this.$lock;
        synchronized (object) {
            this.map.removeAll((Object)type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListenerPresent(String type) {
        Object object = this.$lock;
        synchronized (object) {
            return !this.map.get((Object)type).isEmpty();
        }
    }

    private <T extends Notification> boolean isListenerPresent(Listener<T> listener) {
        return this.map.values().stream().anyMatch(le -> le.getListener().equals(listener));
    }

    private class ListenerWithExecutor<T> {
        private final Listener<T> listener;
        private final ScheduledExecutorService executor;

        @ConstructorProperties(value={"listener", "executor"})
        @SuppressFBWarnings(justification="generated code")
        public ListenerWithExecutor(Listener<T> listener, ScheduledExecutorService executor) {
            this.listener = listener;
            this.executor = executor;
        }

        @SuppressFBWarnings(justification="generated code")
        public Listener<T> getListener() {
            return this.listener;
        }

        @SuppressFBWarnings(justification="generated code")
        public ScheduledExecutorService getExecutor() {
            return this.executor;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ListenerWithExecutor)) {
                return false;
            }
            ListenerWithExecutor other = (ListenerWithExecutor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Listener<T> this$listener = this.getListener();
            Listener<T> other$listener = other.getListener();
            if (this$listener == null ? other$listener != null : !this$listener.equals(other$listener)) {
                return false;
            }
            ScheduledExecutorService this$executor = this.getExecutor();
            ScheduledExecutorService other$executor = other.getExecutor();
            return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof ListenerWithExecutor;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Listener<T> $listener = this.getListener();
            result = result * 59 + ($listener == null ? 43 : $listener.hashCode());
            ScheduledExecutorService $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "NotificationSystem.ListenerWithExecutor(listener=" + this.getListener() + ", executor=" + this.getExecutor() + ")";
        }
    }
}

