/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.pravega.client.tables.impl.KeyVersionImpl;
import io.pravega.common.util.ByteBufferUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;

public interface KeyVersion
extends Serializable {
    public static final KeyVersion NOT_EXISTS = new KeyVersion(){
        private static final long serialVersionUID = 1L;

        @Override
        public long getSegmentVersion() {
            return -1L;
        }

        @Override
        public ByteBuffer toBytes() {
            return ByteBufferUtils.EMPTY;
        }

        public String toString() {
            return "NOT_EXISTS";
        }

        private Object readResolve() {
            return NOT_EXISTS;
        }
    };
    public static final KeyVersion NO_VERSION = new KeyVersionImpl(Long.MIN_VALUE);

    public long getSegmentVersion();

    public ByteBuffer toBytes();

    public static KeyVersion fromBytes(ByteBuffer serializedKeyVersion) {
        if (!serializedKeyVersion.hasRemaining()) {
            return NOT_EXISTS;
        }
        return KeyVersionImpl.fromBytes(serializedKeyVersion);
    }
}

