/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.impl.KeyVersion;
import io.pravega.common.ObjectBuilder;
import io.pravega.common.io.serialization.RevisionDataInput;
import io.pravega.common.io.serialization.RevisionDataOutput;
import io.pravega.common.io.serialization.VersionedSerializer;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.ByteArraySegment;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class KeyVersionImpl
implements KeyVersion {
    private static final KeyVersionImplSerializer SERIALIZER = new KeyVersionImplSerializer();
    private final long segmentVersion;

    public KeyVersionImpl(long segmentVersion) {
        this.segmentVersion = segmentVersion;
    }

    @Override
    public ByteBuffer toBytes() {
        ByteArraySegment serialized = SERIALIZER.serialize(this);
        return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
    }

    public static KeyVersionImpl fromBytes(ByteBuffer buff) {
        return (KeyVersionImpl)SERIALIZER.deserialize((ArrayView)new ByteArraySegment(buff));
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(SERIALIZER.serialize(this).getCopy());
    }

    @SuppressFBWarnings(justification="generated code")
    public static KeyVersionBuilder builder() {
        return new KeyVersionBuilder();
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public long getSegmentVersion() {
        return this.segmentVersion;
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyVersionImpl)) {
            return false;
        }
        KeyVersionImpl other = (KeyVersionImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getSegmentVersion() == other.getSegmentVersion();
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof KeyVersionImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $segmentVersion = this.getSegmentVersion();
        result = result * 59 + (int)($segmentVersion >>> 32 ^ $segmentVersion);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    public String toString() {
        return "KeyVersionImpl(segmentVersion=" + this.getSegmentVersion() + ")";
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            return SERIALIZER.deserialize((ArrayView)new ByteArraySegment(this.value));
        }

        @ConstructorProperties(value={"value"})
        @SuppressFBWarnings(justification="generated code")
        public SerializedForm(byte[] value) {
            this.value = value;
        }

        @SuppressFBWarnings(justification="generated code")
        public byte[] getValue() {
            return this.value;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SerializedForm)) {
                return false;
            }
            SerializedForm other = (SerializedForm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.getValue(), other.getValue());
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof SerializedForm;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.getValue());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "KeyVersionImpl.SerializedForm(value=" + Arrays.toString(this.getValue()) + ")";
        }
    }

    public static class KeyVersionImplSerializer
    extends VersionedSerializer.WithBuilder<KeyVersionImpl, KeyVersionBuilder> {
        protected KeyVersionBuilder newBuilder() {
            return KeyVersionImpl.builder();
        }

        protected byte getWriteVersion() {
            return 0;
        }

        protected void declareVersions() {
            this.version(0).revision(0, this::write00, this::read00);
        }

        private void read00(RevisionDataInput revisionDataInput, KeyVersionBuilder builder) throws IOException {
            builder.segmentVersion(revisionDataInput.readLong());
        }

        private void write00(KeyVersionImpl version, RevisionDataOutput revisionDataOutput) throws IOException {
            revisionDataOutput.writeLong(version.getSegmentVersion());
        }
    }

    private static class KeyVersionBuilder
    implements ObjectBuilder<KeyVersionImpl> {
        @SuppressFBWarnings(justification="generated code")
        private long segmentVersion;

        @SuppressFBWarnings(justification="generated code")
        KeyVersionBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        public KeyVersionBuilder segmentVersion(long segmentVersion) {
            this.segmentVersion = segmentVersion;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        public KeyVersionImpl build() {
            return new KeyVersionImpl(this.segmentVersion);
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "KeyVersionImpl.KeyVersionBuilder(segmentVersion=" + this.segmentVersion + ")";
        }
    }
}

