/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.tables.impl.IteratorState;
import io.pravega.client.tables.impl.KeyVersion;
import io.pravega.client.tables.impl.TableEntry;
import io.pravega.client.tables.impl.TableKey;
import io.pravega.common.util.AsyncIterator;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public interface TableSegment<KeyT, ValueT>
extends AutoCloseable {
    public CompletableFuture<KeyVersion> put(TableEntry<KeyT, ValueT> var1);

    public CompletableFuture<Map<KeyT, KeyVersion>> put(Collection<TableEntry<KeyT, ValueT>> var1);

    public CompletableFuture<Void> remove(TableKey<KeyT> var1);

    public CompletableFuture<Void> remove(Collection<TableKey<KeyT>> var1);

    public CompletableFuture<TableEntry<KeyT, ValueT>> get(KeyT var1);

    public CompletableFuture<Map<KeyT, TableEntry<KeyT, ValueT>>> get(Collection<KeyT> var1);

    public AsyncIterator<IteratorItem<TableKey<KeyT>>> keyIterator(IteratorState var1);

    public AsyncIterator<IteratorItem<TableEntry<KeyT, ValueT>>> entryIterator(IteratorState var1);

    @Override
    public void close();

    public static class IteratorItem<T> {
        private final IteratorState state;
        private final List<T> items;

        @ConstructorProperties(value={"state", "items"})
        @SuppressFBWarnings(justification="generated code")
        public IteratorItem(IteratorState state, List<T> items) {
            this.state = state;
            this.items = items;
        }

        @SuppressFBWarnings(justification="generated code")
        public IteratorState getState() {
            return this.state;
        }

        @SuppressFBWarnings(justification="generated code")
        public List<T> getItems() {
            return this.items;
        }

        @SuppressFBWarnings(justification="generated code")
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IteratorItem)) {
                return false;
            }
            IteratorItem other = (IteratorItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            IteratorState this$state = this.getState();
            IteratorState other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            List<T> this$items = this.getItems();
            List<T> other$items = other.getItems();
            return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
        }

        @SuppressFBWarnings(justification="generated code")
        protected boolean canEqual(Object other) {
            return other instanceof IteratorItem;
        }

        @SuppressFBWarnings(justification="generated code")
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            IteratorState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            List<T> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        public String toString() {
            return "TableSegment.IteratorItem(state=" + this.getState() + ", items=" + this.getItems() + ")";
        }
    }
}

