/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.time.Duration;
import lombok.Generated;

public class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final RetentionType retentionType;
    private final long retentionParam;
    private final long retentionMax;

    public static RetentionPolicy byTime(Duration duration) {
        return RetentionPolicy.builder().retentionType(RetentionType.TIME).retentionParam(duration.toMillis()).retentionMax(duration.toMillis()).build();
    }

    public static RetentionPolicy byTime(Duration durationMin, Duration durationMax) {
        return RetentionPolicy.builder().retentionType(RetentionType.TIME).retentionParam(durationMin.toMillis()).retentionMax(durationMax.toMillis()).build();
    }

    public static RetentionPolicy bySizeBytes(long size) {
        return RetentionPolicy.builder().retentionType(RetentionType.SIZE).retentionParam(size).retentionMax(size).build();
    }

    public static RetentionPolicy bySizeBytes(long sizeMin, long sizeMax) {
        return RetentionPolicy.builder().retentionType(RetentionType.SIZE).retentionParam(sizeMin).retentionMax(sizeMax).build();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static RetentionPolicyBuilder builder() {
        return new RetentionPolicyBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public RetentionType getRetentionType() {
        return this.retentionType;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRetentionParam() {
        return this.retentionParam;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getRetentionMax() {
        return this.retentionMax;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetentionPolicy)) {
            return false;
        }
        RetentionPolicy other = (RetentionPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RetentionType this$retentionType = this.getRetentionType();
        RetentionType other$retentionType = other.getRetentionType();
        if (this$retentionType == null ? other$retentionType != null : !((Object)((Object)this$retentionType)).equals((Object)other$retentionType)) {
            return false;
        }
        if (this.getRetentionParam() != other.getRetentionParam()) {
            return false;
        }
        return this.getRetentionMax() == other.getRetentionMax();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RetentionPolicy;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RetentionType $retentionType = this.getRetentionType();
        result = result * 59 + ($retentionType == null ? 43 : ((Object)((Object)$retentionType)).hashCode());
        long $retentionParam = this.getRetentionParam();
        result = result * 59 + (int)($retentionParam >>> 32 ^ $retentionParam);
        long $retentionMax = this.getRetentionMax();
        result = result * 59 + (int)($retentionMax >>> 32 ^ $retentionMax);
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "RetentionPolicy(retentionType=" + (Object)((Object)this.getRetentionType()) + ", retentionParam=" + this.getRetentionParam() + ", retentionMax=" + this.getRetentionMax() + ")";
    }

    @ConstructorProperties(value={"retentionType", "retentionParam", "retentionMax"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private RetentionPolicy(RetentionType retentionType, long retentionParam, long retentionMax) {
        this.retentionType = retentionType;
        this.retentionParam = retentionParam;
        this.retentionMax = retentionMax;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class RetentionPolicyBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private RetentionType retentionType;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long retentionParam;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long retentionMax;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        RetentionPolicyBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicyBuilder retentionType(RetentionType retentionType) {
            this.retentionType = retentionType;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicyBuilder retentionParam(long retentionParam) {
            this.retentionParam = retentionParam;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicyBuilder retentionMax(long retentionMax) {
            this.retentionMax = retentionMax;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public RetentionPolicy build() {
            return new RetentionPolicy(this.retentionType, this.retentionParam, this.retentionMax);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "RetentionPolicy.RetentionPolicyBuilder(retentionType=" + (Object)((Object)this.retentionType) + ", retentionParam=" + this.retentionParam + ", retentionMax=" + this.retentionMax + ")";
        }
    }

    public static enum RetentionType {
        TIME,
        SIZE;

    }
}

