/**
 * Copyright (c) Dell Inc., or its subsidiaries. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 */
package io.pravega.client.stream.notifications;

/**
 * Listener interface for receiving notifications.
 * @param <T> Notification type.
 */
@FunctionalInterface
public interface Listener<T> {
    void onNotification(T notification);
}
