/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Scheduled;
import java.beans.ConstructorProperties;
import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import lombok.Generated;

public class ScheduledQueue<E extends Scheduled>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final AtomicLong itemsAdded = new AtomicLong(0L);
    private final AtomicLong itemsRemoved = new AtomicLong(0L);
    private final ConcurrentSkipListMap<FireTime, E> delayedTasks = new ConcurrentSkipListMap();
    private final ConcurrentLinkedQueue<E> readyTasks = new ConcurrentLinkedQueue();
    private final Semaphore blocker = new Semaphore(1);

    @Override
    public E take() throws InterruptedException {
        return (E)this.poll(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long startTime;
        boolean ignored = this.blocker.tryAcquire();
        Scheduled result = (Scheduled)this.readyTasks.poll();
        if (result != null) {
            this.itemsRemoved.incrementAndGet();
            return (E)result;
        }
        long now = startTime = System.nanoTime();
        while (now - startTime <= timeout) {
            Map.Entry<FireTime, E> delayed = this.delayedTasks.firstEntry();
            if (delayed != null && delayed.getKey().getTimeNanos() <= now) {
                if (!this.delayedTasks.remove(delayed.getKey(), delayed.getValue())) continue;
                Map.Entry<FireTime, E> next = this.delayedTasks.firstEntry();
                if (next != null && next.getKey().timeNanos <= now) {
                    this.blocker.release();
                }
                this.itemsRemoved.incrementAndGet();
                return (E)((Scheduled)delayed.getValue());
            }
            ignored = this.blocker.tryAcquire(this.sleepTimeout(timeout, startTime, now, delayed), TimeUnit.NANOSECONDS);
            result = (Scheduled)this.readyTasks.poll();
            if (result != null) {
                this.itemsRemoved.incrementAndGet();
                return (E)result;
            }
            now = System.nanoTime();
        }
        return null;
    }

    @Override
    public E poll() {
        Map.Entry<FireTime, E> delayed;
        boolean ignored = this.blocker.tryAcquire();
        Scheduled result = (Scheduled)this.readyTasks.poll();
        if (result != null) {
            this.itemsRemoved.incrementAndGet();
            return (E)result;
        }
        do {
            if ((delayed = this.delayedTasks.firstEntry()) != null && delayed.getKey().getTimeNanos() <= System.nanoTime()) continue;
            return null;
        } while (!this.delayedTasks.remove(delayed.getKey(), delayed.getValue()));
        this.itemsRemoved.incrementAndGet();
        return (E)((Scheduled)delayed.getValue());
    }

    private long sleepTimeout(long timeout, long startTime, long now, Map.Entry<FireTime, E> delayed) {
        long sleepTimeout = timeout - (now - startTime);
        if (delayed != null) {
            sleepTimeout = Math.min(sleepTimeout, delayed.getKey().getTimeNanos() - now);
        }
        return sleepTimeout;
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(E e) {
        long seq = this.itemsAdded.incrementAndGet();
        if (!e.isDelayed()) {
            this.readyTasks.add(e);
        } else {
            this.delayedTasks.put(new FireTime(e.getScheduledTimeNanos(), seq), e);
        }
        this.blocker.release();
        return true;
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        return this.offer(e);
    }

    @Override
    public void put(E e) {
        this.offer(e);
    }

    @Override
    public E peek() {
        Scheduled ready = (Scheduled)this.readyTasks.peek();
        if (ready == null) {
            Map.Entry<FireTime, E> result = this.delayedTasks.firstEntry();
            if (result == null) {
                return null;
            }
            return (E)((Scheduled)result.getValue());
        }
        return (E)ready;
    }

    @Override
    public int size() {
        return (int)Long.min(this.itemsAdded.get() - this.itemsRemoved.get(), Integer.MAX_VALUE);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        ArrayList<Scheduled> result = new ArrayList<Scheduled>();
        for (Scheduled val : this.readyTasks) {
            result.add(val);
        }
        for (Scheduled val : this.delayedTasks.values()) {
            result.add(val);
        }
        return result.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        if (this.readyTasks.remove(o)) {
            this.itemsRemoved.incrementAndGet();
            return true;
        }
        if (this.delayedTasks.values().remove(o)) {
            this.itemsRemoved.incrementAndGet();
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return Iterators.unmodifiableIterator((Iterator)Iterators.concat(this.readyTasks.iterator(), this.delayedTasks.values().iterator()));
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        Object item;
        int itemCount;
        this.blocker.drainPermits();
        for (itemCount = 0; itemCount < maxElements && (item = (Scheduled)this.readyTasks.poll()) != null; ++itemCount) {
            c.add(item);
        }
        while (itemCount < maxElements && (item = this.delayedTasks.pollFirstEntry()) != null) {
            c.add(item.getValue());
            ++itemCount;
        }
        this.itemsRemoved.addAndGet(itemCount);
        this.blocker.release();
        return itemCount;
    }

    public List<E> drainDelayed() {
        ArrayList<Scheduled> result = new ArrayList<Scheduled>();
        Map.Entry<FireTime, E> item = this.delayedTasks.pollFirstEntry();
        while (item != null) {
            result.add((Scheduled)item.getValue());
            this.itemsRemoved.incrementAndGet();
            item = this.delayedTasks.pollFirstEntry();
        }
        return result;
    }

    private static final class FireTime
    implements Comparable<FireTime> {
        private final long timeNanos;
        private final long sequenceNumber;

        @Override
        public int compareTo(FireTime other) {
            if (this.timeNanos < other.timeNanos) {
                return -1;
            }
            if (this.timeNanos > other.timeNanos) {
                return 1;
            }
            return Long.compare(this.sequenceNumber, other.sequenceNumber);
        }

        @ConstructorProperties(value={"timeNanos", "sequenceNumber"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public FireTime(long timeNanos, long sequenceNumber) {
            this.timeNanos = timeNanos;
            this.sequenceNumber = sequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getTimeNanos() {
            return this.timeNanos;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getSequenceNumber() {
            return this.sequenceNumber;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FireTime)) {
                return false;
            }
            FireTime other = (FireTime)o;
            if (this.getTimeNanos() != other.getTimeNanos()) {
                return false;
            }
            return this.getSequenceNumber() == other.getSequenceNumber();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeNanos = this.getTimeNanos();
            result = result * 59 + (int)($timeNanos >>> 32 ^ $timeNanos);
            long $sequenceNumber = this.getSequenceNumber();
            result = result * 59 + (int)($sequenceNumber >>> 32 ^ $sequenceNumber);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ScheduledQueue.FireTime(timeNanos=" + this.getTimeNanos() + ", sequenceNumber=" + this.getSequenceNumber() + ")";
        }
    }
}

