/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.concurrent;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.concurrent.Scheduled;
import io.pravega.common.concurrent.ScheduledQueue;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolScheduledExecutorService
extends AbstractExecutorService
implements ScheduledExecutorService {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolScheduledExecutorService.class);
    private static final AtomicLong COUNTER = new AtomicLong(0L);
    private final ThreadPoolExecutor runner;
    @VisibleForTesting
    private final ScheduledQueue<ScheduledRunnable<?>> queue = new ScheduledQueue();

    public ThreadPoolScheduledExecutorService(int corePoolSize, ThreadFactory threadFactory) {
        ScheduledQueue<Runnable> queue = this.queue;
        this.runner = new ThreadPoolExecutor(corePoolSize, corePoolSize, 100L, TimeUnit.MILLISECONDS, queue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
        this.runner.prestartAllCoreThreads();
    }

    @Override
    public void shutdown() {
        this.cancelDelayed();
        this.runner.shutdown();
    }

    private boolean cancel(ScheduledRunnable<?> task) {
        if (this.queue.remove(task)) {
            ((ScheduledRunnable)task).future.cancel(false);
            return true;
        }
        return false;
    }

    private void cancelDelayed() {
        for (ScheduledRunnable<?> item : this.queue.drainDelayed()) {
            ((ScheduledRunnable)item).future.cancel(false);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.cancelDelayed();
        return this.runner.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.runner.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.runner.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.runner.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.runner.execute(new ScheduledRunnable(Executors.callable(command)));
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ScheduledRunnable task = new ScheduledRunnable(Executors.callable(command), delay, unit);
        this.runner.execute(task);
        return new CancelableFuture(task);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ScheduledRunnable task = new ScheduledRunnable(callable, delay, unit);
        this.runner.execute(task);
        return new CancelableFuture(task);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        FixedRateLoop loop = new FixedRateLoop(command, period, unit);
        ScheduledRunnable task = new ScheduledRunnable(loop, initialDelay, unit);
        this.runner.execute(task);
        return loop;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        FixedDelayLoop loop = new FixedDelayLoop(command, delay, unit);
        ScheduledRunnable task = new ScheduledRunnable(loop, initialDelay, unit);
        this.runner.execute(task);
        return loop;
    }

    ThreadFactory getThreadFactory() {
        return this.runner.getThreadFactory();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ThreadPoolScheduledExecutorService(runner=" + this.getRunner() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ThreadPoolExecutor getRunner() {
        return this.runner;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ScheduledQueue<ScheduledRunnable<?>> getQueue() {
        return this.queue;
    }

    static /* synthetic */ AtomicLong access$400() {
        return COUNTER;
    }

    private class FixedRateLoop
    extends ScheduleLoop {
        private final long periodNanos;
        private final AtomicLong startTimeNanos;

        public FixedRateLoop(Runnable command, long period, TimeUnit unit) {
            super(command);
            this.startTimeNanos = new AtomicLong(System.nanoTime());
            this.periodNanos = unit.toNanos(period);
        }

        @Override
        public long getDelay(TimeUnit returnUnit) {
            return returnUnit.convert(this.periodNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public Void call() {
            this.startTimeNanos.set(System.nanoTime());
            return super.call();
        }

        @Override
        ScheduledFuture<Void> schedule() {
            ScheduledRunnable task = new ScheduledRunnable((Callable)this, this.startTimeNanos.get() + this.periodNanos);
            ThreadPoolScheduledExecutorService.this.runner.execute(task);
            return new CancelableFuture<Void>(task);
        }
    }

    private class FixedDelayLoop
    extends ScheduleLoop {
        private final long delay;
        private final TimeUnit unit;

        public FixedDelayLoop(Runnable command, long delay, TimeUnit unit) {
            super(command);
            this.delay = delay;
            this.unit = unit;
        }

        @Override
        public long getDelay(TimeUnit returnUnit) {
            return returnUnit.convert(this.delay, this.unit);
        }

        @Override
        ScheduledFuture<Void> schedule() {
            return ThreadPoolScheduledExecutorService.this.schedule(this, this.delay, this.unit);
        }
    }

    private abstract class ScheduleLoop
    implements Callable<Void>,
    ScheduledFuture<Void> {
        final Runnable command;
        final AtomicBoolean canceled = new AtomicBoolean(false);
        final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
        final AtomicReference<ScheduledFuture<Void>> scheduledFuture = new AtomicReference();

        @Override
        public Void call() {
            if (!this.canceled.get()) {
                try {
                    this.command.run();
                }
                catch (Throwable t) {
                    this.canceled.set(true);
                    log.error("Exception thrown out of root of recurring task: " + this.command + " This task will not run again!", t);
                    this.shutdownFuture.completeExceptionally(t);
                    return null;
                }
                if (!this.canceled.get()) {
                    try {
                        this.scheduledFuture.set(this.schedule());
                    }
                    catch (RejectedExecutionException e) {
                        log.debug("Shutting down task {} because pool {} has shutdown.", (Object)this.command, (Object)ThreadPoolScheduledExecutorService.this.runner);
                        this.cancel(false);
                    }
                }
            }
            return null;
        }

        abstract ScheduledFuture<Void> schedule();

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.canceled.getAndSet(true)) {
                return false;
            }
            ScheduledFuture<Void> future = this.scheduledFuture.get();
            if (future != null) {
                future.cancel(mayInterruptIfRunning);
            }
            this.shutdownFuture.completeExceptionally(new CancellationException());
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.canceled.get();
        }

        @Override
        public boolean isDone() {
            return this.canceled.get();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            return this.shutdownFuture.get();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.shutdownFuture.get(timeout, unit);
        }

        @ConstructorProperties(value={"command"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ScheduleLoop(Runnable command) {
            this.command = command;
        }
    }

    private static final class ScheduledRunnable<R>
    implements Runnable,
    Scheduled {
        private final long id = ThreadPoolScheduledExecutorService.access$400().incrementAndGet();
        private final boolean isDelayed;
        private final long scheduledTimeNanos;
        private final Callable<R> task;
        private final CompletableFuture<R> future;

        private ScheduledRunnable(Callable<R> task) {
            this.isDelayed = false;
            this.scheduledTimeNanos = 0L;
            this.task = task;
            this.future = new CompletableFuture();
        }

        private ScheduledRunnable(Callable<R> task, long delay, TimeUnit unit) {
            this.isDelayed = true;
            this.scheduledTimeNanos = unit.toNanos(delay) + System.nanoTime();
            this.task = task;
            this.future = new CompletableFuture();
        }

        private ScheduledRunnable(Callable<R> task, long scheduledTimeNanos) {
            this.isDelayed = true;
            this.scheduledTimeNanos = scheduledTimeNanos;
            this.task = task;
            this.future = new CompletableFuture();
        }

        @Override
        public void run() {
            try {
                this.future.complete(this.task.call());
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getId() {
            return this.id;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean isDelayed() {
            return this.isDelayed;
        }

        @Override
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public long getScheduledTimeNanos() {
            return this.scheduledTimeNanos;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Callable<R> getTask() {
            return this.task;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CompletableFuture<R> getFuture() {
            return this.future;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScheduledRunnable)) {
                return false;
            }
            ScheduledRunnable other = (ScheduledRunnable)o;
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.isDelayed() != other.isDelayed()) {
                return false;
            }
            return this.getScheduledTimeNanos() == other.getScheduledTimeNanos();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $id = this.getId();
            result = result * 59 + (int)($id >>> 32 ^ $id);
            result = result * 59 + (this.isDelayed() ? 79 : 97);
            long $scheduledTimeNanos = this.getScheduledTimeNanos();
            result = result * 59 + (int)($scheduledTimeNanos >>> 32 ^ $scheduledTimeNanos);
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ThreadPoolScheduledExecutorService.ScheduledRunnable(id=" + this.getId() + ", isDelayed=" + this.isDelayed() + ", scheduledTimeNanos=" + this.getScheduledTimeNanos() + ", task=" + this.getTask() + ", future=" + this.getFuture() + ")";
        }
    }

    private final class CancelableFuture<R>
    implements ScheduledFuture<R> {
        private final ScheduledRunnable<R> task;

        @Override
        public long getDelay(TimeUnit unit) {
            if (!((ScheduledRunnable)this.task).isDelayed) {
                return 0L;
            }
            return unit.convert(((ScheduledRunnable)this.task).scheduledTimeNanos - System.nanoTime(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof CancelableFuture) {
                return Long.compare(((ScheduledRunnable)this.task).scheduledTimeNanos, ((ScheduledRunnable)((CancelableFuture)other).task).scheduledTimeNanos);
            }
            long diff = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return ThreadPoolScheduledExecutorService.this.cancel(this.task);
        }

        @Override
        public boolean isCancelled() {
            return ((ScheduledRunnable)this.task).future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return ((ScheduledRunnable)this.task).future.isDone();
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            return (R)((ScheduledRunnable)this.task).future.get();
        }

        @Override
        public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return (R)((ScheduledRunnable)this.task).future.get(timeout, unit);
        }

        @ConstructorProperties(value={"task"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public CancelableFuture(ScheduledRunnable<R> task) {
            this.task = task;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CancelableFuture)) {
                return false;
            }
            CancelableFuture other = (CancelableFuture)o;
            ScheduledRunnable<R> this$task = this.task;
            ScheduledRunnable<R> other$task = other.task;
            return !(this$task == null ? other$task != null : !((Object)this$task).equals(other$task));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ScheduledRunnable<R> $task = this.task;
            result = result * 59 + ($task == null ? 43 : ((Object)$task).hashCode());
            return result;
        }
    }
}

