/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.ArrayView;
import io.pravega.common.util.BufferViewBuilder;
import io.pravega.common.util.CompositeBufferView;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;

public interface BufferView {
    public int getLength();

    public Reader getBufferViewReader();

    public InputStream getReader();

    public InputStream getReader(int var1, int var2);

    default public BufferView slice() {
        return this;
    }

    public BufferView slice(int var1, int var2);

    public byte[] getCopy();

    public void copyTo(OutputStream var1) throws IOException;

    public int copyTo(ByteBuffer var1);

    default public void retain() {
    }

    default public void release() {
    }

    public <ExceptionT extends Exception> void collect(Collector<ExceptionT> var1) throws ExceptionT;

    public Iterator<ByteBuffer> iterateBuffers();

    public static BufferView wrap(List<BufferView> components) {
        if (components.size() == 0) {
            return BufferView.empty();
        }
        if (components.size() == 1) {
            return components.get(0).slice();
        }
        return new CompositeBufferView(components);
    }

    public static BufferViewBuilder builder() {
        return BufferView.builder(10);
    }

    public static BufferViewBuilder builder(int expectedComponentCount) {
        return new BufferViewBuilder(expectedComponentCount);
    }

    public static BufferView empty() {
        return AbstractBufferView.EMPTY;
    }

    @FunctionalInterface
    public static interface Collector<ExceptionT extends Exception> {
        public void accept(ByteBuffer var1) throws ExceptionT;
    }

    public static interface Reader {
        public int available();

        public int readBytes(ByteBuffer var1);

        public byte readByte();

        public int readInt();

        public long readLong();

        public BufferView readSlice(int var1);

        @VisibleForTesting
        public ArrayView readFully(int var1);

        public static class OutOfBoundsException
        extends IndexOutOfBoundsException {
            public OutOfBoundsException() {
            }

            public OutOfBoundsException(String message) {
                super(message);
            }
        }
    }
}

