/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.Exceptions;
import io.pravega.common.util.AbstractBufferView;
import io.pravega.common.util.BufferView;
import io.pravega.common.util.CompositeArrayView;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import lombok.NonNull;

public class CompositeByteArraySegment
extends AbstractBufferView
implements CompositeArrayView {
    private static final BufferLayout DEFAULT_BUFFER_LAYOUT = new BufferLayout(12);
    private final int startOffset;
    private final BufferLayout bufferLayout;
    private final ByteBuffer[] buffers;
    private final int length;

    @VisibleForTesting
    public CompositeByteArraySegment(int length) {
        this(length, DEFAULT_BUFFER_LAYOUT);
    }

    public CompositeByteArraySegment(int length, BufferLayout bufferLayout) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be a non-negative number.");
        this.length = length;
        this.bufferLayout = bufferLayout;
        this.startOffset = 0;
        int count = length / this.bufferLayout.bufferSize + (length % this.bufferLayout.bufferSize == 0 ? 0 : 1);
        this.buffers = new ByteBuffer[count];
    }

    @VisibleForTesting
    public CompositeByteArraySegment(@NonNull byte[] source) {
        this(new ByteBuffer[]{ByteBuffer.wrap(source)}, BufferLayout.fromLength(source.length), 0, source.length);
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
    }

    private CompositeByteArraySegment(ByteBuffer[] buffers, BufferLayout bufferLayout, int startOffset, int length) {
        this.buffers = buffers;
        this.bufferLayout = bufferLayout;
        this.startOffset = startOffset;
        this.length = length;
    }

    @Override
    public byte get(int offset) {
        ByteBuffer bb = this.getBuffer(this.getBufferId(offset), false);
        return bb == null ? (byte)0 : bb.array()[this.getBufferOffset(offset)];
    }

    @Override
    public void set(int offset, byte value) {
        ByteBuffer bb = this.getBuffer(this.getBufferId(offset), true);
        bb.array()[this.getBufferOffset((int)offset)] = value;
    }

    @Override
    public void setShort(int offset, short value) {
        Exceptions.checkArrayRange(offset, 2, this.length, "index", "length");
        int bufferId = this.getBufferId(offset);
        ByteBuffer bb = this.getBuffer(bufferId, true);
        int bufferOffset = this.getBufferOffset(offset);
        if (bufferOffset <= this.bufferLayout.maxShortOffset) {
            bb.putShort(bufferOffset, value);
        } else {
            bb.array()[bufferOffset] = (byte)(value >>> 8 & 0xFF);
            this.getBuffer((int)(bufferId + 1), (boolean)true).array()[0] = (byte)(value & 0xFF);
        }
    }

    @Override
    public void setInt(int offset, int value) {
        Exceptions.checkArrayRange(offset, 4, this.length, "index", "length");
        int bufferId = this.getBufferId(offset);
        ByteBuffer bb = this.getBuffer(bufferId, true);
        int bufferOffset = this.getBufferOffset(offset);
        if (bufferOffset <= this.bufferLayout.maxIntOffset) {
            bb.putInt(bufferOffset, value);
        } else {
            this.setValue(value, 32, bb.array(), bufferId, bufferOffset);
        }
    }

    @Override
    public void setLong(int offset, long value) {
        Exceptions.checkArrayRange(offset, 8, this.length, "index", "length");
        int bufferId = this.getBufferId(offset);
        ByteBuffer bb = this.getBuffer(bufferId, true);
        int bufferOffset = this.getBufferOffset(offset);
        if (bufferOffset <= this.bufferLayout.maxLongOffset) {
            bb.putLong(bufferOffset, value);
        } else {
            this.setValue(value, 64, bb.array(), bufferId, bufferOffset);
        }
    }

    private void setValue(long value, int bits, byte[] array, int bufferId, int bufferOffset) {
        assert (bits / 8 > 0 && bits % 8 == 0);
        while (bits > 0) {
            array[bufferOffset] = (byte)(value >>> (bits -= 8));
            if (++bufferOffset < this.bufferLayout.bufferSize) continue;
            bufferOffset = 0;
            array = this.getBuffer(bufferId + 1, true).array();
        }
    }

    @Override
    public CompositeReader getBufferViewReader() {
        return new CompositeReader();
    }

    @Override
    public InputStream getReader() {
        ArrayList streams = new ArrayList();
        this.collect((array, offset, length) -> streams.add(new ByteArrayInputStream(array, offset, length)), this.length);
        return new SequenceInputStream(Iterators.asEnumeration(streams.iterator()));
    }

    @Override
    public InputStream getReader(int offset, int length) {
        return this.slice(offset, length).getReader();
    }

    @Override
    public CompositeArrayView slice(int offset, int length) {
        Exceptions.checkArrayRange(offset, length, this.length, "offset", "length");
        if (offset == 0 && length == this.length) {
            return this;
        }
        return new CompositeByteArraySegment(this.buffers, this.bufferLayout, this.startOffset + offset, length);
    }

    @Override
    public <ExceptionT extends Exception> void collect(BufferView.Collector<ExceptionT> bufferCollector) throws ExceptionT {
        this.collect((array, offset, len) -> bufferCollector.accept(ByteBuffer.wrap(array, offset, len)), this.length);
    }

    private <ExceptionT extends Exception> void collect(ArrayCollector<ExceptionT> collectArray, int length) throws ExceptionT {
        if (length == 0) {
            return;
        }
        int startId = this.getBufferId(0);
        int endId = this.getBufferId(length - 1);
        int bufferOffset = this.getBufferOffset(0);
        for (int bufferId = startId; bufferId <= endId; ++bufferId) {
            int arrayLength = Math.min(length, this.bufferLayout.bufferSize - bufferOffset);
            ByteBuffer bb = this.getBuffer(bufferId, false);
            if (bb == null) {
                collectArray.accept(new byte[arrayLength], 0, arrayLength);
            } else {
                collectArray.accept(bb.array(), bufferOffset, arrayLength);
            }
            length -= arrayLength;
            bufferOffset = 0;
        }
        assert (length == 0) : "Collection finished but " + length + " bytes remaining";
    }

    @Override
    public Iterator<ByteBuffer> iterateBuffers() {
        if (this.length == 0) {
            return Collections.emptyIterator();
        }
        AtomicInteger arrayOffset = new AtomicInteger(this.getBufferOffset(0));
        AtomicInteger length = new AtomicInteger(this.length);
        return Arrays.stream(this.buffers, this.getBufferId(0), this.getBufferId(this.length - 1) + 1).map(o -> {
            int arrayLength = Math.min(length.get(), this.bufferLayout.bufferSize - arrayOffset.get());
            byte[] b = o == null ? new byte[arrayLength] : o.array();
            ByteBuffer bb = ByteBuffer.wrap(b, arrayOffset.get(), arrayLength);
            arrayOffset.set(0);
            length.addAndGet(-arrayLength);
            return bb;
        }).iterator();
    }

    @Override
    public int getComponentCount() {
        return this.length == 0 ? 0 : (this.startOffset + this.length - 1) / this.bufferLayout.bufferSize - this.startOffset / this.bufferLayout.bufferSize + 1;
    }

    @Override
    public byte[] getCopy() {
        byte[] result = new byte[this.length];
        this.copyTo(ByteBuffer.wrap(result));
        return result;
    }

    @Override
    public void copyFrom(BufferView.Reader source, int targetOffset, int length) {
        Preconditions.checkArgument((length <= source.available() ? 1 : 0) != 0, (Object)"length exceeds source input's length.");
        Exceptions.checkArrayRange(targetOffset, length, this.length, "offset", "length");
        int bufferOffset = this.getBufferOffset(targetOffset);
        int bufferId = this.getBufferId(targetOffset);
        while (length > 0) {
            ByteBuffer bb = this.getBuffer(bufferId, true);
            bb.position(bufferOffset);
            bb.limit(Math.min(bb.limit(), bb.position() + length));
            int copyLength = source.readBytes(bb);
            bb.position(0).limit(this.bufferLayout.bufferSize);
            length -= copyLength;
            if ((bufferOffset += copyLength) < bb.array().length) continue;
            ++bufferId;
            bufferOffset = 0;
        }
    }

    @Override
    public void copyTo(OutputStream target) throws IOException {
        this.collect(target::write, this.length);
    }

    @Override
    public int copyTo(ByteBuffer target) {
        int length = Math.min(this.length, target.remaining());
        this.collect(target::put, length);
        return length;
    }

    @VisibleForTesting
    int getAllocatedArrayCount() {
        return (int)Arrays.stream(this.buffers).filter(Objects::nonNull).count();
    }

    private int getBufferOffset(int offset) {
        return this.startOffset + offset & this.bufferLayout.bufferOffsetMask;
    }

    private int getBufferId(int offset) {
        Preconditions.checkElementIndex((int)offset, (int)this.length, (String)"offset");
        return this.startOffset + offset >> this.bufferLayout.bufferSizeBits;
    }

    private ByteBuffer getBuffer(int arrayId, boolean allocate) {
        ByteBuffer a = this.buffers[arrayId];
        if (a == null && allocate) {
            this.buffers[arrayId] = a = ByteBuffer.wrap(new byte[this.bufferLayout.bufferSize]);
        }
        return a;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getLength() {
        return this.length;
    }

    public static class BufferLayout {
        private static final int MIN_BIT_COUNT = 3;
        private static final int MAX_BIT_COUNT = 31;
        private final int bufferSize;
        private final int bufferSizeBits;
        private final int bufferOffsetMask;
        private final int maxLongOffset;
        private final int maxIntOffset;
        private final int maxShortOffset;

        public BufferLayout(int bufferSizeBits) {
            Preconditions.checkArgument((bufferSizeBits >= 3 && bufferSizeBits < 31 ? 1 : 0) != 0, (String)"bufferSizeBits must be a number in the range [%s, %s).", (int)3, (int)31);
            this.bufferSizeBits = bufferSizeBits;
            this.bufferSize = 1 << this.bufferSizeBits;
            this.bufferOffsetMask = this.bufferSize - 1;
            this.maxLongOffset = this.bufferSize - 8;
            this.maxIntOffset = this.bufferSize - 4;
            this.maxShortOffset = this.bufferSize - 2;
        }

        @VisibleForTesting
        static BufferLayout fromLength(int bufferLength) {
            Preconditions.checkArgument((bufferLength >= 0 ? 1 : 0) != 0, (Object)"arrayLength must be a non-negative number.");
            int bitCount = 0;
            while (bufferLength != 0) {
                bufferLength >>>= 1;
                ++bitCount;
            }
            if (bitCount < 3) {
                bitCount = 3;
            }
            return new BufferLayout(bitCount);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getBufferSize() {
            return this.bufferSize;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getBufferSizeBits() {
            return this.bufferSizeBits;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getBufferOffsetMask() {
            return this.bufferOffsetMask;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getMaxLongOffset() {
            return this.maxLongOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getMaxIntOffset() {
            return this.maxIntOffset;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        int getMaxShortOffset() {
            return this.maxShortOffset;
        }
    }

    @FunctionalInterface
    private static interface ArrayCollector<ExceptionT extends Exception> {
        public void accept(byte[] var1, int var2, int var3) throws ExceptionT;
    }

    private class CompositeReader
    extends AbstractBufferView.AbstractReader
    implements BufferView.Reader {
        private int position = 0;

        private CompositeReader() {
        }

        @Override
        public int available() {
            return CompositeByteArraySegment.this.length - this.position;
        }

        @Override
        public int readBytes(ByteBuffer byteBuffer) {
            int len = Math.min(this.available(), byteBuffer.remaining());
            if (len > 0) {
                CompositeByteArraySegment.this.slice(this.position, len).copyTo(byteBuffer);
                this.position += len;
            }
            return len;
        }

        @Override
        public byte readByte() {
            try {
                return CompositeByteArraySegment.this.get(this.position++);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }

        @Override
        public int readInt() {
            int arrayPos = CompositeByteArraySegment.this.getBufferOffset(this.position);
            if (CompositeByteArraySegment.this.bufferLayout.bufferSize - arrayPos >= 4) {
                int nextPos = this.position + 4;
                if (nextPos > CompositeByteArraySegment.this.length) {
                    throw new BufferView.Reader.OutOfBoundsException();
                }
                ByteBuffer bb = CompositeByteArraySegment.this.getBuffer(CompositeByteArraySegment.this.getBufferId(this.position), false);
                int r = bb == null ? 0 : bb.getInt(arrayPos);
                this.position = nextPos;
                return r;
            }
            return super.readInt();
        }

        @Override
        public long readLong() {
            int arrayPos = CompositeByteArraySegment.this.getBufferOffset(this.position);
            if (CompositeByteArraySegment.this.bufferLayout.bufferSize - arrayPos >= 8) {
                int nextPos = this.position + 8;
                if (nextPos > CompositeByteArraySegment.this.length) {
                    throw new BufferView.Reader.OutOfBoundsException();
                }
                ByteBuffer bb = CompositeByteArraySegment.this.getBuffer(CompositeByteArraySegment.this.getBufferId(this.position), false);
                long r = bb == null ? 0L : bb.getLong(arrayPos);
                this.position = nextPos;
                return r;
            }
            return super.readLong();
        }

        @Override
        public BufferView readSlice(int length) {
            try {
                CompositeArrayView result = CompositeByteArraySegment.this.slice(this.position, length);
                this.position += length;
                return result;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new BufferView.Reader.OutOfBoundsException();
            }
        }
    }
}

