/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.KeyValueTableInfo;
import io.pravega.client.admin.KeyValueTableManager;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.SocketConnectionFactoryImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.common.concurrent.ExecutorServiceHelpers;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import io.pravega.common.util.BlockingAsyncIterator;
import io.pravega.shaded.com.google.common.annotations.Beta;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shared.NameUtils;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class KeyValueTableManagerImpl
implements KeyValueTableManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueTableManagerImpl.class);
    private final Controller controller;
    private final ConnectionFactory connectionFactory;
    private final ScheduledExecutorService executor;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public KeyValueTableManagerImpl(@NonNull ClientConfig clientConfig) {
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked non-null but is null");
        }
        this.executor = ExecutorServiceHelpers.newScheduledThreadPool(1, "KeyValueTableManagerImpl-Controller");
        this.controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(clientConfig).build(), this.executor);
        this.connectionFactory = new SocketConnectionFactoryImpl(clientConfig);
    }

    @VisibleForTesting
    KeyValueTableManagerImpl(@NonNull Controller controller, @NonNull ConnectionFactory connectionFactory) {
        if (controller == null) {
            throw new NullPointerException("controller is marked non-null but is null");
        }
        if (connectionFactory == null) {
            throw new NullPointerException("connectionFactory is marked non-null but is null");
        }
        this.executor = null;
        this.controller = controller;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.connectionFactory != null) {
                this.connectionFactory.close();
            }
            if (this.executor != null) {
                ExecutorServiceHelpers.shutdown(this.executor);
            }
            if (this.controller != null) {
                this.controller.close();
            }
        }
    }

    @Override
    public boolean createKeyValueTable(@NonNull String scopeName, @NonNull String keyValueTableName, @NonNull KeyValueTableConfiguration config) {
        if (scopeName == null) {
            throw new NullPointerException("scopeName is marked non-null but is null");
        }
        if (keyValueTableName == null) {
            throw new NullPointerException("keyValueTableName is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        Exceptions.checkNotClosed(this.closed.get(), this);
        NameUtils.validateUserKeyValueTableName(keyValueTableName);
        NameUtils.validateUserScopeName(scopeName);
        log.info("Creating scope/key-value-table: {}/{} with configuration: {}", new Object[]{scopeName, keyValueTableName, config});
        return Futures.getThrowingException(this.controller.createKeyValueTable(scopeName, keyValueTableName, config));
    }

    @Override
    public boolean deleteKeyValueTable(@NonNull String scopeName, @NonNull String keyValueTableName) {
        if (scopeName == null) {
            throw new NullPointerException("scopeName is marked non-null but is null");
        }
        if (keyValueTableName == null) {
            throw new NullPointerException("keyValueTableName is marked non-null but is null");
        }
        Exceptions.checkNotClosed(this.closed.get(), this);
        NameUtils.validateUserKeyValueTableName(keyValueTableName);
        NameUtils.validateUserScopeName(scopeName);
        log.info("Deleting scope/key-value-table: {}/{}", (Object)scopeName, (Object)keyValueTableName);
        return Futures.getThrowingException(this.controller.deleteKeyValueTable(scopeName, keyValueTableName));
    }

    @Override
    public Iterator<KeyValueTableInfo> listKeyValueTables(@NonNull String scopeName) {
        if (scopeName == null) {
            throw new NullPointerException("scopeName is marked non-null but is null");
        }
        Exceptions.checkNotClosed(this.closed.get(), this);
        NameUtils.validateUserScopeName(scopeName);
        log.info("Listing key-value-tables in scope: {}", (Object)scopeName);
        AsyncIterator<KeyValueTableInfo> asyncIterator = this.controller.listKeyValueTables(scopeName);
        return new BlockingAsyncIterator<KeyValueTableInfo>(asyncIterator);
    }
}

