/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.admin.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.ClientConfig;
import io.pravega.client.admin.ReaderGroupManager;
import io.pravega.client.connection.impl.ConnectionFactory;
import io.pravega.client.connection.impl.ConnectionPoolImpl;
import io.pravega.client.control.impl.Controller;
import io.pravega.client.control.impl.ControllerImpl;
import io.pravega.client.control.impl.ControllerImplConfig;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.SynchronizerConfig;
import io.pravega.client.state.Update;
import io.pravega.client.stream.InvalidStreamException;
import io.pravega.client.stream.ReaderGroup;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.Serializer;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.impl.AbstractClientFactoryImpl;
import io.pravega.client.stream.impl.ClientFactoryImpl;
import io.pravega.client.stream.impl.ReaderGroupImpl;
import io.pravega.client.stream.impl.ReaderGroupState;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamImpl;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.ByteArraySegment;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shared.NameUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderGroupManagerImpl
implements ReaderGroupManager {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReaderGroupManagerImpl.class);
    private final String scope;
    private final AbstractClientFactoryImpl clientFactory;
    private final Controller controller;

    public ReaderGroupManagerImpl(String scope, ClientConfig config, ConnectionFactory connectionFactory) {
        this.scope = scope;
        this.controller = new ControllerImpl(ControllerImplConfig.builder().clientConfig(config).build(), connectionFactory.getInternalExecutor());
        ConnectionPoolImpl connectionPool = new ConnectionPoolImpl(config, connectionFactory);
        this.clientFactory = new ClientFactoryImpl(scope, this.controller, connectionPool);
    }

    public ReaderGroupManagerImpl(String scope, Controller controller, AbstractClientFactoryImpl clientFactory) {
        this.scope = scope;
        this.clientFactory = clientFactory;
        this.controller = controller;
    }

    private Stream createStreamHelper(String streamName, StreamConfiguration config) {
        Futures.getAndHandleExceptions(this.controller.createStream(this.scope, streamName, StreamConfiguration.builder().scalingPolicy(config.getScalingPolicy()).build()), RuntimeException::new);
        return new StreamImpl(this.scope, streamName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createReaderGroup(String groupName, ReaderGroupConfig config) {
        log.info("Creating reader group: {} for streams: {} with configuration: {}", new Object[]{groupName, Arrays.toString(config.getStartingStreamCuts().keySet().toArray()), config});
        NameUtils.validateReaderGroupName(groupName);
        this.createStreamHelper(NameUtils.getStreamForReaderGroup(groupName), StreamConfiguration.builder().scalingPolicy(ScalingPolicy.fixed(1)).build());
        ReaderGroupConfig ctrlConfig = Futures.getThrowingException(this.controller.createReaderGroup(this.scope, groupName, config));
        StateSynchronizer<ReaderGroupState> synchronizer = this.clientFactory.createStateSynchronizer(NameUtils.getStreamForReaderGroup(groupName), new ReaderGroupStateUpdatesSerializer(), new ReaderGroupStateInitSerializer(), SynchronizerConfig.builder().build());
        try {
            Map<SegmentWithRange, Long> segments = ReaderGroupImpl.getSegmentsForStreams(this.controller, ctrlConfig);
            synchronizer.initialize(new ReaderGroupState.ReaderGroupStateInit(ctrlConfig, segments, ReaderGroupImpl.getEndSegmentsForStreams(ctrlConfig), false));
        }
        finally {
            if (Collections.singletonList(synchronizer).get(0) != null) {
                synchronizer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteReaderGroup(String groupName) {
        UUID groupId = null;
        try {
            StateSynchronizer synchronizer = this.clientFactory.createStateSynchronizer(NameUtils.getStreamForReaderGroup(groupName), new ReaderGroupStateUpdatesSerializer(), new ReaderGroupStateInitSerializer(), SynchronizerConfig.builder().build());
            try {
                synchronizer.fetchUpdates();
                groupId = ((ReaderGroupState)synchronizer.getState()).getConfig().getReaderGroupId();
            }
            finally {
                if (Collections.singletonList(synchronizer).get(0) != null) {
                    synchronizer.close();
                }
            }
        }
        catch (InvalidStreamException ex) {
            log.warn("State-Synchronizer Stream for ReaderGroup {} was not found.", (Object)NameUtils.getScopedReaderGroupName(this.scope, groupName));
            groupId = Futures.getAndHandleExceptions(this.controller.getReaderGroupConfig(this.scope, groupName), RuntimeException::new).getReaderGroupId();
        }
        Futures.getAndHandleExceptions(this.controller.deleteReaderGroup(this.scope, groupName, groupId), RuntimeException::new);
    }

    @Override
    public ReaderGroup getReaderGroup(String groupName) {
        SynchronizerConfig synchronizerConfig = SynchronizerConfig.builder().build();
        return new ReaderGroupImpl(this.scope, groupName, synchronizerConfig, new ReaderGroupStateInitSerializer(), new ReaderGroupStateUpdatesSerializer(), this.clientFactory, this.controller, this.clientFactory.getConnectionPool());
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    @VisibleForTesting
    public static class ReaderGroupStateUpdatesSerializer
    implements Serializer<Update<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupUpdateSerializer serializer = new ReaderGroupState.ReaderGroupUpdateSerializer();

        @Override
        public ByteBuffer serialize(Update<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public Update<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (Update)this.serializer.deserialize(new ByteArraySegment(serializedValue));
        }
    }

    @VisibleForTesting
    public static class ReaderGroupStateInitSerializer
    implements Serializer<InitialUpdate<ReaderGroupState>> {
        private final ReaderGroupState.ReaderGroupInitSerializer serializer = new ReaderGroupState.ReaderGroupInitSerializer();

        @Override
        public ByteBuffer serialize(InitialUpdate<ReaderGroupState> value) {
            ByteArraySegment serialized = this.serializer.serialize(value);
            return ByteBuffer.wrap(serialized.array(), serialized.arrayOffset(), serialized.getLength());
        }

        @Override
        public InitialUpdate<ReaderGroupState> deserialize(ByteBuffer serializedValue) {
            return (InitialUpdate)this.serializer.deserialize(new ByteArraySegment(serializedValue));
        }
    }
}

