/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.batch.SegmentRange;
import io.pravega.client.segment.impl.Segment;
import io.pravega.shaded.com.google.common.annotations.Beta;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import lombok.Generated;
import lombok.NonNull;

@Beta
public class SegmentRangeImpl
implements SegmentRange {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Segment segment;
    private final long startOffset;
    private final long endOffset;

    @Override
    public long getSegmentId() {
        return this.segment.getSegmentId();
    }

    @Override
    public String getStreamName() {
        return this.segment.getStreamName();
    }

    @Override
    public String getScope() {
        return this.segment.getScope();
    }

    @Override
    public SegmentRangeImpl asImpl() {
        return this;
    }

    @ConstructorProperties(value={"segment", "startOffset", "endOffset"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    SegmentRangeImpl(@NonNull Segment segment, long startOffset, long endOffset) {
        if (segment == null) {
            throw new NullPointerException("segment is marked non-null but is null");
        }
        this.segment = segment;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SegmentRangeImplBuilder builder() {
        return new SegmentRangeImplBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SegmentRangeImpl(segment=" + this.getSegment() + ", startOffset=" + this.getStartOffset() + ", endOffset=" + this.getEndOffset() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SegmentRangeImpl)) {
            return false;
        }
        SegmentRangeImpl other = (SegmentRangeImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Segment this$segment = this.getSegment();
        Segment other$segment = other.getSegment();
        if (this$segment == null ? other$segment != null : !((Object)this$segment).equals(other$segment)) {
            return false;
        }
        if (this.getStartOffset() != other.getStartOffset()) {
            return false;
        }
        return this.getEndOffset() == other.getEndOffset();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SegmentRangeImpl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Segment $segment = this.getSegment();
        result = result * 59 + ($segment == null ? 43 : ((Object)$segment).hashCode());
        long $startOffset = this.getStartOffset();
        result = result * 59 + (int)($startOffset >>> 32 ^ $startOffset);
        long $endOffset = this.getEndOffset();
        result = result * 59 + (int)($endOffset >>> 32 ^ $endOffset);
        return result;
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    Segment getSegment() {
        return this.segment;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getStartOffset() {
        return this.startOffset;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getEndOffset() {
        return this.endOffset;
    }

    public static final class SegmentRangeImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Segment segment;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long startOffset;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private long endOffset;

        public SegmentRangeImpl build() {
            Preconditions.checkState(this.startOffset <= this.endOffset, "Start offset should be less than end offset.");
            return new SegmentRangeImpl(this.segment, this.startOffset, this.endOffset);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SegmentRangeImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentRangeImplBuilder segment(@NonNull Segment segment) {
            if (segment == null) {
                throw new NullPointerException("segment is marked non-null but is null");
            }
            this.segment = segment;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentRangeImplBuilder startOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SegmentRangeImplBuilder endOffset(long endOffset) {
            this.endOffset = endOffset;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SegmentRangeImpl.SegmentRangeImplBuilder(segment=" + this.segment + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
        }
    }
}

