/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.batch.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.batch.SegmentRange;
import io.pravega.client.batch.StreamSegmentsIterator;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.StreamCut;
import io.pravega.shaded.com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class StreamSegmentsInfoImpl
implements StreamSegmentsIterator {
    @NonNull
    private final StreamCut startStreamCut;
    @NonNull
    private final StreamCut endStreamCut;
    @NonNull
    private final Iterator<SegmentRange> segmentRangeIterator;

    @Override
    public Iterator<SegmentRange> getIterator() {
        return this.segmentRangeIterator;
    }

    @Override
    public StreamCut getStartStreamCut() {
        return this.startStreamCut;
    }

    @Override
    public StreamCut getEndStreamCut() {
        return this.endStreamCut;
    }

    @Override
    public StreamSegmentsInfoImpl asImpl() {
        return this;
    }

    static void validateStreamCuts(StreamCut startStreamCut, StreamCut endStreamCut) {
        Preconditions.checkArgument(startStreamCut.asImpl().getStream().equals(endStreamCut.asImpl().getStream()), "startStreamCut and endStreamCut should be for the same stream.");
        Map<Segment, Long> startSegments = startStreamCut.asImpl().getPositions();
        Map<Segment, Long> endSegments = endStreamCut.asImpl().getPositions();
        startSegments.keySet().stream().filter(endSegments::containsKey).forEach(s2 -> Preconditions.checkState((Long)startSegments.get(s2) <= (Long)endSegments.get(s2), "Segment offset in startStreamCut should be <= segment offset in endStreamCut."));
    }

    @ConstructorProperties(value={"startStreamCut", "endStreamCut", "segmentRangeIterator"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    StreamSegmentsInfoImpl(@NonNull StreamCut startStreamCut, @NonNull StreamCut endStreamCut, @NonNull Iterator<SegmentRange> segmentRangeIterator) {
        if (startStreamCut == null) {
            throw new NullPointerException("startStreamCut is marked non-null but is null");
        }
        if (endStreamCut == null) {
            throw new NullPointerException("endStreamCut is marked non-null but is null");
        }
        if (segmentRangeIterator == null) {
            throw new NullPointerException("segmentRangeIterator is marked non-null but is null");
        }
        this.startStreamCut = startStreamCut;
        this.endStreamCut = endStreamCut;
        this.segmentRangeIterator = segmentRangeIterator;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static StreamSegmentsInfoImplBuilder builder() {
        return new StreamSegmentsInfoImplBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StreamSegmentsInfoImpl(startStreamCut=" + this.getStartStreamCut() + ", endStreamCut=" + this.getEndStreamCut() + ", segmentRangeIterator=" + this.segmentRangeIterator + ")";
    }

    public static final class StreamSegmentsInfoImplBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private StreamCut startStreamCut;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private StreamCut endStreamCut;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Iterator<SegmentRange> segmentRangeIterator;

        public StreamSegmentsInfoImpl build() {
            StreamSegmentsInfoImpl.validateStreamCuts(this.startStreamCut, this.endStreamCut);
            return new StreamSegmentsInfoImpl(this.startStreamCut, this.endStreamCut, this.segmentRangeIterator);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        StreamSegmentsInfoImplBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentsInfoImplBuilder startStreamCut(@NonNull StreamCut startStreamCut) {
            if (startStreamCut == null) {
                throw new NullPointerException("startStreamCut is marked non-null but is null");
            }
            this.startStreamCut = startStreamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentsInfoImplBuilder endStreamCut(@NonNull StreamCut endStreamCut) {
            if (endStreamCut == null) {
                throw new NullPointerException("endStreamCut is marked non-null but is null");
            }
            this.endStreamCut = endStreamCut;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public StreamSegmentsInfoImplBuilder segmentRangeIterator(@NonNull Iterator<SegmentRange> segmentRangeIterator) {
            if (segmentRangeIterator == null) {
                throw new NullPointerException("segmentRangeIterator is marked non-null but is null");
            }
            this.segmentRangeIterator = segmentRangeIterator;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "StreamSegmentsInfoImpl.StreamSegmentsInfoImplBuilder(startStreamCut=" + this.startStreamCut + ", endStreamCut=" + this.endStreamCut + ", segmentRangeIterator=" + this.segmentRangeIterator + ")";
        }
    }
}

