/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.byteStream.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.byteStream.ByteStreamWriter;
import io.pravega.client.byteStream.impl.ByteStreamWriterImpl;
import io.pravega.common.util.ByteBufferUtils;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import lombok.NonNull;

public class BufferedByteStreamWriterImpl
extends ByteStreamWriter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    @VisibleForTesting
    public static final int BUFFER_SIZE = 4096;
    @NonNull
    private final ByteStreamWriterImpl out;
    @GuardedBy(value="$lock")
    private ByteBuffer buffer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(4096);
            }
            this.buffer.put((byte)b);
            if (!this.buffer.hasRemaining()) {
                this.commitBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuffer src) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.commitBuffer();
            int position = src.position();
            while (src.hasRemaining()) {
                int length = Math.min(0x800008, src.remaining());
                ByteBuffer slice = ByteBufferUtils.slice(src, position, length);
                this.out.write(slice);
                src.position(position += length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.write(ByteBuffer.wrap(b, off, len));
        }
    }

    private void commitBuffer() throws IOException {
        if (this.buffer != null) {
            this.buffer.flip();
            if (this.buffer.hasRemaining()) {
                this.out.write(this.buffer);
                this.buffer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.commitBuffer();
            this.out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.commitBuffer();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAndSeal() throws IOException {
        Object object = this.$lock;
        synchronized (object) {
            this.commitBuffer();
            this.out.closeAndSeal();
        }
    }

    @Override
    public long fetchTailOffset() {
        return this.out.fetchTailOffset();
    }

    @Override
    public void truncateDataBefore(long offset) {
        this.out.truncateDataBefore(offset);
    }

    @ConstructorProperties(value={"out"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BufferedByteStreamWriterImpl(@NonNull ByteStreamWriterImpl out) {
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        this.out = out;
    }
}

