/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import io.pravega.common.ExponentialMovingAverage;
import io.pravega.common.MathHelpers;
import io.pravega.common.util.EnvVars;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shared.protocol.netty.AppendBatchSizeTracker;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class AppendBatchSizeTrackerImpl
implements AppendBatchSizeTracker {
    @VisibleForTesting
    static final int MAX_BATCH_SIZE = EnvVars.readIntegerFromEnvVar("PRAVEGA_MAX_BATCH_SIZE", 523264);
    @VisibleForTesting
    static final int BASE_TIME_NANOS = EnvVars.readIntegerFromEnvVar("PRAVEGA_BATCH_BASE_TIME_NANOS", 0);
    @VisibleForTesting
    static final int BASE_SIZE = EnvVars.readIntegerFromEnvVar("PRAVEGA_BATCH_BASE_SIZE", 0);
    @VisibleForTesting
    static final double OUTSTANDING_FRACTION = 1.0 / (double)EnvVars.readIntegerFromEnvVar("PRAVEGA_BATCH_OUTSTANDING_DENOMINATOR", 2);
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final Supplier<Long> clock;
    private final AtomicLong lastAppendNumber;
    private final AtomicLong lastAppendTime;
    private final AtomicLong lastAckNumber;
    private final ExponentialMovingAverage eventSize = new ExponentialMovingAverage(1024.0, 0.01, true);
    private final ExponentialMovingAverage nanosBetweenAppends = new ExponentialMovingAverage(1.0E7, 0.001, false);
    private final ExponentialMovingAverage appendsOutstanding = new ExponentialMovingAverage(20.0, 0.001, false);

    public AppendBatchSizeTrackerImpl() {
        this.clock = System::nanoTime;
        this.lastAppendTime = new AtomicLong(this.clock.get());
        this.lastAckNumber = new AtomicLong(0L);
        this.lastAppendNumber = new AtomicLong(0L);
    }

    @Override
    public void recordAppend(long eventNumber, int size) {
        long now = Math.max(this.lastAppendTime.get(), this.clock.get());
        long last = this.lastAppendTime.getAndSet(now);
        this.lastAppendNumber.set(eventNumber);
        this.nanosBetweenAppends.addNewSample(now - last);
        this.eventSize.addNewSample(size);
    }

    @Override
    public long recordAck(long eventNumber) {
        this.lastAckNumber.getAndSet(eventNumber);
        long outstandingAppendCount = this.lastAppendNumber.get() - eventNumber;
        this.appendsOutstanding.addNewSample(outstandingAppendCount);
        return outstandingAppendCount;
    }

    @Override
    public int getAppendBlockSize() {
        long numInflight = this.lastAppendNumber.get() - this.lastAckNumber.get();
        if (numInflight <= 1L) {
            return 0;
        }
        double nanosPerAppend = this.nanosBetweenAppends.getCurrentValue();
        double appendsInMaxBatchTime = Math.max(1.0, 2.0E7 / nanosPerAppend);
        double appendsInTime = Math.max(0.0, (double)BASE_TIME_NANOS / nanosPerAppend);
        double appendsInBatch = MathHelpers.minMax(this.appendsOutstanding.getCurrentValue() * OUTSTANDING_FRACTION + appendsInTime, 1.0, appendsInMaxBatchTime);
        int size = (int)(appendsInBatch * this.eventSize.getCurrentValue()) + BASE_SIZE;
        return MathHelpers.minMax(size, 0, MAX_BATCH_SIZE);
    }

    @Override
    public int getBatchTimeout() {
        return 20;
    }
}

