/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.connection.impl.ClientConnection;
import io.pravega.client.connection.impl.FlowHandler;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shared.protocol.netty.Append;
import io.pravega.shared.protocol.netty.ConnectionFailedException;
import io.pravega.shared.protocol.netty.WireCommand;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;

public class FlowClientConnection
implements ClientConnection {
    private final String connectionName;
    @VisibleForTesting
    private final ClientConnection channel;
    private final int flowId;
    private final FlowHandler handler;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @Override
    public void send(WireCommand cmd) throws ConnectionFailedException {
        if (this.closed.get()) {
            throw new ConnectionFailedException("Connection is closed");
        }
        this.channel.send(cmd);
    }

    @Override
    public void send(Append append) throws ConnectionFailedException {
        if (this.closed.get()) {
            throw new ConnectionFailedException("Connection is closed");
        }
        this.channel.send(append);
    }

    @Override
    public void sendAsync(List<Append> appends, ClientConnection.CompletedCallback callback) {
        if (this.closed.get()) {
            callback.complete(new ConnectionFailedException("Connection is closed"));
        } else {
            this.channel.sendAsync(appends, callback);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.handler.closeFlow(this);
        }
    }

    @ConstructorProperties(value={"connectionName", "channel", "flowId", "handler"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public FlowClientConnection(String connectionName, ClientConnection channel, int flowId, FlowHandler handler) {
        this.connectionName = connectionName;
        this.channel = channel;
        this.flowId = flowId;
        this.handler = handler;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ClientConnection getChannel() {
        return this.channel;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getFlowId() {
        return this.flowId;
    }
}

