/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.connection.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.common.MathHelpers;
import io.pravega.shaded.com.google.common.annotations.VisibleForTesting;
import io.pravega.shaded.com.google.common.base.Preconditions;
import io.pravega.shaded.io.netty.buffer.ByteBuf;
import io.pravega.shaded.io.netty.buffer.Unpooled;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;
import lombok.Generated;

@NotThreadSafe
class IoBuffer {
    private final int maxBufferSize = 0xFFFFFF;
    @VisibleForTesting
    private ByteBuffer buffer = null;

    IoBuffer() {
    }

    private ByteBuf sliceOut(int size) {
        ByteBuf result = Unpooled.wrappedBuffer(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), size);
        this.buffer.position(this.buffer.position() + size);
        if (!this.buffer.hasRemaining()) {
            this.buffer = null;
        }
        return result;
    }

    public ByteBuf getBuffOfSize(InputStream in, int size) throws IOException {
        int read;
        Preconditions.checkArgument(size <= 0xFFFFFF, "Requested buffer size {} is larger than max allowd {}", size, 0xFFFFFF);
        if (size == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (this.buffer == null) {
            int bufferSize = MathHelpers.minMax(in.available(), size, 0xFFFFFF);
            byte[] newBuffer = new byte[bufferSize];
            int read2 = in.read(newBuffer);
            if (read2 <= -1) {
                throw new EOFException();
            }
            this.buffer = ByteBuffer.wrap(newBuffer, 0, read2);
        }
        if (this.buffer.remaining() >= size) {
            return this.sliceOut(size);
        }
        int firstSize = this.buffer.remaining();
        ByteBuf first = this.sliceOut(firstSize);
        assert (this.buffer == null);
        byte[] remaining = new byte[size - firstSize];
        for (int offset = 0; offset < remaining.length; offset += read) {
            read = in.read(remaining, offset, remaining.length - offset);
            if (read > -1) continue;
            throw new EOFException();
        }
        return Unpooled.wrappedBuffer(first, Unpooled.wrappedBuffer(remaining));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    ByteBuffer getBuffer() {
        return this.buffer;
    }
}

